/*
 * Decompiled with CFR 0.152.
 */
package de.flipper1406.futureleague_wirtschaft.Tools.Ampeln;

import de.flipper1406.futureleague_wirtschaft.Tools.Ampeln.Ampel;
import de.flipper1406.futureleague_wirtschaft.Tools.Ampeln.AmpelManager;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.plugin.Plugin;

public class AmpelRunnable {
    private final AmpelManager manager;
    private int phase = 0;
    private static final LightColor[][] NORTH_SOUTH_PHASES = new LightColor[][]{{LightColor.RED, LightColor.OFF, LightColor.OFF}, {LightColor.RED, LightColor.YELLOW, LightColor.OFF}, {LightColor.OFF, LightColor.OFF, LightColor.GREEN}, {LightColor.OFF, LightColor.YELLOW, LightColor.OFF}};
    private static final LightColor[][] EAST_WEST_PHASES = new LightColor[][]{{LightColor.OFF, LightColor.OFF, LightColor.GREEN}, {LightColor.OFF, LightColor.YELLOW, LightColor.OFF}, {LightColor.RED, LightColor.OFF, LightColor.OFF}, {LightColor.RED, LightColor.YELLOW, LightColor.OFF}};
    private static final int[] PHASE_DURATIONS = new int[]{600, 40, 600, 40};

    public AmpelRunnable(AmpelManager ampelManager) {
        this.manager = ampelManager;
    }

    public void start() {
        this.scheduleNextPhase();
    }

    public void scheduleNextPhase() {
        for (Ampel ampel : this.manager.getAmpeln()) {
            if (!ampel.isChunkLoaded()) continue;
            Block red = ampel.getRed();
            Block yellow = ampel.getYellow();
            Block green = ampel.getGreen();
            LightColor[][] phases = switch (ampel.getType()) {
                default -> throw new IncompatibleClassChangeError();
                case Ampel.AmpelType.NORTH_SOUTH -> NORTH_SOUTH_PHASES;
                case Ampel.AmpelType.EAST_WEST -> EAST_WEST_PHASES;
            };
            LightColor[] current = phases[this.phase];
            red.setType(current[0].getMaterial());
            yellow.setType(current[1].getMaterial());
            green.setType(current[2].getMaterial());
        }
        int delay = PHASE_DURATIONS[this.phase];
        this.phase = (this.phase + 1) % PHASE_DURATIONS.length;
        this.manager.getPlugin().getServer().getScheduler().runTaskLater((Plugin)this.manager.getPlugin(), this::scheduleNextPhase, (long)delay);
    }

    public static enum LightColor {
        RED(Material.RED_WOOL),
        YELLOW(Material.YELLOW_WOOL),
        GREEN(Material.LIME_WOOL),
        OFF(Material.BLACK_WOOL);

        private final Material mat;

        private LightColor(Material material) {
            this.mat = material;
        }

        public Material getMaterial() {
            return this.mat;
        }
    }
}

