/*
 * Decompiled with CFR 0.152.
 */
package de.flipper1406.futureleague_wirtschaft.Userdata.Utils;

import de.flipper1406.futureleague_wirtschaft.futureLeagueWirtschaft;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class UserDataManager {
    private static futureLeagueWirtschaft plugin;

    public static void init(futureLeagueWirtschaft pluginInstance) {
        plugin = pluginInstance;
    }

    public static File getDataFolder() {
        return new File(plugin.getDataFolder(), "Playerdata");
    }

    public static File getPlayerFile(UUID uuid) {
        return new File(UserDataManager.getDataFolder(), uuid.toString() + "/playerdata.yml");
    }

    public static File getTransactionFile(UUID uuid) {
        return new File(UserDataManager.getDataFolder(), uuid.toString() + "/transactions.yml");
    }

    public static File getJobFile(UUID uuid) {
        return new File(UserDataManager.getDataFolder(), uuid.toString() + "/jobs.yml");
    }

    public static File getStudiumFile(UUID uuid) {
        return new File(UserDataManager.getDataFolder(), uuid.toString() + "/studium.yml");
    }

    public static FileConfiguration getPlayerConfig(UUID uuid) {
        return YamlConfiguration.loadConfiguration((File)UserDataManager.getPlayerFile(uuid));
    }

    public static FileConfiguration getTransactionConfig(UUID uuid) {
        return YamlConfiguration.loadConfiguration((File)UserDataManager.getTransactionFile(uuid));
    }

    public static FileConfiguration getStudiumConfig(UUID uuid) {
        return YamlConfiguration.loadConfiguration((File)UserDataManager.getStudiumFile(uuid));
    }

    public static FileConfiguration getJobConfig(UUID uuid) {
        return YamlConfiguration.loadConfiguration((File)UserDataManager.getJobFile(uuid));
    }

    public static void savePlayerConfig(UUID uuid, FileConfiguration config) {
        try {
            config.save(UserDataManager.getPlayerFile(uuid));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void saveTransactionConfig(UUID uuid, FileConfiguration config) {
        try {
            config.save(UserDataManager.getTransactionFile(uuid));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void saveStudiumConfig(UUID uuid, FileConfiguration config) {
        try {
            config.save(UserDataManager.getTransactionFile(uuid));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void saveJobConfig(UUID uuid, FileConfiguration config) {
        try {
            config.save(UserDataManager.getTransactionFile(uuid));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void setupPlayerData(Player player) {
        UUID uuid = player.getUniqueId();
        File playerFolder = new File(UserDataManager.getDataFolder(), uuid.toString());
        if (!playerFolder.exists()) {
            playerFolder.mkdirs();
        }
        try {
            File studiumFile;
            File jobFile;
            File transFile;
            File playerFile = UserDataManager.getPlayerFile(uuid);
            if (!playerFile.exists()) {
                playerFile.createNewFile();
                YamlConfiguration config = YamlConfiguration.loadConfiguration((File)playerFile);
                config.set("Username", (Object)player.getName());
                config.set("Kontostand", (Object)200.0);
                config.set("lastLogoutLocation", null);
                config.set("lastLogoutTime", null);
                config.set("lastKnownIPs", new ArrayList());
                config.set("region", (Object)"Unknown");
                config.save(playerFile);
            }
            if (!(transFile = UserDataManager.getTransactionFile(uuid)).exists()) {
                transFile.createNewFile();
                YamlConfiguration transConfig = YamlConfiguration.loadConfiguration((File)transFile);
                transConfig.set("transactions", new ArrayList());
                transConfig.save(transFile);
            }
            if (!(jobFile = UserDataManager.getJobFile(uuid)).exists()) {
                jobFile.createNewFile();
                YamlConfiguration jobConfig = YamlConfiguration.loadConfiguration((File)jobFile);
                jobConfig.set("hasJob", (Object)false);
                jobConfig.set("currentJob", (Object)"Arbeitslos");
                jobConfig.set("onMission", (Object)false);
                jobConfig.set("job.F\u00f6rster.Level", (Object)0);
                jobConfig.set("job.F\u00f6rster.EXP", (Object)0);
                jobConfig.set("job.F\u00f6rster.Belohnung", (Object)false);
                jobConfig.set("job.Feuerwehr.Level", (Object)0);
                jobConfig.set("job.Feuerwehr.EXP", (Object)0);
                jobConfig.set("job.Feuerwehr.Belohnung", (Object)false);
                jobConfig.set("job.Angler.Level", (Object)0);
                jobConfig.set("job.Angler.EXP", (Object)0);
                jobConfig.set("job.Angler.Belohnung", (Object)false);
                jobConfig.set("job.Putzdienst.Level", (Object)0);
                jobConfig.set("job.Putzdienst.EXP", (Object)0);
                jobConfig.set("job.Putzdienst.Belohnung", (Object)false);
                jobConfig.set("job.K\u00e4mpfer.Level", (Object)0);
                jobConfig.set("job.K\u00e4mpfer.EXP", (Object)0);
                jobConfig.set("job.K\u00e4mpfer.Belohnung", (Object)false);
                jobConfig.set("job.Minenarbeiter.Level", (Object)0);
                jobConfig.set("job.Minenarbeiter.EXP", (Object)0);
                jobConfig.set("job.Minenarbeiter.Belohnung", (Object)false);
                jobConfig.set("job.Landwirt.Level", (Object)0);
                jobConfig.set("job.Landwirt.EXP", (Object)0);
                jobConfig.set("job.Landwirt.Belohnung", (Object)false);
                jobConfig.set("job.Florist.Level", (Object)0);
                jobConfig.set("job.Florist.EXP", (Object)0);
                jobConfig.set("job.Florist.Belohnung", (Object)false);
                jobConfig.set("job.Rettungsdienst.Level", (Object)0);
                jobConfig.set("job.Rettungsdienst.EXP", (Object)0);
                jobConfig.set("job.Rettungsdienst.Belohnung", (Object)false);
                jobConfig.set("job.Gastronom.Level", (Object)0);
                jobConfig.set("job.Gastronom.EXP", (Object)0);
                jobConfig.set("job.Gastronom.Belohnung", (Object)false);
                jobConfig.save(jobFile);
            }
            if (!(studiumFile = UserDataManager.getStudiumFile(uuid)).exists()) {
                studiumFile.createNewFile();
                YamlConfiguration studiumConfig = YamlConfiguration.loadConfiguration((File)studiumFile);
                studiumConfig.set("vorlesungAktiv", (Object)false);
                studiumConfig.set("letzteVorlesung", (Object)"-");
                studiumConfig.set("studiengang.geologie.aktiv", (Object)false);
                studiumConfig.set("studiengang.geologie.abgeschlossen", (Object)false);
                studiumConfig.set("studiengang.geologie.timestamp", (Object)"0");
                studiumConfig.set("studiengang.luftundraumfahrt.aktiv", (Object)false);
                studiumConfig.set("studiengang.luftundraumfahrt.abgeschlossen", (Object)false);
                studiumConfig.set("studiengang.luftundraumfahrt.timestamp", (Object)"0");
                studiumConfig.set("studiengang.landwirtschaft.aktiv", (Object)false);
                studiumConfig.set("studiengang.landwirtschaft.abgeschlossen", (Object)false);
                studiumConfig.set("studiengang.landwirtschaft.timestamp", (Object)"0");
                studiumConfig.set("studiengang.luftundraumfahrt.raketenaufbau.abgeschlossen", (Object)false);
                studiumConfig.set("studiengang.luftundraumfahrt.luftfahrt.abgeschlossen", (Object)false);
                studiumConfig.set("studiengang.luftundraumfahrt.sonnensystem.abgeschlossen", (Object)false);
                studiumConfig.set("studiengang.luftundraumfahrt.raketenaufbau.timestamp", (Object)"0");
                studiumConfig.set("studiengang.luftundraumfahrt.luftfahrt.timestamp", (Object)"0");
                studiumConfig.set("studiengang.luftundraumfahrt.sonnensystem.timestamp", (Object)"0");
                studiumConfig.set("studiengang.landwirtschaft.dreifelderwirtschaft.abgeschlossen", (Object)false);
                studiumConfig.set("studiengang.landwirtschaft.pflanzunderntezeiten.abgeschlossen", (Object)false);
                studiumConfig.set("studiengang.landwirtschaft.viehzucht.abgeschlossen", (Object)false);
                studiumConfig.set("studiengang.landwirtschaft.dreifelderwirtschaft.timestamp", (Object)"0");
                studiumConfig.set("studiengang.landwirtschaft.pflanzunderntezeiten.timestamp", (Object)"0");
                studiumConfig.set("studiengang.landwirtschaft.viehzucht.timestamp", (Object)"0");
                studiumConfig.set("studiengang.geologie.edelsteine.abgeschlossen", (Object)false);
                studiumConfig.set("studiengang.geologie.kristalle.abgeschlossen", (Object)false);
                studiumConfig.set("studiengang.geologie.goldsuche.abgeschlossen", (Object)false);
                studiumConfig.set("studiengang.geologie.edelsteine.timestamp", (Object)"0");
                studiumConfig.set("studiengang.geologie.kristalle.timestamp", (Object)"0");
                studiumConfig.set("studiengang.geologie.goldsuche.timestamp", (Object)"0");
                studiumConfig.save(studiumFile);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static double getBalance(UUID uuid) {
        return UserDataManager.getPlayerConfig(uuid).getDouble("Kontostand");
    }

    public static void setBalance(UUID uuid, double amount) {
        FileConfiguration config = UserDataManager.getPlayerConfig(uuid);
        config.set("Kontostand", (Object)amount);
        UserDataManager.savePlayerConfig(uuid, config);
    }

    public static String getRegion(UUID uuid) {
        return UserDataManager.getPlayerConfig(uuid).getString("region");
    }

    public static void setRegion(UUID uuid, String region) {
        FileConfiguration config = UserDataManager.getPlayerConfig(uuid);
        config.set("region", (Object)region);
        UserDataManager.savePlayerConfig(uuid, config);
    }

    public static void addBalance(UUID uuid, double amount) {
        double current = UserDataManager.getBalance(uuid);
        UserDataManager.setBalance(uuid, current + amount);
    }

    public static void removeBalance(UUID uuid, double amount) {
        double current = UserDataManager.getBalance(uuid);
        UserDataManager.setBalance(uuid, Math.max(0.0, current - amount));
    }

    public static Map<UUID, Double> getAllBalances() {
        HashMap<UUID, Double> result = new HashMap<UUID, Double>();
        File[] playerDirs = UserDataManager.getDataFolder().listFiles(File::isDirectory);
        if (playerDirs == null) {
            return result;
        }
        for (File folder : playerDirs) {
            File file = new File(folder, "playerdata.yml");
            if (!file.exists()) continue;
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
            try {
                UUID uuid = UUID.fromString(folder.getName());
                result.put(uuid, config.getDouble("Kontostand"));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return result;
    }

    public static List<String> getLastTransactions(UUID uuid, int limit) {
        FileConfiguration config = UserDataManager.getTransactionConfig(uuid);
        ArrayList rawList = config.getMapList("transactions");
        if (rawList == null) {
            rawList = new ArrayList();
        }
        Collections.reverse(rawList);
        int end = Math.min(limit, rawList.size());
        List latest = rawList.subList(0, end);
        ArrayList<String> formatted = new ArrayList<String>();
        for (Map entry : latest) {
            String timestamp = String.valueOf(entry.getOrDefault("timestamp", "??"));
            String type = String.valueOf(entry.getOrDefault("type", "??"));
            double amount = Double.parseDouble(String.valueOf(entry.getOrDefault("amount", "0.0")));
            String partner = String.valueOf(entry.getOrDefault("partner", "Unbekannt"));
            String reason = String.valueOf(entry.getOrDefault("reason", "Keine Angabe"));
            String color = type.equalsIgnoreCase("receive") ? "\u00a7a" : "\u00a7c";
            String sign = type.equalsIgnoreCase("receive") ? "+" : "-";
            String verb = type.equalsIgnoreCase("receive") ? "von" : "an";
            String formattedLine = String.format("\u00a78[%s] %s%s%.2f \u00a77%s \u00a7b%s \u00a78(\u00a77Grund: %s\u00a78)", timestamp, color, sign, amount, verb, partner, reason);
            formatted.add(formattedLine);
        }
        return formatted;
    }

    public static void logTransaction(UUID receiver, UUID sender, double amount, String reason) {
        UserDataManager.logTransaction(receiver, sender, amount, reason, null);
    }

    public static void logTransaction(UUID receiver, UUID sender, double amount, String reason, String customPartnerName) {
        String timestamp = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
        OfflinePlayer senderPlayer = sender != null ? Bukkit.getOfflinePlayer((UUID)sender) : null;
        OfflinePlayer receiverPlayer = Bukkit.getOfflinePlayer((UUID)receiver);
        FileConfiguration receiverConfig = UserDataManager.getTransactionConfig(receiver);
        List receiverLogs = receiverConfig.getList("transactions", new ArrayList());
        LinkedHashMap<String, Object> recEntry = new LinkedHashMap<String, Object>();
        recEntry.put("timestamp", timestamp);
        recEntry.put("type", "receive");
        recEntry.put("amount", amount);
        recEntry.put("partner", customPartnerName != null ? customPartnerName : (senderPlayer != null ? senderPlayer.getName() : "System"));
        recEntry.put("reason", reason);
        receiverLogs.add(recEntry);
        receiverConfig.set("transactions", (Object)receiverLogs);
        UserDataManager.saveTransactionConfig(receiver, receiverConfig);
        if (sender != null) {
            FileConfiguration senderConfig = UserDataManager.getTransactionConfig(sender);
            List senderLogs = senderConfig.getList("transactions", new ArrayList());
            LinkedHashMap<String, Object> sendEntry = new LinkedHashMap<String, Object>();
            sendEntry.put("timestamp", timestamp);
            sendEntry.put("type", "send");
            sendEntry.put("amount", amount);
            sendEntry.put("partner", customPartnerName != null ? customPartnerName : receiverPlayer.getName());
            sendEntry.put("reason", reason);
            senderLogs.add(sendEntry);
            senderConfig.set("transactions", (Object)senderLogs);
            UserDataManager.saveTransactionConfig(sender, senderConfig);
        }
    }

    public static void logTransactionAsReceipt(UUID receiver, UUID sender, double amount, String reason) {
        String timestamp = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
        OfflinePlayer senderPlayer = sender != null ? Bukkit.getOfflinePlayer((UUID)sender) : null;
        FileConfiguration receiverConfig = UserDataManager.getTransactionConfig(receiver);
        List receiverLogs = receiverConfig.getList("transactions", new ArrayList());
        LinkedHashMap<String, Object> recEntry = new LinkedHashMap<String, Object>();
        recEntry.put("timestamp", timestamp);
        recEntry.put("type", "receive");
        recEntry.put("amount", amount);
        recEntry.put("partner", senderPlayer != null ? senderPlayer.getName() : "System");
        recEntry.put("reason", reason);
        receiverLogs.add(recEntry);
        receiverConfig.set("transactions", (Object)receiverLogs);
        UserDataManager.saveTransactionConfig(receiver, receiverConfig);
    }

    public static void logTransactionAsReceipt(UUID receiver, String sender, double amount, String reason) {
        String timestamp = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
        FileConfiguration receiverConfig = UserDataManager.getTransactionConfig(receiver);
        List receiverLogs = receiverConfig.getList("transactions", new ArrayList());
        LinkedHashMap<String, Object> recEntry = new LinkedHashMap<String, Object>();
        recEntry.put("timestamp", timestamp);
        recEntry.put("type", "receive");
        recEntry.put("amount", amount);
        recEntry.put("partner", sender);
        recEntry.put("reason", reason);
        receiverLogs.add(recEntry);
        receiverConfig.set("transactions", (Object)receiverLogs);
        UserDataManager.saveTransactionConfig(receiver, receiverConfig);
    }

    public static void logTransactionAsSend(UUID sender, double amount, String reason, String customPartnerName) {
        String timestamp = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
        FileConfiguration senderConfig = UserDataManager.getTransactionConfig(sender);
        List senderLogs = senderConfig.getList("transactions", new ArrayList());
        LinkedHashMap<String, Object> sendEntry = new LinkedHashMap<String, Object>();
        sendEntry.put("timestamp", timestamp);
        sendEntry.put("type", "send");
        sendEntry.put("amount", amount);
        sendEntry.put("partner", customPartnerName != null ? customPartnerName : "System");
        sendEntry.put("reason", reason);
        senderLogs.add(sendEntry);
        senderConfig.set("transactions", (Object)senderLogs);
        UserDataManager.saveTransactionConfig(sender, senderConfig);
    }

    public static void updateLogoutData(Player player) {
        UUID uuid = player.getUniqueId();
        FileConfiguration config = UserDataManager.getPlayerConfig(uuid);
        Location loc = player.getLocation();
        config.set("lastLogoutLocation", (Object)(loc.getWorld().getName() + "," + loc.getBlockX() + "," + loc.getBlockY() + "," + loc.getBlockZ()));
        config.set("lastLogoutTime", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        List<String> knownIPs = config.getStringList("lastKnownIPs");
        String ip = player.getAddress().getAddress().getHostAddress();
        if (!knownIPs.contains(ip)) {
            knownIPs.add(0, ip);
            if (knownIPs.size() > 10) {
                knownIPs = knownIPs.subList(0, 10);
            }
        }
        config.set("lastKnownIPs", (Object)knownIPs);
        UserDataManager.savePlayerConfig(uuid, config);
    }
}

