/*
 * Decompiled with CFR 0.152.
 */
package de.flipper1406.futureleague_wirtschaft.Commands;

import de.flipper1406.futureleague_wirtschaft.ConfigManager.ConfigFileConfig;
import de.flipper1406.futureleague_wirtschaft.ConfigManager.ConfigFileMessages;
import de.flipper1406.futureleague_wirtschaft.ConfigManager.ConfigManager;
import de.flipper1406.futureleague_wirtschaft.FLAPI;
import de.flipper1406.futureleague_wirtschaft.Regions.Region;
import de.flipper1406.futureleague_wirtschaft.Regions.RegionManager;
import de.flipper1406.futureleague_wirtschaft.Userdata.Utils.UserDataManager;
import de.flipper1406.futureleague_wirtschaft.Utils.WorldUtils;
import de.flipper1406.futureleague_wirtschaft.db.PlacedBlockDatabase;
import de.flipper1406.futureleague_wirtschaft.futureLeagueWirtschaft;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class EssentialCommands
implements Listener,
CommandExecutor {
    private final long twoSecondsDelay = 40L;
    private final futureLeagueWirtschaft plugin;
    private final ConfigManager configManager;
    private final ConfigFileMessages configFileMessages;
    private final ConfigFileConfig configFileConfig;
    private final FLAPI flapi;
    private static final String CURRENCY = " Euro";
    private final int offhandSlotSeperator = 51;
    private final int offhandSlot = 52;
    private final int fullInvseeInventorySize = 54;
    private final int mainInventorySize = 36;
    private final int armorSlotSeperator = 45;
    private final int hotbarSize = 9;
    private final int helmetSlot = 46;
    private final int chestplateSlot = 47;
    private final int leggingsSlot = 48;
    private final int bootsSlot = 49;
    private final int maximumHealthValue = 20;
    private final double grundkostenZurMine = 100.0;

    public EssentialCommands(futureLeagueWirtschaft wirtschaftsPlugin) {
        this.plugin = wirtschaftsPlugin;
        this.configManager = wirtschaftsPlugin.getConfigManager();
        this.configFileMessages = wirtschaftsPlugin.getConfigFileMessages();
        this.configFileConfig = wirtschaftsPlugin.getConfigFileConfig();
        this.flapi = wirtschaftsPlugin.getflapi();
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        String commandName;
        if (!(sender instanceof Player)) {
            sender.sendMessage("Dieser Befehl kann nur von einem Spieler ausgef\u00fchrt werden.");
            return true;
        }
        Player p = (Player)sender;
        return switch (commandName = cmd.getName().toLowerCase()) {
            case "gamemode" -> this.handleGamemode(p, args);
            case "heal" -> this.handleHeal(p, args);
            case "mine" -> this.handleMine(p, args);
            case "playerinfo" -> this.handlePlayerInfo(p, args);
            case "ec" -> this.handleEnderchest(p, args);
            case "enderchest" -> this.handleEnderchest(p, args);
            case "god" -> this.handleGod(p, args);
            case "invsee" -> this.handleInvsee(p, args);
            case "fullinvsee" -> this.handleFullInvsee(p, args);
            case "tphere" -> this.handleTpHere(p, args);
            case "moderation" -> this.handleModeration(p, args);
            default -> {
                this.flapi.sendMessage(p, "unknownCommand");
                yield true;
            }
        };
    }

    private boolean handleModeration(Player p, String[] args) {
        if (!p.hasPermission("fl.moderator")) {
            return false;
        }
        this.configManager.setValue(p.getName(), "moderatorModus", !this.configManager.getValue(p.getName(), "moderatorModus", true));
        if (this.configManager.getValue(p.getName(), "moderatorModus", true)) {
            p.sendMessage("\u00a72Du hast deinen Moderations-Modus aktiviert.");
        } else {
            p.sendMessage("\u00a72Du hast deinen Moderations-Modus deaktiviert.");
        }
        return true;
    }

    private boolean handleTpHere(Player p, String[] args) {
        if (!p.hasPermission("fl.tphere")) {
            p.sendMessage("\u00a7cKeine Berechtigung.");
            return false;
        }
        if (args.length != 1) {
            p.sendMessage("\u00a7cBenutze bitte /tphere <Name>");
            return false;
        }
        if (Bukkit.getPlayer((String)args[0]) == null) {
            p.sendMessage("$cSpieler nicht gefunden.");
            return false;
        }
        Player otherPlayer = Bukkit.getPlayer((String)args[0]);
        otherPlayer.teleport(p.getLocation());
        otherPlayer.sendMessage("\u00a7a" + p.getName() + " \u00a72hat dich zu sich teleportiert!");
        p.sendMessage("\u00a72Du hast \u00a7a" + args[0] + "\u00a72 zu dir teleportiert!");
        return true;
    }

    private boolean handleGod(Player p, String[] args) {
        if (!p.hasPermission("fl.god") && args.length == 0) {
            p.sendMessage("\u00a7cDu hast keine Berechtigung, den God-Modus zu aktivieren.");
            return false;
        }
        if (!p.hasPermission("fl.god.other") && args.length == 1) {
            p.sendMessage("\u00a7cDu hast keine Berechtigung, den God-Modus anderer zu aktivieren.");
            return false;
        }
        String status = "aktiviert";
        if (args.length == 0) {
            if (p.isInvulnerable()) {
                status = "deaktiviert";
            }
            p.sendMessage("\u00a72Du hast deinen God-Modus erfolgreich \u00a7a" + status + "\u00a72!");
            p.setInvulnerable(!p.isInvulnerable());
        } else if (args.length == 1) {
            Player target = Bukkit.getPlayerExact((String)args[0]);
            if (target == null) {
                p.sendMessage("\u00a7cDer Spieler ist nicht online.");
                return false;
            }
            if (target.isInvulnerable()) {
                status = "deaktiviert";
            }
            target.setInvulnerable(!target.isInvulnerable());
            p.sendMessage("\u00a72God-Modus f\u00fcr \u00a7a" + args[0] + " " + status + "\u00a72!");
            target.sendMessage("\u00a72Dein God-Modus wurde von \u00a7a" + p.getName() + " " + status + "\u00a72!");
        }
        return true;
    }

    private boolean handleInvsee(Player p, String[] args) {
        if (!p.hasPermission("fl.invsee")) {
            p.sendMessage("\u00a7cDu hast keine Berechtigung, deine Enderchest zu \u00f6ffnen.");
            return false;
        }
        if (args.length != 1) {
            p.sendMessage("\u00a7cBenutze /invsee <Spieler>");
            return false;
        }
        Player target = Bukkit.getPlayerExact((String)args[0]);
        if (target == null) {
            p.sendMessage("\u00a7cDer Spieler ist nicht online!");
            return false;
        }
        p.openInventory((Inventory)target.getInventory());
        return true;
    }

    private boolean handleFullInvsee(Player p, String[] args) {
        int i;
        if (!p.hasPermission("fl.invsee")) {
            p.sendMessage("\u00a7cDu hast keine Berechtigung, Invsee zu verwenden.");
            return false;
        }
        if (args.length != 1) {
            p.sendMessage("\u00a7cBenutze /invsee <Spieler>");
            return false;
        }
        Player target = Bukkit.getPlayerExact((String)args[0]);
        if (target == null) {
            p.sendMessage("\u00a7cDer Spieler ist nicht online!");
            return false;
        }
        p.sendMessage("\u00a74\u00a7lAchtung:\u00a7r\u00a74 Dies dient nur zum Nachsehen!");
        Inventory invsee = Bukkit.createInventory((InventoryHolder)p, (int)54, (String)("Full-Invsee: " + target.getName()));
        PlayerInventory targetInv = target.getInventory();
        for (i = 9; i < 36; ++i) {
            invsee.setItem(i, targetInv.getItem(i));
        }
        for (i = 0; i < 9; ++i) {
            invsee.setItem(i, targetInv.getItem(i));
        }
        ItemStack armorLabel = new ItemStack(Material.YELLOW_STAINED_GLASS_PANE);
        ItemMeta armorMeta = armorLabel.getItemMeta();
        armorMeta.setDisplayName("\u00a7eR\u00fcstung ==>");
        armorLabel.setItemMeta(armorMeta);
        invsee.setItem(45, armorLabel);
        invsee.setItem(46, targetInv.getHelmet());
        invsee.setItem(47, targetInv.getChestplate());
        invsee.setItem(48, targetInv.getLeggings());
        invsee.setItem(49, targetInv.getBoots());
        ItemStack offhandLabel = new ItemStack(Material.YELLOW_STAINED_GLASS_PANE);
        ItemMeta offhandMeta = offhandLabel.getItemMeta();
        offhandMeta.setDisplayName("\u00a7eOff-Hand ==>");
        offhandLabel.setItemMeta(offhandMeta);
        invsee.setItem(51, offhandLabel);
        invsee.setItem(52, targetInv.getItemInOffHand());
        p.openInventory(invsee);
        return true;
    }

    private boolean handleEnderchest(Player p, String[] args) {
        if (args.length == 0 && !p.hasPermission("fl.enderchest.self")) {
            p.sendMessage("\u00a7cDu hast keine Berechtigung, deine Enderchest zu \u00f6ffnen.");
            return true;
        }
        if (args.length == 1 && !p.hasPermission("fl.enderchest.other")) {
            p.sendMessage("\u00a7cDu hast keine Berechtigung, fremde Enderchests zu \u00f6ffnen.");
            return true;
        }
        if (args.length == 0) {
            p.openInventory(p.getEnderChest());
            return true;
        }
        if (args.length == 1) {
            Player target = Bukkit.getPlayerExact((String)args[0]);
            if (target == null) {
                p.sendMessage("\u00a7cDer Spieler \u00a7e" + args[0] + " \u00a7cist nicht online.");
                return true;
            }
            p.openInventory(target.getEnderChest());
            p.sendMessage("\u00a7aDu hast die Enderchest von \u00a7e" + target.getName() + " \u00a7age\u00f6ffnet.");
            return true;
        }
        return false;
    }

    private boolean handleGamemode(Player p, String[] args) {
        GameMode mode;
        if (args.length == 0) {
            this.flapi.sendMessage(p, "gamemode");
        }
        if (args.length == 1) {
            if (!p.hasPermission("fl.gamemode.self")) {
                this.flapi.sendMessage(p, "gamemodeNoPermission");
                return true;
            }
            mode = this.parseGameMode(args[0]);
            if (mode == null) {
                this.flapi.sendMessage(p, "gamemodeOutOfNumber");
            }
            if (mode == GameMode.CREATIVE && !p.hasPermission("fl.gamemode.creative")) {
                this.flapi.sendMessage(p, "gamemodeNoPermissionForCreative");
            }
            p.setGameMode(mode);
            String modeName = this.getGamemodeName(mode);
            this.flapi.sendMessage(p, modeName, "gamemodeChanged");
            this.configManager.setValue(p.getName(), "gamemode", modeName);
        }
        if (args.length == 2) {
            if (!p.hasPermission("fl.gamemode.other")) {
                this.flapi.sendMessage(p, "gamemodeNoPermissionForOther");
                return true;
            }
            mode = this.parseGameMode(args[0]);
            if (mode == null) {
                this.flapi.sendMessage(p, "gamemodeOutOfNumber");
                return true;
            }
            Player target = Bukkit.getPlayer((String)args[1]);
            if (target == null || !target.isOnline()) {
                this.flapi.sendMessage(p, args[1], "playerNotOnline");
                return true;
            }
            target.setGameMode(mode);
            String modeName = this.getGamemodeName(mode);
            this.flapi.sendMessage(target, p, modeName, "gamemodeChangedBy");
            this.flapi.sendMessage(p, target, modeName, "gamemodeChangedFrom");
            this.configManager.setValue(target.getName(), "gamemode", modeName);
        }
        return true;
    }

    private GameMode parseGameMode(String mode) {
        return switch (mode) {
            case "0" -> GameMode.SURVIVAL;
            case "1" -> GameMode.CREATIVE;
            case "2" -> GameMode.ADVENTURE;
            case "3" -> GameMode.SPECTATOR;
            default -> null;
        };
    }

    private String getGamemodeName(GameMode mode) {
        return switch (mode) {
            default -> throw new IncompatibleClassChangeError();
            case GameMode.SURVIVAL -> "\u00dcberlebensmodus";
            case GameMode.CREATIVE -> "Kreativ";
            case GameMode.ADVENTURE -> "Abenteuermodus";
            case GameMode.SPECTATOR -> "Zuschauermodus";
        };
    }

    private boolean handleHeal(Player p, String[] args) {
        if (args.length == 0) {
            if (!p.hasPermission("fl.heal.self")) {
                this.flapi.sendMessage(p, "healNoPermissionSelf");
                return true;
            }
            p.setHealth(20.0);
            this.flapi.sendMessage(p, "healSuccess");
            return true;
        }
        if (args.length == 1) {
            this.flapi.sendMessage(p, "healOtherNotImplemented");
            return true;
        }
        this.flapi.sendMessage(p, "healUsage");
        return true;
    }

    private boolean handleMine(Player p, String[] args) {
        double kostenZurMine = 100.0;
        if (args.length == 0) {
            Region reg = RegionManager.getInstance().getRegion("zugangmine");
            if (!reg.contains(p.getLocation()) && !p.hasPermission("fl.mine.admin")) {
                p.sendMessage("\u00a7cDu kannst hier nicht zur Mine. Besuche Gate 10 am Flughafen, um zur Mine zu kommen!");
                return false;
            }
            if (this.configManager.getValue(p.getName(), "studiumAbgeschlossen_luftundraumfahrt", true)) {
                kostenZurMine /= 2.0;
            }
            if (!(UserDataManager.getBalance(p.getUniqueId()) >= kostenZurMine)) {
                p.sendMessage("\u00a7cDu hast nicht gen\u00fcgend Geld f\u00fcr ein Ticket zur Mine.Ein Ticket kostet dich \u00a7l" + kostenZurMine + CURRENCY);
            }
            UserDataManager.logTransactionAsSend(p.getUniqueId(), kostenZurMine, "Ticket zur Mine", "FL Airport & Travel AG");
            UserDataManager.removeBalance(p.getUniqueId(), kostenZurMine);
            p.teleport(this.configFileConfig.getLocation("minespawn"));
            if (!this.configManager.getValue(p.getName(), "hasJob", true)) {
                this.flapi.sendPrefixMessage(p, "FutureLeague");
                p.sendMessage(this.configFileMessages.getValue("mineJoined"));
                p.sendMessage(this.configFileMessages.getValue("emptyRow"));
                p.sendMessage(this.configFileMessages.getValue("mineWithoutJobActive"));
                this.flapi.sendSuffixMessage(p);
            } else {
                this.flapi.sendMessage(p, "mineJoined");
            }
            return true;
        }
        if (args.length == 1 && args[0].equalsIgnoreCase("setspawn")) {
            if (!p.hasPermission("fl.mine.admin")) {
                this.flapi.sendMessage(p, "mineSetSpawnNoPermission");
                return true;
            }
            Location newLoc = p.getLocation();
            this.configFileConfig.setLocation("minespawn", newLoc);
            this.configFileConfig.save();
            this.flapi.sendMessage(p, "mineSetSpawnSuccess");
            return true;
        }
        if (args.length == 1 && args[0].equalsIgnoreCase("reset")) {
            if (!p.hasPermission("fl.mine.admin")) {
                this.flapi.sendMessage(p, "mineSetSpawnNoPermission");
                return true;
            }
            int counter = this.configFileConfig.getIntValue("counter");
            World mine = Bukkit.getWorld((String)("mine-" + counter));
            PlacedBlockDatabase.clearAllBlocks();
            if (mine != null) {
                for (Player player : mine.getPlayers()) {
                    player.teleport(this.flapi.getCitySpawnLocation());
                    player.sendMessage("\u00a72Die Mine wird grade neu erstellt!");
                }
                WorldUtils.getInstance().deleteWorld("mine-" + counter);
                EssentialCommands essentialCommands = this;
                new BukkitRunnable(){

                    public void run() {
                        int counter = EssentialCommands.this.configFileConfig.getIntValue("counter") + 1;
                        WorldUtils.getInstance().createWorld("mine-" + counter, "NORMAL");
                        EssentialCommands.this.configFileConfig.setInt("counter", counter);
                        Location spawn = EssentialCommands.this.flapi.getWorldSpawn("mine-" + counter);
                        Location safeSpawn = EssentialCommands.this.flapi.getHighestSaveLocation(spawn);
                        EssentialCommands.this.configFileConfig.setLocation("minespawn", safeSpawn);
                        EssentialCommands.this.configFileConfig.save();
                        System.out.println("Neue Welt erstellt und Spawn gespeichert.");
                    }
                }.runTaskLater((Plugin)essentialCommands.plugin.getInstance(), 40L);
            }
            p.sendMessage("Die Mine wurde resettet.");
            return true;
        }
        this.flapi.sendMessage(p, "mineUsage");
        return true;
    }

    private boolean handlePlayerInfo(Player p, String[] args) {
        if (!p.hasPermission("fl.playerinfo")) {
            String firstJoin = this.configManager.getValue(p.getName(), "firstJoin");
            String currentJob = this.configManager.getValue(p.getName(), "currentJob");
            String isOnMission = this.configManager.getValue(p.getName(), "onMission", true) ? "JA" : "NEIN";
            this.flapi.sendPrefixMessage(p, this.configFileMessages.getValue("title"));
            p.sendMessage(" " + this.configFileMessages.getValue("playerinfosFrom") + p.getName());
            p.sendMessage(" " + this.configFileMessages.getValue("currentJob") + currentJob);
            p.sendMessage(" " + this.configFileMessages.getValue("onMission") + isOnMission);
            p.sendMessage(" " + this.configFileMessages.getValue("firstJoinDate") + ": \u00a7a" + firstJoin);
            this.flapi.sendSuffixMessage(p);
            return true;
        }
        if (args.length != 1) {
            this.flapi.sendMessage(p, "playerinfo");
            return true;
        }
        String targetName = args[0];
        if (!this.configManager.checkForPlayerInConfig(targetName)) {
            this.flapi.sendMessage(p, targetName, "playerNotFound");
            return true;
        }
        Player player = Bukkit.getPlayer((String)targetName);
        double money = UserDataManager.getBalance(Bukkit.getOfflinePlayer((String)args[0]).getUniqueId());
        String currentJob = this.configManager.getValue(targetName, "currentJob");
        String isOnMission = this.configManager.getValue(targetName, "onMission", true) ? "JA" : "NEIN";
        String gamemode = this.configManager.getValue(targetName, "gamemode");
        String firstJoin = this.configManager.getValue(targetName, "firstJoin");
        String lastOnline = this.configManager.getValue(targetName, "lastOnline");
        if (player != null && player.isOnline()) {
            lastOnline = "Online";
        }
        Location defaultLoc = new Location(Bukkit.getWorld((String)"dummy"), 0.0, 0.0, 0.0);
        Location lastLocation = this.configManager.getValue(targetName, "lastLocation", defaultLoc);
        String lastX = String.valueOf(lastLocation.getX());
        String lastY = String.valueOf(lastLocation.getY());
        String lastZ = String.valueOf(lastLocation.getZ());
        String lastWorld = lastLocation.getWorld().getName();
        this.flapi.sendPrefixMessage(p, this.configFileMessages.getValue("title"));
        p.sendMessage(" " + this.configFileMessages.getValue("playerinfosFrom") + targetName);
        p.sendMessage(" " + this.configFileMessages.getValue("currentJob") + currentJob);
        p.sendMessage(" " + this.configFileMessages.getValue("onMission") + isOnMission);
        p.sendMessage(" " + this.configFileMessages.getValue("word_Gamemode") + ": \u00a7a" + gamemode);
        p.sendMessage(" " + this.configFileMessages.getValue("firstJoinDate") + ": \u00a7a" + firstJoin);
        p.sendMessage(" " + this.configFileMessages.getValue("lastOnlineDate") + ": \u00a7a" + lastOnline);
        p.sendMessage(" " + this.configFileMessages.getValue("disconnectedOnWorld") + ": \u00a7a" + lastWorld);
        p.sendMessage(" \u00a72-X: \u00a7a" + lastX);
        p.sendMessage(" \u00a72-Y: \u00a7a" + lastY);
        p.sendMessage(" \u00a72-Z: \u00a7a" + lastZ);
        p.sendMessage(" \u00a72Kontostand: \u00a7a" + money);
        p.sendMessage(" \u00a72UUID: \u00a7a" + p.getUniqueId().toString());
        this.flapi.sendSuffixMessage(p);
        return true;
    }
}

