/*
 * Decompiled with CFR 0.152.
 */
package de.flipper1406.futureleague_wirtschaft.Tools;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.java.JavaPlugin;

public class LibraryBookManager {
    private final JavaPlugin plugin;
    private final File file;
    private static final int MAX_PAGE_LENGTH = 256;
    private static final int MAX_PAGES = 100;
    private YamlConfiguration config;
    private final Random random = new Random();

    public LibraryBookManager(JavaPlugin wirtschaftsPlugin) {
        this.plugin = wirtschaftsPlugin;
        this.file = new File(wirtschaftsPlugin.getDataFolder(), "books.yml");
        this.createFileIfMissing();
        this.loadConfig();
    }

    private void createFileIfMissing() {
        if (this.file.exists()) {
            return;
        }
        this.plugin.getDataFolder().mkdirs();
        this.plugin.saveResource("books.yml", false);
    }

    private void loadConfig() {
        this.config = YamlConfiguration.loadConfiguration((File)this.file);
    }

    public ItemStack getRandomBook() {
        if (!this.config.contains("books")) {
            return null;
        }
        Set keys = this.config.getConfigurationSection("books").getKeys(false);
        if (keys.isEmpty()) {
            return null;
        }
        ArrayList ids = new ArrayList(keys);
        String id = (String)ids.get(this.random.nextInt(ids.size()));
        String path = "books." + id;
        String title = this.config.getString(path + ".title", "Unbekannt");
        String author = this.config.getString(path + ".author", "FutureLeague");
        List rawPages = this.config.getStringList(path + ".pages");
        if (rawPages.isEmpty()) {
            return null;
        }
        List<String> pages = this.splitIntoBookPages(rawPages);
        if (pages.size() > 100) {
            pages = pages.subList(0, 100);
        }
        ItemStack book = new ItemStack(Material.WRITTEN_BOOK);
        BookMeta meta = (BookMeta)book.getItemMeta();
        meta.setTitle(title);
        meta.setAuthor(author);
        meta.setPages(pages);
        book.setItemMeta((ItemMeta)meta);
        return book;
    }

    public void reload() {
        this.loadConfig();
    }

    private List<String> splitIntoBookPages(List<String> rawPages) {
        ArrayList<String> result = new ArrayList<String>();
        for (String page : rawPages) {
            if (page.length() <= 256) {
                result.add(page);
                continue;
            }
            String remaining = page;
            while (remaining.length() > 256) {
                int splitAt = remaining.lastIndexOf(32, 256);
                if (splitAt <= 0) {
                    splitAt = 256;
                }
                result.add(remaining.substring(0, splitAt).trim());
                remaining = remaining.substring(splitAt).trim();
            }
            if (remaining.isEmpty()) continue;
            result.add(remaining);
        }
        return result;
    }
}

