/*
 * Decompiled with CFR 0.152.
 */
package de.flipper1406.futureleague_wirtschaft.ChestShop;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.Chest;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class ChestShop {
    private final UUID owner;
    private final Location chestLocation;
    private final ItemStack item;
    private final double pricePerItem;
    private final Set<UUID> staff;

    public ChestShop(UUID shopOwner, Location shopChestLocation, ItemStack shopItem, double pricePerShopItem) {
        this.owner = shopOwner;
        this.chestLocation = shopChestLocation;
        this.item = shopItem.clone();
        this.pricePerItem = pricePerShopItem;
        this.staff = new HashSet<UUID>();
    }

    public final UUID getOwner() {
        return this.owner;
    }

    public final Location getChestLocation() {
        return this.chestLocation;
    }

    public final ItemStack getItem() {
        return this.item;
    }

    public final double getPricePerItem() {
        return this.pricePerItem;
    }

    public final Set<UUID> getStaff() {
        return this.staff;
    }

    public final void addStaff(UUID uuid) {
        this.staff.add(uuid);
    }

    public final void removeStaff(UUID uuid) {
        this.staff.remove(uuid);
    }

    public final boolean isAuthorized(UUID uuid) {
        return uuid.equals(this.owner) || this.staff.contains(uuid) || Bukkit.getPlayer((UUID)uuid).hasPermission("fl.shops.admin");
    }

    public final boolean canSell(int amount) {
        Block block = this.chestLocation.getBlock();
        if (!(block.getState() instanceof Chest)) {
            return false;
        }
        Chest chest = (Chest)block.getState();
        Inventory inv = chest.getInventory();
        int count = 0;
        for (ItemStack i : inv.getContents()) {
            if (i == null || !i.isSimilar(this.item) || (count += i.getAmount()) < amount) continue;
            return true;
        }
        return false;
    }
}

