/*
 * Decompiled with CFR 0.152.
 */
package de.flipper1406.futureleague_wirtschaft.Tools.Ampeln;

import de.flipper1406.futureleague_wirtschaft.Tools.Ampeln.Ampel;
import de.flipper1406.futureleague_wirtschaft.Tools.Ampeln.AmpelManager;
import java.io.IOException;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AmpelCommand
implements TabExecutor {
    private final AmpelManager manager;

    public AmpelCommand(AmpelManager ampelManager) {
        this.manager = ampelManager;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (args.length == 1) {
            return List.of("create", "remove", "save", "setausrichtung");
        }
        if (args.length == 2 && (args[0].equalsIgnoreCase("create") || args[0].equalsIgnoreCase("setausrichtung"))) {
            return List.of("nord", "west");
        }
        return List.of();
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            if (!player.hasPermission("fl.ampel")) {
                player.sendMessage("\u00a74Keine Berechtigung");
                return true;
            }
            if (args.length == 1) {
                switch (args[0].toLowerCase()) {
                    case "remove": {
                        this.handleRemove(player);
                        break;
                    }
                    case "save": {
                        this.handleSave(player);
                        break;
                    }
                    default: {
                        this.sendHelp(player);
                        break;
                    }
                }
            } else if (args.length == 2) {
                switch (args[0].toLowerCase()) {
                    case "create": {
                        this.handleCreate(player, args[1]);
                        break;
                    }
                    case "setausrichtung": {
                        this.handleSetAusrichtung(player, args[1]);
                        break;
                    }
                    default: {
                        this.sendHelp(player);
                        break;
                    }
                }
            } else {
                this.sendHelp(player);
            }
        } else {
            sender.sendMessage("Dieses Kommando kann nicht auf der Konsole verwendet werden.");
        }
        return true;
    }

    private void handleRemove(Player player) {
        Location loc = player.getLocation();
        if (!this.manager.isAmpel(loc)) {
            player.sendMessage("\u00a7cDu stehst auf keiner registrierten Ampel");
            return;
        }
        this.manager.removeAmpel(loc);
        player.sendMessage("\u00a72Die Ampel wurde erfolgreich entfernt");
    }

    private void handleSave(Player player) {
        try {
            this.manager.save();
            player.sendMessage("\u00a72Configdateien erfolgreich gespeichert");
        }
        catch (IOException e) {
            player.sendMessage("\u00a74Kritischer Fehler beim Speichern der Configdatei: " + e.getMessage());
            throw new RuntimeException(e);
        }
    }

    private void handleCreate(Player player, String arg) {
        Location loc = player.getLocation();
        if (this.manager.isAmpel(loc)) {
            player.sendMessage("\u00a7cAn dieser Position ist bereits eine Ampel registriert");
            return;
        }
        Ampel.AmpelType type = this.getAmpelTypeFromString(arg);
        if (type == null) {
            this.sendHelp(player);
            return;
        }
        this.manager.addAmpel(loc, type);
        player.sendMessage("\u00a72Es wurde erfolgreich eine neue Ampel in Ausrichtung \u00a7c" + type.name() + "\u00a72 registriert");
    }

    private void handleSetAusrichtung(Player player, String arg) {
        Location loc = player.getLocation();
        if (!this.manager.isAmpel(loc)) {
            player.sendMessage("\u00a7cDu stehst auf keiner registrierten Ampel");
            return;
        }
        Ampel.AmpelType type = this.getAmpelTypeFromString(arg);
        if (type == null) {
            this.sendHelp(player);
            return;
        }
        this.manager.setAusrichtung(loc, type);
        player.sendMessage("\u00a72Die Ausrichtung der Ampel wurde auf \u00a7c" + type.name() + " \u00a72ge\u00e4ndert.");
    }

    private Ampel.AmpelType getAmpelTypeFromString(String arg) {
        return switch (arg.toLowerCase()) {
            case "nord" -> Ampel.AmpelType.NORTH_SOUTH;
            case "west" -> Ampel.AmpelType.EAST_WEST;
            default -> null;
        };
    }

    private void sendHelp(Player player) {
        player.sendMessage("\u00a72Ampel-Hilfe du Lappen");
        player.sendMessage("\u00a78/ampel create <nord|west> \u00a77- Erzeugt eine neue Ampel in nord- oder westausrichtung");
        player.sendMessage("\u00a78/ampel setausrichtung <nord|west> \u00a77- Setzt die Ausrichtung der Ampel an deiner Position");
        player.sendMessage("\u00a78/ampel remove \u00a77- Entfernt die Ampel an deiner Position");
        player.sendMessage("\u00a77Bei allen obigen Kommandos muss der Spieler auf der Ampel stehen");
        player.sendMessage("\u00a78/ampel save \u00a77- Speichert die im Cache erzeugten Ampeln in der Config");
    }
}

