/*
 * Decompiled with CFR 0.152.
 */
package de.flipper1406.futureleague_wirtschaft.Permissions;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.plugin.java.JavaPlugin;

public class DatabaseManager {
    private final JavaPlugin plugin;
    private final String host;
    private final int port;
    private final String database;
    private final String username;
    private final String password;

    public DatabaseManager(JavaPlugin plugin) {
        this.plugin = plugin;
        this.host = plugin.getConfig().getString("database.host", "localhost");
        this.port = plugin.getConfig().getInt("database.port", 3306);
        this.database = plugin.getConfig().getString("database.db", "minecraft");
        this.username = plugin.getConfig().getString("database.user", "root");
        this.password = plugin.getConfig().getString("database.password", "");
    }

    public Connection getConnection() throws SQLException {
        String url = "jdbc:mysql://" + this.host + ":" + this.port + "/" + this.database + "?useSSL=false&serverTimezone=UTC";
        return DriverManager.getConnection(url, this.username, this.password);
    }

    public void logChat(UUID playerUUID, String message, String server) {
        OfflinePlayer player = Bukkit.getOfflinePlayer((UUID)playerUUID);
        String username = player.getName() != null ? player.getName() : "UNKNOWN";
        String sql = "INSERT INTO chatLog (username, userUUID, message, server)\nVALUES (?, ?, ?, ?)\n";
        try (Connection conn = this.getConnection();
             PreparedStatement stmt = conn.prepareStatement(sql);){
            stmt.setString(1, username);
            stmt.setString(2, playerUUID.toString());
            stmt.setString(3, message);
            stmt.setString(4, server);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

