/*
 * Decompiled with CFR 0.152.
 */
package de.flipper1406.futureleague_wirtschaft.Permissions;

import de.flipper1406.futureleague_wirtschaft.Permissions.DatabaseManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;

public class PermissionManager {
    private final DatabaseManager db;

    public PermissionManager(DatabaseManager db) {
        this.db = db;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getRank(String uuid) {
        String sql = "SELECT rank FROM players WHERE uuid = ?";
        try (Connection conn = this.db.getConnection();
             PreparedStatement ps = conn.prepareStatement(sql);){
            ps.setString(1, uuid);
            ResultSet rs = ps.executeQuery();
            if (!rs.next()) return "default";
            String string = rs.getString("rank");
            return string;
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return "default";
    }

    public HashSet<String> getPermissions(String uuid, String server) {
        HashSet<String> perms = new HashSet<String>();
        String rank = this.getRank(uuid);
        try (Connection conn = this.db.getConnection();){
            HashSet<String> inheritedRanks = this.getInheritedRanks(rank, conn);
            String rankSql = "SELECT permission FROM permissions\nWHERE rank = ? AND (server = ? OR server = 'global')\n";
            try (PreparedStatement ps = conn.prepareStatement(rankSql);){
                for (String r : inheritedRanks) {
                    ps.setString(1, r);
                    ps.setString(2, server);
                    ResultSet rs = ps.executeQuery();
                    try {
                        while (rs.next()) {
                            perms.add(rs.getString("permission"));
                        }
                    }
                    finally {
                        if (rs == null) continue;
                        rs.close();
                    }
                }
            }
            String playerSql = "SELECT permission FROM player_permissions\nWHERE uuid = ? AND (server = ? OR server = 'global')\n";
            try (PreparedStatement ps = conn.prepareStatement(playerSql);){
                ps.setString(1, uuid);
                ps.setString(2, server);
                try (ResultSet rs = ps.executeQuery();){
                    while (rs.next()) {
                        perms.add(rs.getString("permission"));
                    }
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return perms;
    }

    public boolean hasPermission(String uuid, String permission, String server) {
        HashSet<String> perms = this.getPermissions(uuid, server);
        if (perms.contains("*")) {
            return true;
        }
        if (perms.contains(permission)) {
            return true;
        }
        String[] parts = permission.split("\\.");
        String current = "";
        for (String part : parts) {
            String string = current = current.isEmpty() ? part : current + "." + part;
            if (!perms.contains(current + ".*")) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getPrefixByRank(String rank) {
        String sql = "SELECT prefix FROM ranks WHERE name = ?";
        try (Connection conn = this.db.getConnection();
             PreparedStatement ps = conn.prepareStatement(sql);){
            ps.setString(1, rank);
            ResultSet rs = ps.executeQuery();
            if (!rs.next()) return "";
            String string = rs.getString("prefix");
            return string;
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return "";
    }

    public String getPrefix(String uuid) {
        return this.getPrefixByRank(this.getRank(uuid));
    }

    private HashSet<String> getInheritedRanks(String rank, Connection conn) throws SQLException {
        HashSet<String> ranks = new HashSet<String>();
        String weightSql = "SELECT weight FROM ranks WHERE name = ?";
        try (PreparedStatement ps = conn.prepareStatement(weightSql);){
            ps.setString(1, rank);
            ResultSet rs = ps.executeQuery();
            if (!rs.next()) {
                HashSet<String> hashSet = ranks;
                return hashSet;
            }
            int weight = rs.getInt("weight");
            String rankSql = "SELECT name FROM ranks WHERE weight <= ?";
            try (PreparedStatement ps2 = conn.prepareStatement(rankSql);){
                ps2.setInt(1, weight);
                ResultSet rs2 = ps2.executeQuery();
                while (rs2.next()) {
                    ranks.add(rs2.getString("name"));
                }
            }
        }
        return ranks;
    }
}

