/*
 * Decompiled with CFR 0.152.
 */
package de.flipper1406.futureleague_wirtschaft.Tools.Elevator;

import de.flipper1406.futureleague_wirtschaft.Tools.Elevator.Elevator;
import de.flipper1406.futureleague_wirtschaft.Tools.Elevator.ElevatorManager;
import de.flipper1406.futureleague_wirtschaft.futureLeagueWirtschaft;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.data.type.Switch;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class ElevatorListener
implements Listener {
    private static final String GUI_TITLE = "\u00a76Aufzug w\u00e4hlen";
    private static final int GUI_SIZE_SMALL = 9;
    private static final int GUI_SIZE_MEDIUM = 18;
    private static final int GUI_SIZE_LARGE = 27;
    private static final long TICKS_PER_SECOND = 20L;
    private static final int BLINDNESS_AMPLIFIER = 20;
    private static final int BLINDNESS_EXTRA_SECONDS = 2;
    private static final int BASE_TRAVEL_TIME_SECONDS = 3;
    private static final int BLOCKS_PER_SECOND = 10;
    private static final int SOUND_VOLUME = 5;
    private static final int SOUND_PITCH = 1;
    private final ElevatorManager manager;
    private final futureLeagueWirtschaft plugin;
    private final Map<Player, Location> openElevatorMap = new HashMap<Player, Location>();

    public ElevatorListener(ElevatorManager elevatorManager, futureLeagueWirtschaft wirtschaftsPlugin) {
        this.manager = elevatorManager;
        this.plugin = wirtschaftsPlugin;
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent e) {
        if (e.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Block block = e.getClickedBlock();
        if (block == null || !(block.getBlockData() instanceof Switch)) {
            return;
        }
        if (!this.manager.elevatorExists(block.getLocation())) {
            return;
        }
        e.setCancelled(true);
        Player player = e.getPlayer();
        List<Elevator> elevators = this.manager.getElevatorsOnXZ(block.getX(), block.getZ(), block.getWorld());
        int size = 0;
        if (elevators.size() <= 9) {
            size = 9;
        } else if (elevators.size() <= 18) {
            size = 18;
        } else if (elevators.size() <= 27) {
            size = 27;
        }
        Inventory gui = Bukkit.createInventory(null, (int)size, (String)GUI_TITLE);
        for (int i = 0; i < elevators.size(); ++i) {
            Elevator el = elevators.get(i);
            ItemStack item = new ItemStack(Material.ENDER_PEARL);
            ItemMeta meta = item.getItemMeta();
            meta.setDisplayName("\u00a7e" + el.getName() + " \u00a77(Y: " + el.getButtonLocation().getBlockY() + ")");
            item.setItemMeta(meta);
            gui.setItem(i, item);
        }
        this.openElevatorMap.put(player, block.getLocation());
        player.openInventory(gui);
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent e) {
        HumanEntity humanEntity = e.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        final Player player = (Player)humanEntity;
        if (!e.getView().getTitle().contains("Aufzug")) {
            return;
        }
        e.setCancelled(true);
        ItemStack clicked = e.getCurrentItem();
        if (clicked == null || !clicked.hasItemMeta()) {
            return;
        }
        final String name = ChatColor.stripColor((String)clicked.getItemMeta().getDisplayName().replaceAll(" \u00a77\\(Y:.*?\\)", ""));
        Location buttonLoc = this.openElevatorMap.get(player);
        if (buttonLoc == null) {
            player.sendMessage("\u00a7cFehler: Keine Aufzugsposition gefunden.");
            return;
        }
        List<Elevator> elevators = this.manager.getElevatorsOnXZ(buttonLoc.getBlockX(), buttonLoc.getBlockZ(), buttonLoc.getWorld());
        for (final Elevator el : elevators) {
            if (!el.getName().equals(name)) continue;
            double differenceLevel = el.getTeleportLocation().getY() - player.getLocation().getY();
            if (differenceLevel < 0.0) {
                differenceLevel *= -1.0;
            }
            int delay = Math.round((float)Math.round(differenceLevel) / 10.0f + 3.0f);
            player.closeInventory();
            this.openElevatorMap.remove(player);
            this.applyBlindnessEffect(player, delay);
            player.playSound(player.getLocation(), Sound.ENTITY_MINECART_INSIDE, 5.0f, 1.0f);
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

                @Override
                public void run() {
                    player.teleport(el.getTeleportLocation());
                    player.sendMessage("\u00a7aTeleportiert zu \u00a7e" + name);
                }
            }, 20L * (long)delay);
            return;
        }
    }

    public void applyBlindnessEffect(Player target, int duration) {
        int durationInSeconds = (int)(20L * (long)(duration + 2));
        target.addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, durationInSeconds, 20));
    }
}

