/*
 * Decompiled with CFR 0.152.
 */
package de.flipper1406.futureleague_wirtschaft.ChestShop;

import de.flipper1406.futureleague_wirtschaft.ChestShop.ChestShop;
import de.flipper1406.futureleague_wirtschaft.ChestShop.ChestShopLog;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemStack;

public final class ChestShopManager {
    private static final File SHOP_FILE = new File(Bukkit.getPluginManager().getPlugin("FutureLeague_Wirtschaft").getDataFolder(), "shopLocations.yml");
    private static final YamlConfiguration SHOP_CONFIG = YamlConfiguration.loadConfiguration((File)SHOP_FILE);
    private static final Map<Location, ChestShop> SHOP_MAP = new HashMap<Location, ChestShop>();
    private static final Map<UUID, Integer> PLAYER_SHOP_COUNT = new HashMap<UUID, Integer>();
    private static final File LOC_FILE = new File(Bukkit.getPluginManager().getPlugin("FutureLeague_Wirtschaft").getDataFolder(), "shopLocations.yml");
    private static final YamlConfiguration LOC_CONFIG = YamlConfiguration.loadConfiguration((File)LOC_FILE);
    private static final Map<Location, Location> SIGN_TO_CHEST = new HashMap<Location, Location>();

    private ChestShopManager() {
        throw new UnsupportedOperationException("Utility class should not be instantiated");
    }

    public static void registerSign(Location signLoc, Location chestLoc) {
        SIGN_TO_CHEST.put(signLoc, chestLoc);
        ChestShopManager.saveSignLocation(signLoc, chestLoc);
    }

    private static void saveSignLocation(Location signLoc, Location chestLoc) {
        String key = ChestShopManager.locationToString(chestLoc);
        LOC_CONFIG.set("shops." + key + ".sign.world", (Object)signLoc.getWorld().getName());
        LOC_CONFIG.set("shops." + key + ".sign.x", (Object)signLoc.getBlockX());
        LOC_CONFIG.set("shops." + key + ".sign.y", (Object)signLoc.getBlockY());
        LOC_CONFIG.set("shops." + key + ".sign.z", (Object)signLoc.getBlockZ());
        try {
            LOC_CONFIG.save(LOC_FILE);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static boolean isProtectedSign(Location loc) {
        return SIGN_TO_CHEST.containsKey(loc);
    }

    public static Location getSignLocation(Location chestLoc) {
        String key = ChestShopManager.locationToString(chestLoc);
        ConfigurationSection cs = LOC_CONFIG.getConfigurationSection("shops." + key + ".sign");
        if (cs == null) {
            return null;
        }
        World world = Bukkit.getWorld((String)cs.getString("world"));
        int x = cs.getInt("x");
        int y = cs.getInt("y");
        int z = cs.getInt("z");
        if (world == null) {
            return null;
        }
        return new Location(world, (double)x, (double)y, (double)z);
    }

    public static void removeSign(Location signLoc) {
        SIGN_TO_CHEST.remove(signLoc);
        for (String key : LOC_CONFIG.getConfigurationSection("shops").getKeys(false)) {
            int z;
            int y;
            int x;
            World world;
            ConfigurationSection cs = LOC_CONFIG.getConfigurationSection("shops." + key + ".sign");
            if (cs == null || !signLoc.equals((Object)new Location(world = Bukkit.getWorld((String)cs.getString("world")), (double)(x = cs.getInt("x")), (double)(y = cs.getInt("y")), (double)(z = cs.getInt("z"))))) continue;
            LOC_CONFIG.set("shops." + key + ".sign", null);
            try {
                LOC_CONFIG.save(LOC_FILE);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            break;
        }
    }

    public static void registerShop(ChestShop shop) {
        SHOP_MAP.put(shop.getChestLocation(), shop);
        PLAYER_SHOP_COUNT.put(shop.getOwner(), ChestShopManager.getShopCount(shop.getOwner()) + 1);
        ChestShopLog.logCreate(shop);
        ChestShopManager.saveLocation(shop.getChestLocation(), shop);
    }

    public static void removeShop(Location location) {
        ChestShop shop = SHOP_MAP.remove(location);
        if (shop != null) {
            PLAYER_SHOP_COUNT.put(shop.getOwner(), ChestShopManager.getShopCount(shop.getOwner()) - 1);
            ChestShopLog.logRemove(shop);
            ChestShopManager.removeLocation(location);
        }
    }

    private static void removeLocation(Location loc) {
        String key = ChestShopManager.locationToString(loc);
        LOC_CONFIG.set("shops." + key, null);
        try {
            LOC_CONFIG.save(LOC_FILE);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void saveShops() {
        SHOP_CONFIG.set("shops", null);
        int i = 0;
        for (ChestShop shop : SHOP_MAP.values()) {
            String path = "shops." + i;
            SHOP_CONFIG.set(path + ".owner", (Object)shop.getOwner().toString());
            SHOP_CONFIG.set(path + ".world", (Object)shop.getChestLocation().getWorld().getName());
            SHOP_CONFIG.set(path + ".x", (Object)shop.getChestLocation().getBlockX());
            SHOP_CONFIG.set(path + ".y", (Object)shop.getChestLocation().getBlockY());
            SHOP_CONFIG.set(path + ".z", (Object)shop.getChestLocation().getBlockZ());
            SHOP_CONFIG.set(path + ".price", (Object)shop.getPricePerItem());
            SHOP_CONFIG.set(path + ".item", (Object)shop.getItem());
            List<String> staffUUIDs = shop.getStaff().stream().map(UUID::toString).toList();
            SHOP_CONFIG.set(path + ".staff", staffUUIDs);
            ++i;
        }
        try {
            SHOP_CONFIG.save(SHOP_FILE);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static ChestShop getShop(Location location) {
        return SHOP_MAP.get(location);
    }

    public static boolean isShop(Location location) {
        return SHOP_MAP.containsKey(location);
    }

    public static int getShopCount(UUID uuid) {
        return PLAYER_SHOP_COUNT.getOrDefault(uuid, 0);
    }

    public static Collection<ChestShop> getAllShops() {
        return SHOP_MAP.values();
    }

    private static void saveLocation(Location loc, ChestShop shop) {
        String key = ChestShopManager.locationToString(loc);
        LOC_CONFIG.set("shops." + key + ".world", (Object)loc.getWorld().getName());
        LOC_CONFIG.set("shops." + key + ".x", (Object)loc.getBlockX());
        LOC_CONFIG.set("shops." + key + ".y", (Object)loc.getBlockY());
        LOC_CONFIG.set("shops." + key + ".z", (Object)loc.getBlockZ());
        LOC_CONFIG.set("shops." + key + ".owner", (Object)shop.getOwner().toString());
        LOC_CONFIG.set("shops." + key + ".price", (Object)shop.getPricePerItem());
        LOC_CONFIG.set("shops." + key + ".item", (Object)shop.getItem());
        try {
            LOC_CONFIG.save(LOC_FILE);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static String locationToString(Location loc) {
        return loc.getWorld().getName() + "_" + loc.getBlockX() + "_" + loc.getBlockY() + "_" + loc.getBlockZ();
    }

    public static void loadShops() {
        if (!LOC_FILE.exists()) {
            return;
        }
        ConfigurationSection section = LOC_CONFIG.getConfigurationSection("shops");
        if (section == null) {
            return;
        }
        for (String key : section.getKeys(false)) {
            ConfigurationSection cs = section.getConfigurationSection(key);
            if (cs == null) continue;
            String worldName = cs.getString("world");
            int x = cs.getInt("x");
            int y = cs.getInt("y");
            int z = cs.getInt("z");
            World world = Bukkit.getWorld((String)worldName);
            if (world == null) continue;
            Location loc = new Location(world, (double)x, (double)y, (double)z);
            UUID owner = UUID.fromString(cs.getString("owner"));
            double price = cs.getDouble("price");
            ItemStack item = cs.getItemStack("item");
            ChestShop shop = new ChestShop(owner, loc, item, price);
            SHOP_MAP.put(loc, shop);
            PLAYER_SHOP_COUNT.put(owner, ChestShopManager.getShopCount(owner) + 1);
            ConfigurationSection signSection = cs.getConfigurationSection("sign");
            if (signSection == null) continue;
            World signWorld = Bukkit.getWorld((String)signSection.getString("world"));
            int sx = signSection.getInt("x");
            int sy = signSection.getInt("y");
            int sz = signSection.getInt("z");
            if (signWorld == null) continue;
            Location signLoc = new Location(signWorld, (double)sx, (double)sy, (double)sz);
            SIGN_TO_CHEST.put(signLoc, loc);
        }
    }
}

