/*
 * Decompiled with CFR 0.152.
 */
package de.flipper1406.futureleague_wirtschaft.Regions;

import de.flipper1406.futureleague_wirtschaft.Regions.BlockStateData;
import de.flipper1406.futureleague_wirtschaft.Regions.Region;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.data.BlockData;

public class BlockStorage {
    private static final int FIRST_PARAMETER_INDEX = 1;
    private static final int SECCOND_PARAMETER_INDEX = 2;
    private static final int THIRD_PARAMETER_INDEX = 3;
    private static final int FOURTH_PARAMETER_INDEX = 4;
    private static final int FIFTH_PARAMETER_INDEX = 5;
    private final File dbFile;
    private final String dbUrl;

    public BlockStorage(String regionName, File regionFolder) {
        this.dbFile = new File(regionFolder, regionName.toLowerCase() + ".db");
        this.dbUrl = "jdbc:sqlite:" + this.dbFile.getAbsolutePath();
        this.createTable();
    }

    private void createTable() {
        try (Connection conn = DriverManager.getConnection(this.dbUrl);
             Statement stmt = conn.createStatement();){
            stmt.execute("    CREATE TABLE IF NOT EXISTS region_blocks (\n        x INTEGER NOT NULL,\n        y INTEGER NOT NULL,\n        z INTEGER NOT NULL,\n        material TEXT NOT NULL,\n        block_data TEXT NOT NULL\n    );\n");
        }
        catch (SQLException e) {
            Bukkit.getLogger().severe("[BlockStorage] Fehler beim Erstellen der Datenbanktabelle:");
            e.printStackTrace();
        }
    }

    public void saveBlocks(Region region) {
        List<BlockStateData> blocks = region.getSavedBlocks();
        if (blocks == null || blocks.isEmpty()) {
            return;
        }
        try (Connection conn = DriverManager.getConnection(this.dbUrl);){
            conn.setAutoCommit(false);
            try (Statement clearStmt = conn.createStatement();){
                clearStmt.execute("DELETE FROM region_blocks");
            }
            String insertSQL = "INSERT INTO region_blocks ( x, y, z, material, block_data) VALUES (?, ?, ?, ?, ?)";
            try (PreparedStatement insertStmt = conn.prepareStatement(insertSQL);){
                for (BlockStateData b : blocks) {
                    insertStmt.setInt(1, b.getX());
                    insertStmt.setInt(2, b.getY());
                    insertStmt.setInt(3, b.getZ());
                    insertStmt.setString(4, b.getMaterial().name());
                    insertStmt.setString(5, b.getBlockData().getAsString());
                    insertStmt.addBatch();
                }
                insertStmt.executeBatch();
            }
            conn.commit();
        }
        catch (SQLException e) {
            Bukkit.getLogger().warning("[BlockStorage] Fehler beim Speichern der Bl\u00f6cke f\u00fcr Region " + region.getName());
            e.printStackTrace();
        }
    }

    public List<BlockStateData> loadBlocks(Region region) {
        ArrayList<BlockStateData> result = new ArrayList<BlockStateData>();
        try (Connection conn = DriverManager.getConnection(this.dbUrl);
             PreparedStatement stmt = conn.prepareStatement("SELECT x, y, z, material, block_data FROM region_blocks");
             ResultSet rs = stmt.executeQuery();){
            while (rs.next()) {
                int x = rs.getInt("x");
                int y = rs.getInt("y");
                int z = rs.getInt("z");
                Material material = Material.valueOf((String)rs.getString("material"));
                BlockData data = Bukkit.createBlockData((String)rs.getString("block_data"));
                result.add(new BlockStateData(x, y, z, material, data));
            }
        }
        catch (Exception e) {
            Bukkit.getLogger().warning("[BlockStorage] Fehler beim Laden der Bl\u00f6cke f\u00fcr Region " + region.getName());
            e.printStackTrace();
        }
        return result;
    }

    public void deleteBlockFile() {
        boolean deleted;
        if (this.dbFile.exists() && !(deleted = this.dbFile.delete())) {
            Bukkit.getLogger().warning("[BlockStorage] Konnte Datei " + this.dbFile.getName() + " nicht l\u00f6schen.");
        }
    }

    public File getDbFile() {
        return this.dbFile;
    }
}

