/*
 * Decompiled with CFR 0.152.
 */
package de.flipper1406.futureleague_wirtschaft.Regions;

import de.flipper1406.futureleague_wirtschaft.Regions.Region;
import de.flipper1406.futureleague_wirtschaft.Regions.RegionManager;
import de.flipper1406.futureleague_wirtschaft.Regions.RegionSelectionTool;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockFertilizeEvent;
import org.bukkit.event.block.BlockFromToEvent;
import org.bukkit.event.block.BlockGrowEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.event.block.BlockSpreadEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.world.StructureGrowEvent;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public class RegionListener
implements Listener {
    private final Map<UUID, Long> lastWarningTime = new ConcurrentHashMap<UUID, Long>();
    private static final long WARNING_COOLDOWN_MS = 5000L;

    @EventHandler
    public void onInteract(PlayerInteractEvent event) {
        Location loc;
        Player player = event.getPlayer();
        ItemStack item = event.getItem();
        if (item == null || item.getType() != Material.DIAMOND_AXE) {
            return;
        }
        if (!item.hasItemMeta() || !item.getItemMeta().hasDisplayName()) {
            return;
        }
        if (!item.getItemMeta().getDisplayName().equals(String.valueOf(ChatColor.AQUA) + "Region-Tool")) {
            return;
        }
        if (!player.getWorld().getName().equalsIgnoreCase("city")) {
            return;
        }
        Location location = loc = event.getClickedBlock() != null ? event.getClickedBlock().getLocation() : null;
        if (loc == null) {
            return;
        }
        if (event.getAction() == Action.LEFT_CLICK_BLOCK) {
            RegionSelectionTool.setPos1(player, loc);
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Position 1 gesetzt: " + this.format(loc));
        } else if (event.getAction() == Action.RIGHT_CLICK_BLOCK) {
            RegionSelectionTool.setPos2(player, loc);
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Position 2 gesetzt: " + this.format(loc));
        }
        event.setCancelled(true);
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onTreeGrow(StructureGrowEvent event) {
        if (!event.getWorld().getName().equalsIgnoreCase("city")) {
            return;
        }
        RegionManager regionManager = RegionManager.getInstance();
        Player player = event.getPlayer();
        UUID playerUUID = player != null ? player.getUniqueId() : null;
        event.getBlocks().removeIf(state -> {
            Location loc = state.getLocation();
            Region region = regionManager.getRegion(loc);
            if (region == null) {
                return true;
            }
            if (playerUUID != null) {
                boolean isOwner = region.getOwner() != null && region.getOwner().equals(playerUUID);
                boolean isCoOwner = region.getCoOwner() != null && region.getCoOwner().equals(player.getName());
                boolean isStaff = region.getStaff().contains(playerUUID);
                if (!(isOwner || isCoOwner || isStaff)) {
                    return true;
                }
            }
            return false;
        });
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPlantGrow(BlockGrowEvent event) {
        if (!event.getBlock().getWorld().getName().equalsIgnoreCase("city")) {
            return;
        }
        Region region = RegionManager.getInstance().getRegion(event.getBlock().getLocation());
        if (region == null) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onBlockSpread(BlockSpreadEvent event) {
        if (!event.getBlock().getWorld().getName().equalsIgnoreCase("city")) {
            return;
        }
        Region toRegion = RegionManager.getInstance().getRegion(event.getBlock().getLocation());
        Region fromRegion = RegionManager.getInstance().getRegion(event.getSource().getLocation());
        if (fromRegion == null || !fromRegion.equals(toRegion)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onBonemeal(BlockFertilizeEvent event) {
        if (!event.getBlock().getWorld().getName().equalsIgnoreCase("city")) {
            return;
        }
        event.getBlocks().removeIf(blockState -> RegionManager.getInstance().getRegion(blockState.getLocation()) == null);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onBlockBreak(BlockBreakEvent event) {
        if (!event.getBlock().getWorld().getName().equalsIgnoreCase("city")) {
            return;
        }
        Player p = event.getPlayer();
        UUID uuid = p.getUniqueId();
        if (p.hasPermission("fl.regions.admin")) {
            return;
        }
        Region region = RegionManager.getInstance().getRegion(event.getBlock().getLocation());
        if (region == null) {
            p.sendMessage(String.valueOf(ChatColor.RED) + "Du darfst hier nicht abbauen.");
            event.setCancelled(true);
            return;
        }
        boolean isOwner = region.getOwner() != null && region.getOwner().equals(uuid);
        boolean isStaff = region.getStaff().contains(uuid);
        boolean isCoOwner = false;
        if (region.getCoOwner().equals(p.getName())) {
            isCoOwner = true;
        }
        if (!(isOwner || isStaff || isCoOwner)) {
            p.sendMessage(String.valueOf(ChatColor.RED) + "Du darfst hier nicht abbauen.");
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onBlockPlace(BlockPlaceEvent event) {
        if (!event.getBlock().getWorld().getName().equalsIgnoreCase("city")) {
            return;
        }
        Player p = event.getPlayer();
        UUID uuid = p.getUniqueId();
        if (p.hasPermission("fl.regions.admin")) {
            return;
        }
        Region region = RegionManager.getInstance().getRegion(event.getBlock().getLocation());
        if (region == null) {
            event.setCancelled(true);
            p.sendMessage("\u00a7cDu darfst hier nicht bauen.");
            return;
        }
        boolean isOwner = region.getOwner() != null && region.getOwner().equals(uuid);
        boolean isStaff = region.getStaff().contains(uuid);
        boolean isCoOwner = false;
        if (region.getCoOwner().equals(p.getName())) {
            isCoOwner = true;
        }
        if (!(isOwner || isStaff || isCoOwner)) {
            p.sendMessage(String.valueOf(ChatColor.RED) + "Du darfst hier nicht bauen.");
            event.setCancelled(true);
        }
    }

    private String format(Location loc) {
        return "(" + loc.getBlockX() + ", " + loc.getBlockY() + ", " + loc.getBlockZ() + ")";
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onLiquidFlow(BlockFromToEvent event) {
        Location from = event.getBlock().getLocation();
        Location to = event.getToBlock().getLocation();
        if (!from.getWorld().getName().equalsIgnoreCase("city")) {
            return;
        }
        RegionManager regionManager = RegionManager.getInstance();
        Region fromRegion = regionManager.getRegion(from);
        Region toRegion = regionManager.getRegion(to);
        if (fromRegion != null && !fromRegion.equals(toRegion)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPistonExtend(BlockPistonExtendEvent event) {
        Bukkit.getConsoleSender().sendMessage("\u00a74TEST");
        Location pistonLoc = event.getBlock().getLocation();
        Region pistonRegion = RegionManager.getInstance().getRegion(pistonLoc);
        if (pistonRegion == null) {
            return;
        }
        for (Block block : event.getBlocks()) {
            Region blockRegion = RegionManager.getInstance().getRegion(block.getLocation());
            Location targetLoc = block.getRelative(event.getDirection()).getLocation();
            Region targetRegion = RegionManager.getInstance().getRegion(targetLoc);
            if (pistonRegion.equals(blockRegion) && pistonRegion.equals(targetRegion)) continue;
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPistonRetract(BlockPistonRetractEvent event) {
        Region pistonRegion = RegionManager.getInstance().getRegion(event.getBlock().getLocation());
        if (pistonRegion == null) {
            return;
        }
        for (Block block : event.getBlocks()) {
            Region blockRegion = RegionManager.getInstance().getRegion(block.getLocation());
            Location targetLoc = block.getRelative(event.getDirection()).getLocation();
            Region targetRegion = RegionManager.getInstance().getRegion(targetLoc);
            if (Objects.equals(pistonRegion, blockRegion) && Objects.equals(pistonRegion, targetRegion)) continue;
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onRedstoneSignal(BlockRedstoneEvent event) {
        Block block = event.getBlock();
        Region receivingRegion = RegionManager.getInstance().getRegion(block.getLocation());
        if (event.getOldCurrent() >= event.getNewCurrent()) {
            return;
        }
        for (BlockFace face : BlockFace.values()) {
            Block neighbor = block.getRelative(face);
            if (neighbor == null) continue;
            Region neighborRegion = RegionManager.getInstance().getRegion(neighbor.getLocation());
            if (neighborRegion != null && receivingRegion == null) {
                event.setNewCurrent(0);
                return;
            }
            if (neighborRegion != null && receivingRegion != null && !neighborRegion.equals(receivingRegion)) {
                event.setNewCurrent(0);
                return;
            }
            if (!(neighborRegion == null && receivingRegion != null || neighborRegion != null && receivingRegion != null && neighborRegion.equals(receivingRegion) || neighborRegion != null) && receivingRegion != null) continue;
        }
    }

    @EventHandler
    public void onInteraction(PlayerInteractEvent event) {
        Location loc;
        Player player = event.getPlayer();
        if (!player.getWorld().getName().equalsIgnoreCase("city")) {
            return;
        }
        Location location = loc = event.getClickedBlock() != null ? event.getClickedBlock().getLocation() : null;
        if (loc == null) {
            return;
        }
        Region region = RegionManager.getInstance().getRegion(loc);
        if (region == null) {
            return;
        }
        UUID uuid = player.getUniqueId();
        boolean isOwner = region.getOwner() != null && region.getOwner().equals(uuid) || region.getCoOwner() != null && region.getCoOwner().equals(Bukkit.getOfflinePlayer((UUID)uuid).getName());
        boolean isAdmin = player.hasPermission("fl.region.admin");
        Material type = event.getClickedBlock().getType();
        if (!(type != Material.CHEST && type != Material.BARREL || isOwner || isAdmin || region.getInteraction("truhen"))) {
            player.sendMessage("\u00a7cDu darfst diese Truhe hier nicht \u00f6ffnen.");
            event.setCancelled(true);
        }
        if (!(type != Material.TRAPPED_CHEST || isOwner || isAdmin || region.getInteraction("redstone_truhen"))) {
            player.sendMessage("\u00a7cDu darfst diese Redstone-Truhe hier nicht benutzen.");
            event.setCancelled(true);
        }
        if (type.name().contains("DOOR") && !region.getInteraction("tueren") && !isOwner && !isAdmin) {
            event.setCancelled(true);
            if (this.canSendWarning(player.getUniqueId(), "druckplatten")) {
                player.sendMessage("\u00a7cDu darfst diese T\u00fcr hier nicht benutzen.");
            }
        }
        if (type.name().contains("BUTTON") && !region.getInteraction("knoepfe") && !isOwner && !isAdmin) {
            event.setCancelled(true);
            if (this.canSendWarning(player.getUniqueId(), "druckplatten")) {
                player.sendMessage("\u00a7cDu darfst diese Druckplatte hier nicht betreten.");
            }
        }
        if (type.name().contains("PRESSURE_PLATE") && !region.getInteraction("druckplatten") && !isOwner && !isAdmin) {
            event.setCancelled(true);
            if (this.canSendWarning(player.getUniqueId(), "druckplatten")) {
                player.sendMessage("\u00a7cDu darfst diese Druckplatte hier nicht betreten.");
            }
        }
    }

    private boolean canSendWarning(UUID playerUUID, String warningKey) {
        long last;
        long now = System.currentTimeMillis();
        if (now - (last = this.lastWarningTime.getOrDefault(playerUUID, 0L).longValue()) >= 5000L) {
            this.lastWarningTime.put(playerUUID, now);
            return true;
        }
        return false;
    }

    @EventHandler
    public void onInventoryOpen(InventoryOpenEvent event) {
        InventoryHolder holder;
        InventoryType eventInventory = event.getView().getType();
        if (eventInventory == InventoryType.FURNACE) {
            InventoryHolder holder2 = event.getInventory().getHolder();
            if (holder2 instanceof BlockState) {
                BlockState blockState = (BlockState)holder2;
                Location loc = blockState.getBlock().getLocation();
                if (!loc.getWorld().getName().equals("city")) {
                    return;
                }
                if (!this.playerIsAllowedToOpenFurnance((Player)event.getPlayer(), RegionManager.getInstance().getRegion(loc))) {
                    event.setCancelled(true);
                }
            }
        } else if (eventInventory == InventoryType.BLAST_FURNACE) {
            InventoryHolder holder3 = event.getInventory().getHolder();
            if (holder3 instanceof BlockState) {
                BlockState blockState = (BlockState)holder3;
                Location loc = blockState.getBlock().getLocation();
                if (!loc.getWorld().getName().equals("city")) {
                    return;
                }
                if (!this.playerIsAllowedToOpenBlastFurnance((Player)event.getPlayer(), RegionManager.getInstance().getRegion(loc))) {
                    event.setCancelled(true);
                }
            }
        } else if (eventInventory == InventoryType.BREWING) {
            InventoryHolder holder4 = event.getInventory().getHolder();
            if (holder4 instanceof BlockState) {
                BlockState blockState = (BlockState)holder4;
                Location loc = blockState.getBlock().getLocation();
                if (!loc.getWorld().getName().equals("city")) {
                    return;
                }
                if (!this.playerIsAllowedToOpenBrewing((Player)event.getPlayer(), RegionManager.getInstance().getRegion(loc))) {
                    event.setCancelled(true);
                }
            }
        } else if (eventInventory == InventoryType.CRAFTER) {
            InventoryHolder holder5 = event.getInventory().getHolder();
            if (holder5 instanceof BlockState) {
                BlockState blockState = (BlockState)holder5;
                Location loc = blockState.getBlock().getLocation();
                if (!loc.getWorld().getName().equals("city")) {
                    return;
                }
                if (!this.playerIsAllowedToOpenCrafter((Player)event.getPlayer(), RegionManager.getInstance().getRegion(loc))) {
                    event.setCancelled(true);
                }
            }
        } else if (eventInventory == InventoryType.HOPPER) {
            InventoryHolder holder6 = event.getInventory().getHolder();
            if (holder6 instanceof BlockState) {
                BlockState blockState = (BlockState)holder6;
                Location loc = blockState.getBlock().getLocation();
                if (!loc.getWorld().getName().equals("city")) {
                    return;
                }
                if (!this.playerIsAllowedToOpenHopper((Player)event.getPlayer(), RegionManager.getInstance().getRegion(loc))) {
                    event.setCancelled(true);
                }
            }
        } else if (eventInventory == InventoryType.DROPPER) {
            InventoryHolder holder7 = event.getInventory().getHolder();
            if (holder7 instanceof BlockState) {
                BlockState blockState = (BlockState)holder7;
                Location loc = blockState.getBlock().getLocation();
                if (!loc.getWorld().getName().equals("city")) {
                    return;
                }
                if (!this.playerIsAllowedToOpenDropper((Player)event.getPlayer(), RegionManager.getInstance().getRegion(loc))) {
                    event.setCancelled(true);
                }
            }
        } else if (eventInventory == InventoryType.DISPENSER && (holder = event.getInventory().getHolder()) instanceof BlockState) {
            BlockState blockState = (BlockState)holder;
            Location loc = blockState.getBlock().getLocation();
            if (!loc.getWorld().getName().equals("city")) {
                return;
            }
            if (!this.playerIsAllowedToOpenDispenser((Player)event.getPlayer(), RegionManager.getInstance().getRegion(loc))) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void onPlayerInteractEvent(PlayerInteractEvent event) {
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (event.getClickedBlock().getType() != Material.ANVIL) {
            return;
        }
        if (!event.getPlayer().getLocation().getWorld().getName().equals("city")) {
            return;
        }
        if (!this.playerIsAllowedToOpenAnvil(event.getPlayer(), RegionManager.getInstance().getRegion(event.getPlayer().getLocation()))) {
            event.setCancelled(true);
        }
    }

    public boolean playerIsAllowedToOpenAnvil(Player p, Region region) {
        return p.getUniqueId() == region.getOwner() || p.getName().equals(region.getCoOwner()) || region.isBuilder(p.getUniqueId()) || p.hasPermission("fl.admin");
    }

    public boolean playerIsAllowedToOpenFurnance(Player p, Region region) {
        return p.getUniqueId() == region.getOwner() || p.getName().equals(region.getCoOwner()) || region.isBuilder(p.getUniqueId()) || p.hasPermission("fl.admin");
    }

    public boolean playerIsAllowedToOpenBlastFurnance(Player p, Region region) {
        return p.getUniqueId() == region.getOwner() || p.getName().equals(region.getCoOwner()) || region.isBuilder(p.getUniqueId()) || p.hasPermission("fl.admin");
    }

    public boolean playerIsAllowedToOpenBrewing(Player p, Region region) {
        return p.getUniqueId() == region.getOwner() || p.getName().equals(region.getCoOwner()) || region.isBuilder(p.getUniqueId()) || p.hasPermission("fl.admin");
    }

    public boolean playerIsAllowedToOpenCrafter(Player p, Region region) {
        return p.getUniqueId() == region.getOwner() || p.getName().equals(region.getCoOwner()) || region.isBuilder(p.getUniqueId()) || p.hasPermission("fl.admin");
    }

    public boolean playerIsAllowedToOpenHopper(Player p, Region region) {
        return p.getUniqueId() == region.getOwner() || p.getName().equals(region.getCoOwner()) || region.isBuilder(p.getUniqueId()) || p.hasPermission("fl.admin");
    }

    public boolean playerIsAllowedToOpenDispenser(Player p, Region region) {
        return p.getUniqueId() == region.getOwner() || p.getName().equals(region.getCoOwner()) || region.isBuilder(p.getUniqueId()) || p.hasPermission("fl.admin");
    }

    public boolean playerIsAllowedToOpenDropper(Player p, Region region) {
        return p.getUniqueId() == region.getOwner() || p.getName().equals(region.getCoOwner()) || region.isBuilder(p.getUniqueId()) || p.hasPermission("fl.admin");
    }
}

