/*
 * Decompiled with CFR 0.152.
 */
package de.flipper1406.futureleague_wirtschaft.ChestShop;

import de.flipper1406.futureleague_wirtschaft.ChestShop.ChestShop;
import de.flipper1406.futureleague_wirtschaft.ChestShop.ChestShopLimit;
import de.flipper1406.futureleague_wirtschaft.ChestShop.ChestShopLog;
import de.flipper1406.futureleague_wirtschaft.ChestShop.ChestShopManager;
import de.flipper1406.futureleague_wirtschaft.ChestShop.OfflineMessageManager;
import de.flipper1406.futureleague_wirtschaft.FutureLeagueWirtschaft;
import de.flipper1406.futureleague_wirtschaft.Regions.Region;
import de.flipper1406.futureleague_wirtschaft.Regions.RegionManager;
import de.flipper1406.futureleague_wirtschaft.Userdata.Utils.UserDataManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Chest;
import org.bukkit.block.Sign;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.block.data.type.WallSign;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.scheduler.BukkitRunnable;

public class ChestShopListener
implements Listener {
    public static final int I = 1;
    public static final int II = 2;
    public static final int III = 3;
    public static final int IV = 4;
    public static final int V = 5;
    public static final int VI = 6;
    public static final int VII = 7;
    public static final int VIII = 8;
    public static final int IX = 9;
    public static final int X = 10;
    private final int firstLine = 0;
    private final int secondLine = 1;
    private final int thirdLine = 2;
    private final int fourthLine = 3;
    private final double maxSearchRadius = 5.0;
    private static final double PERCENT_DIVISOR = 100.0;
    private final Map<UUID, ChestShop> pendingBuyers = new HashMap<UUID, ChestShop>();
    private final Map<UUID, Block> pendingShopCreation = new HashMap<UUID, Block>();
    private final Map<UUID, ChestShop> pendingStaffAdds = new HashMap<UUID, ChestShop>();
    private static final Map<UUID, ChestShop> PENDING_STAFF_EDIT = new HashMap<UUID, ChestShop>();
    private final int mainInventorySize = 36;
    private static final double TAX_PERCENT = 10.0;
    private static final String CURRENCY = " Euro";

    @EventHandler
    public void onPlayerChestClick(PlayerInteractEvent event) {
        ChestShop shop;
        if (event.getAction() != Action.LEFT_CLICK_BLOCK) {
            return;
        }
        if (event.getClickedBlock() == null || event.getClickedBlock().getType() != Material.CHEST) {
            return;
        }
        Player player = event.getPlayer();
        Block block = event.getClickedBlock();
        Collection<Region> regions = RegionManager.getInstance().getAllRegions();
        boolean blockIsInRegion = false;
        for (Region region : regions) {
            if (!region.contains(block.getLocation())) continue;
            blockIsInRegion = true;
            OfflinePlayer owner = Bukkit.getOfflinePlayer((UUID)region.getOwner());
            String coOwnerName = region.getCoOwner();
            String name = owner != null && owner.getName() != null ? owner.getName() : "";
            String ownerName = name;
            String playerName = player.getName();
            if (playerName.equals(ownerName) || playerName.equalsIgnoreCase(coOwnerName) || player.hasPermission("fl.shops.admin")) continue;
            return;
        }
        if (!blockIsInRegion) {
            return;
        }
        ItemStack handItem = player.getInventory().getItemInMainHand();
        if (handItem == null || handItem.getType() == Material.AIR) {
            return;
        }
        String handItemName = handItem.getType().isBlock() ? FutureLeagueWirtschaft.getGermanName(handItem.getType()) : FutureLeagueWirtschaft.getGermanName(handItem);
        if (!player.isSneaking()) {
            return;
        }
        Location loc = block.getLocation();
        if (ChestShopManager.isShop(loc) && (shop = ChestShopManager.getShop(loc)).getOwner().equals(player.getUniqueId())) {
            event.setCancelled(true);
            PENDING_STAFF_EDIT.put(player.getUniqueId(), shop);
            player.sendMessage("\u00a7eMitbauer-Verwaltung:");
            player.sendMessage("\u00a77Gib den Namen des Spielers im Chat ein.");
            player.sendMessage("\u00a78\u2022 \u00a76Name\u00a77 \u2192 Mitbauer hinzuf\u00fcgen");
            player.sendMessage("\u00a78\u2022 \u00a76-Name\u00a77 \u2192 Mitbauer entfernen");
            player.sendMessage("\u00a78\u2022 \u00a76list\u00a77 \u2192 Mitbauer auflisten");
            player.sendMessage("\u00a78\u2022 \u00a7cstop\u00a77 \u2192 Eingabe abbrechen");
            return;
        }
        if (!ChestShopLimit.canCreateMore(player)) {
            player.sendMessage("\u00a7cDu hast dein Shoplimit erreicht.");
            return;
        }
        event.setCancelled(true);
        this.pendingShopCreation.put(player.getUniqueId(), block);
        player.sendMessage("\u00a7eF\u00fcr welchen Preis m\u00f6chtest du \u00a7b" + handItemName + " \u00a7everkaufen?");
    }

    @EventHandler
    public void onChatCreateShop(AsyncPlayerChatEvent event) {
        double price;
        final Player player = event.getPlayer();
        final UUID uuid = player.getUniqueId();
        if (!this.pendingShopCreation.containsKey(uuid)) {
            return;
        }
        event.setCancelled(true);
        String msg = event.getMessage();
        try {
            price = Double.parseDouble(msg.replace(",", "."));
            if (price <= 0.0) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException e) {
            player.sendMessage("\u00a7cUng\u00fcltiger Preis. Bitte gib eine Zahl gr\u00f6\u00dfer als 0 an.");
            return;
        }
        final Block chestBlock = this.pendingShopCreation.remove(uuid);
        final ItemStack item = player.getInventory().getItemInMainHand();
        new BukkitRunnable(){

            public void run() {
                ChestShop shop = new ChestShop(uuid, chestBlock.getLocation(), item.clone(), price);
                ChestShopManager.registerShop(shop);
                ChestShopListener.this.placeSign(chestBlock.getLocation(), shop);
                player.sendMessage("\u00a7aShop erfolgreich erstellt! Bei Verk\u00e4ufen gehen 10.0% Steuern an FL Network.");
            }
        }.runTask(Objects.requireNonNull(Bukkit.getPluginManager().getPlugin("FutureLeague_Wirtschaft")));
    }

    private void placeSign(Location chestLoc, ChestShop shop) {
        Player owner = Bukkit.getPlayer((UUID)shop.getOwner());
        if (owner == null) {
            return;
        }
        ItemStack shopItem = shop.getItem();
        String itemName = shopItem.getType().isBlock() ? FutureLeagueWirtschaft.getGermanName(shopItem.getType()) : FutureLeagueWirtschaft.getGermanName(shopItem);
        Block chestBlock = chestLoc.getBlock();
        BlockData chestData = chestBlock.getBlockData();
        if (!(chestData instanceof Directional)) {
            owner.sendMessage("\u00a7cDie Truhe hat keine Richtung. Schild kann nicht platziert werden.");
            return;
        }
        BlockFace facing = ((Directional)chestData).getFacing();
        Block signBlock = chestBlock.getRelative(facing);
        if (!signBlock.getType().isAir()) {
            owner.sendMessage("\u00a7cKein freier Platz zum Platzieren des Schildes direkt vor der Truhe.");
            return;
        }
        signBlock.setType(Material.OAK_WALL_SIGN);
        BlockState state = signBlock.getState();
        if (!(state instanceof Sign)) {
            owner.sendMessage("\u00a7cFehler beim Platzieren des Shopschildes.");
            return;
        }
        Sign sign = (Sign)state;
        BlockData signData = sign.getBlockData();
        if (!(signData instanceof WallSign)) {
            owner.sendMessage("\u00a7cBlockData des Schildes ist ung\u00fcltig.");
            return;
        }
        ((WallSign)signData).setFacing(facing);
        sign.setBlockData(signData);
        sign.setLine(0, "\u00a7a[Shop]");
        sign.setLine(1, itemName);
        sign.setLine(2, shop.getPricePerItem() + CURRENCY);
        sign.setLine(3, Objects.requireNonNull(Bukkit.getOfflinePlayer((UUID)shop.getOwner()).getName()));
        sign.update();
        ChestShopManager.registerSign(signBlock.getLocation(), shop.getChestLocation());
    }

    @EventHandler
    public void onSignClick(PlayerInteractEvent event) {
        String itemName;
        if (event.getAction() != Action.LEFT_CLICK_BLOCK) {
            return;
        }
        if (event.getClickedBlock() == null) {
            return;
        }
        Block clickedBlock = event.getClickedBlock();
        BlockState state = clickedBlock.getState();
        if (!(state instanceof Sign)) {
            return;
        }
        BlockData data = clickedBlock.getBlockData();
        if (!(data instanceof WallSign)) {
            return;
        }
        WallSign wallSign = (WallSign)data;
        BlockFace attachedFace = wallSign.getFacing().getOppositeFace();
        Block chestBlock = clickedBlock.getRelative(attachedFace);
        Location chestLoc = chestBlock.getLocation();
        if (!ChestShopManager.isShop(chestLoc)) {
            return;
        }
        ChestShop shop = ChestShopManager.getShop(chestLoc);
        Player player = event.getPlayer();
        ItemStack item = shop.getItem();
        String string = itemName = item.getType().isBlock() ? FutureLeagueWirtschaft.getGermanName(item.getType()) : FutureLeagueWirtschaft.getGermanName(item);
        if (player.isSneaking() && shop.isAuthorized(player.getUniqueId())) {
            event.setCancelled(true);
            PENDING_STAFF_EDIT.put(player.getUniqueId(), shop);
            player.sendMessage("\u00a7eMitbauer-Verwaltung:");
            player.sendMessage("\u00a77Gib den Namen des Spielers im Chat ein.");
            player.sendMessage("\u00a78\u2022 \u00a76Name\u00a77 \u2192 Mitbauer hinzuf\u00fcgen");
            player.sendMessage("\u00a78\u2022 \u00a76-Name\u00a77 \u2192 Mitbauer entfernen");
            player.sendMessage("\u00a78\u2022 \u00a76list\u00a77 \u2192 Mitbauer auflisten");
            player.sendMessage("\u00a78\u2022 \u00a7cstop\u00a77 \u2192 Eingabe abbrechen");
            return;
        }
        int stock = this.countItemsInChest(chestLoc, item);
        player.sendMessage("\u00a7a\u00a7lShop-Informationen:");
        player.sendMessage("\u00a77Item: \u00a7f" + itemName);
        player.sendMessage("\u00a77Preis pro St\u00fcck: \u00a7f" + shop.getPricePerItem() + CURRENCY);
        player.sendMessage("\u00a77Verk\u00e4ufer: \u00a7f" + Bukkit.getOfflinePlayer((UUID)shop.getOwner()).getName());
        player.sendMessage("\u00a77Verf\u00fcgbar: \u00a7f" + stock + " St\u00fcck");
        ItemMeta meta = item.getItemMeta();
        if (meta != null && meta.hasEnchants()) {
            player.sendMessage("\u00a77Verzauberungen:");
            for (Map.Entry entry : meta.getEnchants().entrySet()) {
                Enchantment enchantment = (Enchantment)entry.getKey();
                int level = (Integer)entry.getValue();
                String enchantKey = enchantment.getKey().getKey().replace("_", " ");
                String formatted = enchantKey.substring(0, 1).toUpperCase() + enchantKey.substring(1);
                player.sendMessage("\u00a77 - \u00a7f" + FutureLeagueWirtschaft.getGermanName(formatted) + " " + ChestShopListener.toRoman(level));
            }
        }
        player.sendMessage("\u00a7eWie viele m\u00f6chtest du kaufen?");
        this.pendingBuyers.put(player.getUniqueId(), shop);
    }

    @EventHandler
    public void onChatForStaffEdit(AsyncPlayerChatEvent event) {
        final Player player = event.getPlayer();
        UUID uuid = player.getUniqueId();
        if (!PENDING_STAFF_EDIT.containsKey(uuid)) {
            return;
        }
        event.setCancelled(true);
        final String message = event.getMessage().trim();
        final ChestShop shop = PENDING_STAFF_EDIT.remove(uuid);
        new BukkitRunnable(){

            public void run() {
                if (message.equalsIgnoreCase("list")) {
                    ArrayList<UUID> staffList = new ArrayList<UUID>(shop.getStaff());
                    if (staffList.isEmpty()) {
                        player.sendMessage("\u00a77Keine Mitbauer vorhanden.");
                    } else {
                        player.sendMessage("\u00a7eMitbauer:");
                        for (UUID id : staffList) {
                            OfflinePlayer p = Bukkit.getOfflinePlayer((UUID)id);
                            player.sendMessage("\u00a77- " + p.getName());
                        }
                    }
                    return;
                }
                if (message.equalsIgnoreCase("stop")) {
                    player.sendMessage("\u00a7cDas Bearbeiten der Mitarbeiter wurde abgebrochen.");
                    return;
                }
                boolean remove = message.startsWith("-");
                String name = remove ? message.substring(1) : message;
                OfflinePlayer target = Bukkit.getOfflinePlayer((String)name);
                if (target == null || !target.hasPlayedBefore() && !target.isOnline()) {
                    player.sendMessage("\u00a7cSpieler wurde nicht gefunden.");
                    return;
                }
                UUID targetUUID = target.getUniqueId();
                if (remove) {
                    if (!shop.getStaff().contains(targetUUID)) {
                        player.sendMessage("\u00a7cDieser Spieler ist kein Mitbauer.");
                        return;
                    }
                    shop.removeStaff(targetUUID);
                    ChestShopManager.saveShops();
                    player.sendMessage("\u00a7a" + target.getName() + " wurde als Mitbauer entfernt.");
                    return;
                }
                if (targetUUID.equals(shop.getOwner())) {
                    player.sendMessage("\u00a7cDu kannst den Besitzer nicht als Mitbauer hinzuf\u00fcgen.");
                    return;
                }
                if (shop.getStaff().contains(targetUUID)) {
                    player.sendMessage("\u00a7cDieser Spieler ist bereits Mitbauer.");
                    return;
                }
                shop.addStaff(targetUUID);
                ChestShopManager.saveShops();
                player.sendMessage("\u00a7a" + target.getName() + " wurde als Mitbauer hinzugef\u00fcgt.");
            }
        }.runTask(Objects.requireNonNull(Bukkit.getPluginManager().getPlugin("FutureLeague_Wirtschaft")));
    }

    @EventHandler
    public void onChatBuy(AsyncPlayerChatEvent event) {
        Player player = event.getPlayer();
        UUID uuid = player.getUniqueId();
        if (!this.pendingBuyers.containsKey(uuid)) {
            return;
        }
        event.setCancelled(true);
        ChestShop shop = this.pendingBuyers.remove(uuid);
        String itemName = this.getItemName(shop);
        int amount = this.validateAmount(player, event.getMessage());
        if (amount == -1) {
            return;
        }
        if (!this.checkInventorySpace(player, shop.getItem(), amount, itemName)) {
            return;
        }
        this.processPurchase(shop, player, amount, itemName);
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        Player player;
        Location loc = event.getBlock().getLocation();
        if (ChestShopManager.isProtectedSign(loc)) {
            event.setCancelled(true);
            event.getPlayer().sendMessage("\u00a7cDieses Schild geh\u00f6rt zu einem Shop und kann nicht abgebaut werden.");
            return;
        }
        if (!ChestShopManager.isShop(loc)) {
            return;
        }
        ChestShop shop = ChestShopManager.getShop(loc);
        if (!shop.isAuthorized((player = event.getPlayer()).getUniqueId())) {
            event.setCancelled(true);
            player.sendMessage("\u00a7cDu darfst diesen Shop nicht abbauen.");
            return;
        }
        Location signLoc = ChestShopManager.getSignLocation(shop.getChestLocation());
        if (signLoc != null) {
            signLoc.getBlock().setType(Material.AIR);
            ChestShopManager.removeSign(signLoc);
        }
        ChestShopManager.removeShop(loc);
        player.sendMessage("\u00a7aShop erfolgreich entfernt.");
    }

    private String getItemName(ChestShop shop) {
        String itemName = "";
        if (shop.getItem().getType().isBlock()) {
            Material mat = shop.getItem().getType();
            itemName = FutureLeagueWirtschaft.getGermanName(mat);
        } else {
            itemName = FutureLeagueWirtschaft.getGermanName(shop.getItem());
        }
        return itemName;
    }

    private int validateAmount(Player player, String msg) {
        int amount;
        try {
            amount = Integer.parseInt(msg);
            if (amount <= 0) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException e) {
            player.sendMessage("\u00a7cUng\u00fcltige Menge. Bitte gib eine positive Zahl an.");
            return -1;
        }
        return amount;
    }

    private boolean checkInventorySpace(Player player, ItemStack item, int amount, String itemName) {
        int addable = this.getAddableAmount(player, item);
        if (amount > addable) {
            player.sendMessage("\u00a7cDu kannst maximal " + addable + " Mal " + itemName + " kaufen, da dein Inventar nicht gro\u00df genug ist.");
            return false;
        }
        return true;
    }

    private void processPurchase(final ChestShop shop, final Player player, final int amount, final String itemName) {
        new BukkitRunnable(){

            public void run() {
                double totalCost = shop.getPricePerItem() * (double)amount;
                double tax = totalCost * 10.0 / 100.0;
                double payout = totalCost - tax;
                double balance = UserDataManager.getBalance(player.getUniqueId());
                ItemStack item = shop.getItem();
                int available = ChestShopListener.this.countItemsInChest(shop.getChestLocation(), item);
                if (available < amount) {
                    player.sendMessage("\u00a7cEs sind nur " + available + " St\u00fcck verf\u00fcgbar.");
                    return;
                }
                if (balance < totalCost) {
                    player.sendMessage("\u00a7cDu hast nicht genug  Euro. Du brauchst \u00a7e" + totalCost + "\u00a7c Euro.");
                    return;
                }
                Inventory chestInv = ((InventoryHolder)shop.getChestLocation().getBlock().getState()).getInventory();
                int removed = ChestShopListener.this.removeItems(chestInv, item, amount);
                int remaining = ChestShopListener.this.countItemsInChest(shop.getChestLocation(), item);
                Player owner = Bukkit.getPlayer((UUID)shop.getOwner());
                String message = "\u00a7aDein Shop wurde besucht! \u00a7e" + player.getName() + " \u00a7ahat \u00a7f" + amount + "x " + itemName + " \u00a7af\u00fcr \u00a7e" + payout + " Euro \u00a7agekauft.";
                if (owner != null && owner.isOnline()) {
                    owner.sendMessage(message);
                } else {
                    OfflineMessageManager.addMessage(shop.getOwner(), message);
                }
                if (remaining <= 0) {
                    String warn = "\u00a7cDein Shop ist leer! F\u00fclle ihn wieder auf: \u00a77" + itemName + " (" + shop.getChestLocation().getBlockX() + "/" + shop.getChestLocation().getBlockY() + "/" + shop.getChestLocation().getBlockZ() + ")";
                    if (owner != null && owner.isOnline()) {
                        owner.sendMessage(warn);
                    } else {
                        OfflineMessageManager.addMessage(shop.getOwner(), warn);
                    }
                }
                if (removed < amount) {
                    player.sendMessage("\u00a7cFehler beim Entfernen der Items aus der Truhe.");
                    return;
                }
                ItemStack bought = item.clone();
                bought.setAmount(amount);
                player.getInventory().addItem(new ItemStack[]{bought});
                UserDataManager.removeBalance(player.getUniqueId(), totalCost);
                UserDataManager.addBalance(shop.getOwner(), payout);
                UserDataManager.logTransactionAsSend(shop.getOwner(), tax, "Steuerabgaben auf Verk\u00e4ufe", "FL Network");
                UserDataManager.logTransactionAsSend(player.getUniqueId(), totalCost, "Kauf von " + itemName + " x" + amount, Bukkit.getPlayer((UUID)shop.getOwner()).getName());
                UserDataManager.logTransactionAsReceipt(shop.getOwner(), player.getUniqueId(), totalCost, "Verkauf von " + itemName + " x" + amount);
                ChestShopLog.logPurchase(shop, player.getName(), amount);
                player.sendMessage("\u00a7aDu hast erfolgreich \u00a7f" + amount + "x " + FutureLeagueWirtschaft.getGermanName(shop.getItem()) + " \u00a7agekauft f\u00fcr \u00a7e" + totalCost + ChestShopListener.CURRENCY);
            }
        }.runTask(Objects.requireNonNull(Bukkit.getPluginManager().getPlugin("FutureLeague_Wirtschaft")));
    }

    @EventHandler
    public void onInventoryOpen(InventoryOpenEvent event) {
        if (!(event.getPlayer() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getPlayer();
        Inventory inv = event.getInventory();
        InventoryHolder holder = inv.getHolder();
        if (!(holder instanceof Chest)) {
            return;
        }
        Chest chest = (Chest)holder;
        Location chestLoc = chest.getLocation();
        if (!ChestShopManager.isShop(chestLoc)) {
            return;
        }
        ChestShop shop = ChestShopManager.getShop(chestLoc);
        if (!shop.isAuthorized(player.getUniqueId())) {
            player.sendMessage("\u00a7cDu darfst diese Shop-Truhe nicht \u00f6ffnen!");
            event.setCancelled(true);
        }
    }

    private int countItemsInChest(Location location, ItemStack item) {
        Inventory inv = ((InventoryHolder)location.getBlock().getState()).getInventory();
        int count = 0;
        for (ItemStack i : inv.getContents()) {
            if (i == null || !i.isSimilar(item)) continue;
            count += i.getAmount();
        }
        return count;
    }

    private Player getNearestPlayer(Player player) {
        for (Player otherPlayer : player.getWorld().getPlayers()) {
            double distance;
            if (otherPlayer.equals((Object)player) || !((distance = otherPlayer.getLocation().distance(player.getLocation())) <= 5.0)) continue;
            return otherPlayer;
        }
        return null;
    }

    private int removeItems(Inventory inv, ItemStack target, int amount) {
        int removed = 0;
        for (int i = 0; i < inv.getSize(); ++i) {
            ItemStack current = inv.getItem(i);
            if (current == null || !current.isSimilar(target)) continue;
            int take = Math.min(current.getAmount(), amount - removed);
            current.setAmount(current.getAmount() - take);
            removed += take;
            if (current.getAmount() <= 0) {
                inv.setItem(i, null);
            }
            if (removed >= amount) break;
        }
        return removed;
    }

    private String formatItemName(ItemStack item) {
        ItemMeta meta = item.getItemMeta();
        if (meta != null && meta.hasDisplayName()) {
            return meta.getDisplayName();
        }
        return item.getType().name().toLowerCase().replace("_", " ");
    }

    public static String toRoman(int number) {
        return switch (number) {
            case 1 -> "I";
            case 2 -> "II";
            case 3 -> "III";
            case 4 -> "IV";
            case 5 -> "V";
            case 6 -> "VI";
            case 7 -> "VII";
            case 8 -> "VIII";
            case 9 -> "IX";
            case 10 -> "X";
            default -> Integer.toString(number);
        };
    }

    public final int getAddableAmount(Player player, ItemStack item) {
        int maxStackSize = item.getMaxStackSize();
        int addable = 0;
        for (int i = 0; i < 36; ++i) {
            ItemStack invItem = player.getInventory().getItem(i);
            if (invItem == null || invItem.getType() == Material.AIR) {
                addable += maxStackSize;
                continue;
            }
            if (!invItem.isSimilar(item)) continue;
            addable += maxStackSize - invItem.getAmount();
        }
        return addable;
    }
}

