/*
 * Decompiled with CFR 0.152.
 */
package de.flipper1406.futureleague_wirtschaft;

import de.flipper1406.futureleague_wirtschaft.ConfigManager.ConfigFileConfig;
import de.flipper1406.futureleague_wirtschaft.ConfigManager.ConfigFileExp;
import de.flipper1406.futureleague_wirtschaft.ConfigManager.ConfigFileMessages;
import de.flipper1406.futureleague_wirtschaft.ConfigManager.ConfigManager;
import de.flipper1406.futureleague_wirtschaft.Events.JoinEvents;
import de.flipper1406.futureleague_wirtschaft.FutureLeagueWirtschaft;
import de.flipper1406.futureleague_wirtschaft.Studium.StudiumCommands;
import de.flipper1406.futureleague_wirtschaft.Userdata.Utils.UserDataManager;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class FLAPI {
    private final Location spawnLocation = new Location(Bukkit.getWorld((String)"city"), 409.0, 113.0, -858.0);
    private final double blockCenter = 0.5;
    private final int basisExp = 200;
    private final int expMultiplier = 50;
    private final double percentFactor = 100.0;
    private final int decimalBase = 10;
    private final int nextStep = 10;
    private final int secondsPerMinute = 60;
    private final int ticksPerSecond = 20;
    private final int luckLevel = 2;
    private final int standardLevel = 1;
    private final int randomMin = 1;
    private final int randomMax = 100;
    private final int baseChance = 10;
    private final int maxChance = 50;
    private final float soundVolume = 10.0f;
    private final float soundPitch = 1.0f;
    private final Sound lootSound = Sound.BLOCK_BUBBLE_COLUMN_BUBBLE_POP;
    private static final int DEFAULT_JOB_LEVEL = 0;
    private final int particleCount = 10;
    private FutureLeagueWirtschaft plugin;
    private final ConfigManager configManager;
    private final ConfigFileExp configFileExp;
    private final ConfigFileMessages configFileMessages;
    private final ConfigFileConfig configFileConfig;
    private final StudiumCommands studiumCommands;
    private final JoinEvents joinEvents;
    private String pattern = "dd-MM-yyyy";
    private SimpleDateFormat simpleDateFormat = new SimpleDateFormat(this.pattern);
    private String date = this.simpleDateFormat.format(new Date());
    private final int levelnummer = 12;
    private final String currency = " Euro";

    public FLAPI(FutureLeagueWirtschaft wirtschaftsPlugin) {
        this.plugin = wirtschaftsPlugin;
        this.configManager = wirtschaftsPlugin.getConfigManager();
        this.configFileExp = wirtschaftsPlugin.getConfigFileExp();
        this.configFileMessages = wirtschaftsPlugin.getConfigFileMessages();
        this.configFileConfig = wirtschaftsPlugin.getConfigFileConfig();
        this.studiumCommands = wirtschaftsPlugin.getStudiumCommands();
        this.joinEvents = wirtschaftsPlugin.getJoinEvents();
    }

    private void message(Player p, String message) {
        this.sendPrefixMessage(p, this.configFileMessages.getValue("title"));
        p.sendMessage(" " + message);
        this.sendSuffixMessage(p);
    }

    public void sendMessage(Player p, String messageID) {
        this.message(p, this.configFileMessages.getValue(messageID));
    }

    public double rint(double value, int decimalPoints) {
        double d = Math.pow(10.0, decimalPoints);
        return Math.rint(value * d) / d;
    }

    public int getMax(double a, double b) {
        return (int)Math.max(a, b);
    }

    public int getMin(double a, double b) {
        return (int)Math.min(a, b);
    }

    public void sendMessage(Player p, String infoString, String messageID) {
        String message = this.configFileMessages.getValue(messageID + "_1") + " " + infoString + " " + this.configFileMessages.getValue(messageID + "_2");
        this.message(p, message);
    }

    public void sendMessage(Player receiverPlayer, Player senderPlayer, String infoString, String messageID) {
        String message = this.configFileMessages.getValue(messageID + "_1") + " " + senderPlayer.getName() + " " + this.configFileMessages.getValue(messageID + "_2") + " " + infoString + " " + this.configFileMessages.getValue(messageID + "_3");
        this.message(receiverPlayer, message);
    }

    public ItemStack getRewardItem(String jobName, Player p) {
        ItemStack item = new ItemStack(Material.AIR);
        if (jobName.equalsIgnoreCase("F\u00f6rster")) {
            item = new ItemStack(Material.GOLDEN_AXE);
            ItemMeta meta = item.getItemMeta();
            meta.setDisplayName("\u00a7a" + p.getName() + "`s \u00a76Goldene Holzf\u00e4ller-Axt");
            ArrayList<Object> loresList = new ArrayList<Object>();
            loresList.add("\u00a7eGeschmiedet aus hochwertigsten Materialen");
            loresList.add("\u00a7eErhalten am: \u00a76" + this.date);
            meta.setLore(loresList);
            item.setItemMeta(meta);
        } else if (jobName.equalsIgnoreCase("Landwirt")) {
            item = new ItemStack(Material.GOLDEN_APPLE);
            ItemMeta meta = item.getItemMeta();
            meta.setDisplayName("\u00a7a" + p.getName() + "`s \u00a76Goldener Apfel");
            ArrayList<Object> loresList = new ArrayList<Object>();
            loresList.add("\u00a7eEin Apfel kombiniert mit dem besten Gold");
            loresList.add("\u00a7eErhalten am: \u00a76" + this.date);
            meta.setLore(loresList);
            item.setItemMeta(meta);
        } else if (jobName.equalsIgnoreCase("Angler")) {
            item = new ItemStack(Material.TROPICAL_FISH);
            ItemMeta meta = item.getItemMeta();
            meta.setDisplayName("\u00a7a" + p.getName() + "`s \u00a76Goldener Fang");
            ArrayList<Object> loresList = new ArrayList<Object>();
            loresList.add("\u00a7eEin hochwertiger Fisch!");
            loresList.add("\u00a7eGefangen am: \u00a76" + this.date);
            meta.setLore(loresList);
            item.setItemMeta(meta);
        } else if (jobName.equalsIgnoreCase("Minenarbeiter")) {
            item = new ItemStack(Material.GOLDEN_PICKAXE);
            ItemMeta meta = item.getItemMeta();
            meta.setDisplayName("\u00a7a" + p.getName() + "`s \u00a76Goldene Spitzhacke");
            ArrayList<Object> loresList = new ArrayList<Object>();
            loresList.add("\u00a7eEin Werkzeug aus purem Gold");
            loresList.add("\u00a7eGeschmiedet am: \u00a76" + this.date);
            meta.setLore(loresList);
            item.setItemMeta(meta);
        } else if (jobName.equalsIgnoreCase("Feuerwehr")) {
            item = new ItemStack(Material.AXOLOTL_BUCKET);
            ItemMeta meta = item.getItemMeta();
            meta.setDisplayName("\u00a7a" + p.getName() + "`s \u00a76Lebensretter");
            ArrayList<Object> loresList = new ArrayList<Object>();
            loresList.add("\u00a7eNanu, wer hat sich denn da versteckt?");
            loresList.add("\u00a7eErhalten am: \u00a76" + this.date);
            meta.setLore(loresList);
            item.setItemMeta(meta);
        } else if (jobName.equalsIgnoreCase("Putzdienst")) {
            item = new ItemStack(Material.BRUSH);
            ItemMeta meta = item.getItemMeta();
            meta.setDisplayName("\u00a7a" + p.getName() + "`s \u00a76Putzbesen");
            ArrayList<Object> loresList = new ArrayList<Object>();
            loresList.add("\u00a7eHier ist nichts mehr schmutzig!");
            loresList.add("\u00a7eErhalten am: \u00a76" + this.date);
            meta.setLore(loresList);
            item.setItemMeta(meta);
        } else if (jobName.equalsIgnoreCase("K\u00e4mpfer")) {
            item = new ItemStack(Material.GOLDEN_SWORD);
            ItemMeta meta = item.getItemMeta();
            meta.setDisplayName("\u00a7a" + p.getName() + "`s \u00a76Goldene Meisterklinge");
            ArrayList<Object> loresList = new ArrayList<Object>();
            loresList.add("\u00a7eAn mir kommt keiner vorbei!");
            loresList.add("\u00a7eErhalten am: \u00a76" + this.date);
            meta.setLore(loresList);
            item.setItemMeta(meta);
        } else if (jobName.equalsIgnoreCase("Florist")) {
            item = new ItemStack(Material.FLOWER_POT);
            ItemMeta meta = item.getItemMeta();
            meta.setDisplayName("\u00a7a" + p.getName() + "`s \u00a76Goldener Blumentopf");
            ArrayList<Object> loresList = new ArrayList<Object>();
            loresList.add("\u00a7eBlumen bl\u00fchen in vielen bunten Farben!");
            loresList.add("\u00a7eErhalten am: \u00a76" + this.date);
            meta.setLore(loresList);
            item.setItemMeta(meta);
        } else if (jobName.equalsIgnoreCase("Rettungsdienst")) {
            item = new ItemStack(Material.SPLASH_POTION);
            ItemMeta meta = item.getItemMeta();
            meta.setDisplayName("\u00a7a" + p.getName() + "`s \u00a76Meistertrank");
            ArrayList<Object> loresList = new ArrayList<Object>();
            loresList.add("\u00a7eEs gibt keine Wunde, welche nicht verheilen kann!");
            loresList.add("\u00a7eErhalten am: \u00a76" + this.date);
            meta.setLore(loresList);
            item.setItemMeta(meta);
        } else if (jobName.equalsIgnoreCase("Gastronom")) {
            item = new ItemStack(Material.PUMPKIN_PIE);
            ItemMeta meta = item.getItemMeta();
            meta.setDisplayName("\u00a7a" + p.getName() + "`s \u00a76Goldener Gaumen");
            ArrayList<Object> loresList = new ArrayList<Object>();
            loresList.add("\u00a7eEs gibt Kuchen!");
            loresList.add("\u00a7eGebacken am: \u00a76" + this.date);
            meta.setLore(loresList);
            item.setItemMeta(meta);
        }
        return item;
    }

    public Integer getJobLevel(Player p) {
        String currentJob = this.configManager.getValue(p.getName(), "currentJob");
        String action = "job_" + currentJob + "_Level";
        return this.configManager.getValue(p.getName(), action, 0);
    }

    public Integer getJobEXP(Player p) {
        String currentJob = this.configManager.getValue(p.getName(), "currentJob");
        String action = "job_" + currentJob + "_EXP";
        return this.configManager.getValue(p.getName(), action, 0);
    }

    public void placeBlocksInArea(Location loc1, Location loc2, Material mat) {
        int zMin;
        int zMax;
        int yMin;
        int yMax;
        int xMin;
        int xMax;
        String worldName = loc1.getWorld().getName();
        World world = loc1.getWorld();
        if (loc1.getWorld() != loc2.getWorld()) {
            Bukkit.getConsoleSender().sendMessage("[FutureLeague_Wirtschaft] -$4DEBUG: $cFunktion placeBlocksInArea in JobCommands fehlgeschlagen - Verschiedene Welten angegeben!");
            return;
        }
        if (loc1.getX() > loc2.getX()) {
            xMax = (int)loc1.getX();
            xMin = (int)loc2.getX();
        } else {
            xMax = (int)loc2.getX();
            xMin = (int)loc1.getX();
        }
        if (loc1.getY() > loc2.getY()) {
            yMax = (int)loc1.getY();
            yMin = (int)loc2.getY();
        } else {
            yMax = (int)loc2.getY();
            yMin = (int)loc1.getY();
        }
        if (loc1.getZ() > loc2.getZ()) {
            zMax = (int)loc1.getZ();
            zMin = (int)loc2.getZ();
        } else {
            zMax = (int)loc2.getZ();
            zMin = (int)loc1.getZ();
        }
        if (xMin == xMax) {
            --xMin;
        }
        if (yMin == yMax) {
            --yMin;
        }
        if (zMin == zMax) {
            --zMin;
        }
        for (int x = xMax; x >= xMin; --x) {
            for (int z = zMax; z >= zMin; --z) {
                for (int y = yMax; y >= yMin; --y) {
                    Bukkit.getConsoleSender().sendMessage("X: " + x + " | Y: " + y + " | Z: " + z);
                    world.getBlockAt(new Location(Bukkit.getWorld((String)worldName), (double)x, (double)y, (double)z)).setType(mat);
                }
            }
        }
    }

    public void spawnParticleInArea(Location loc1, Location loc2) {
        int zMin;
        int zMax;
        int yMin;
        int yMax;
        int xMin;
        int xMax;
        String worldName = loc1.getWorld().getName();
        World world = loc1.getWorld();
        if (loc1.getWorld() != loc2.getWorld()) {
            Bukkit.getConsoleSender().sendMessage("[FutureLeague_Wirtschaft] -$4DEBUG: $cFunktion placeBlocksInArea in FLAPI fehlgeschlagen - Verschiedene Welten angegeben!");
            return;
        }
        if (loc1.getX() > loc2.getX()) {
            xMax = (int)loc1.getX();
            xMin = (int)loc2.getX();
        } else {
            xMax = (int)loc2.getX();
            xMin = (int)loc1.getX();
        }
        if (loc1.getY() > loc2.getY()) {
            yMax = (int)loc1.getY();
            yMin = (int)loc2.getY();
        } else {
            yMax = (int)loc2.getY();
            yMin = (int)loc1.getY();
        }
        if (loc1.getZ() > loc2.getZ()) {
            zMax = (int)loc1.getZ();
            zMin = (int)loc2.getZ();
        } else {
            zMax = (int)loc2.getZ();
            zMin = (int)loc1.getZ();
        }
        if (xMin == xMax) {
            --xMin;
        }
        if (yMin == yMax) {
            --yMin;
        }
        if (zMin == zMax) {
            --zMin;
        }
        for (int x = xMax; x >= xMin; --x) {
            for (int z = zMax; z >= zMin; --z) {
                for (int y = yMax; y >= yMin; --y) {
                    world.spawnParticle(Particle.EXPLOSION, new Location(Bukkit.getWorld((String)worldName), (double)(-x), (double)y, (double)(-z)), 10);
                }
            }
        }
    }

    public boolean playerGetsMoreLoot(Player p, String jobName) {
        int chance = 10;
        int range = 100;
        int rand = (int)(Math.random() * (double)range) + 1;
        int lvl = this.configManager.getValue(p.getName(), "job_" + jobName + "_Level", 0);
        if ((chance += lvl) > 50) {
            chance = 50;
        }
        if (rand < chance) {
            p.playSound(p.getLocation(), this.lootSound, 10.0f, 1.0f);
            return true;
        }
        return false;
    }

    public void grantEffectToPlayer(Player p, String effect, int duration, int amplifier) {
        switch (effect) {
            case "ABSORPTION": {
                p.addPotionEffect(new PotionEffect(PotionEffectType.ABSORPTION, duration, amplifier));
                break;
            }
            case "BAD_OMEN": {
                p.addPotionEffect(new PotionEffect(PotionEffectType.BAD_OMEN, duration, amplifier));
                break;
            }
            case "BLINDNESS": {
                p.addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, duration, amplifier));
                break;
            }
            case "CONDUIT_POWER": {
                p.addPotionEffect(new PotionEffect(PotionEffectType.CONDUIT_POWER, duration, amplifier));
                break;
            }
            case "DARKNESS": {
                p.addPotionEffect(new PotionEffect(PotionEffectType.DARKNESS, duration, amplifier));
                break;
            }
            case "DOLPHINS_GRACE": {
                p.addPotionEffect(new PotionEffect(PotionEffectType.DOLPHINS_GRACE, duration, amplifier));
                break;
            }
            case "FIRE_RESISTANCE": {
                p.addPotionEffect(new PotionEffect(PotionEffectType.FIRE_RESISTANCE, duration, amplifier));
                break;
            }
            case "GLOWING": {
                p.addPotionEffect(new PotionEffect(PotionEffectType.GLOWING, duration, amplifier));
                break;
            }
            case "HASTE": {
                p.addPotionEffect(new PotionEffect(PotionEffectType.HASTE, duration, amplifier));
                break;
            }
            case "HEALTH_BOOST": {
                p.addPotionEffect(new PotionEffect(PotionEffectType.HEALTH_BOOST, duration, amplifier));
                break;
            }
            case "HERO_OF_THE_VILLAGE": {
                p.addPotionEffect(new PotionEffect(PotionEffectType.HERO_OF_THE_VILLAGE, duration, amplifier));
                break;
            }
            case "HUNGER": {
                p.addPotionEffect(new PotionEffect(PotionEffectType.HUNGER, duration, amplifier));
                break;
            }
            case "INSTANT_DAMAGE": {
                p.addPotionEffect(new PotionEffect(PotionEffectType.INSTANT_DAMAGE, duration, amplifier));
                break;
            }
            case "INSTANT_HEALTH": {
                p.addPotionEffect(new PotionEffect(PotionEffectType.INSTANT_HEALTH, duration, amplifier));
                break;
            }
            case "INVISIBILITY": {
                p.addPotionEffect(new PotionEffect(PotionEffectType.INVISIBILITY, duration, amplifier));
                break;
            }
            case "JUMP_BOOST": {
                p.addPotionEffect(new PotionEffect(PotionEffectType.JUMP_BOOST, duration, amplifier));
                break;
            }
            case "LEVITATION": {
                p.addPotionEffect(new PotionEffect(PotionEffectType.LEVITATION, duration, amplifier));
                break;
            }
            case "LUCK": {
                p.addPotionEffect(new PotionEffect(PotionEffectType.LUCK, duration, amplifier));
                break;
            }
            case "MINING_FATIGUE": {
                p.addPotionEffect(new PotionEffect(PotionEffectType.MINING_FATIGUE, duration, amplifier));
                break;
            }
            case "NAUSEA": {
                p.addPotionEffect(new PotionEffect(PotionEffectType.NAUSEA, duration, amplifier));
                break;
            }
            case "NIGHT_VISION": {
                p.addPotionEffect(new PotionEffect(PotionEffectType.NIGHT_VISION, duration, amplifier));
                break;
            }
            case "POISON": {
                p.addPotionEffect(new PotionEffect(PotionEffectType.POISON, duration, amplifier));
                break;
            }
            case "REGENERATION": {
                p.addPotionEffect(new PotionEffect(PotionEffectType.REGENERATION, duration, amplifier));
                break;
            }
            case "RESISTANCE": {
                p.addPotionEffect(new PotionEffect(PotionEffectType.RESISTANCE, duration, amplifier));
                break;
            }
            case "SATURATION": {
                p.addPotionEffect(new PotionEffect(PotionEffectType.SATURATION, duration, amplifier));
                break;
            }
            case "SLOW_FALLING": {
                p.addPotionEffect(new PotionEffect(PotionEffectType.SLOW_FALLING, duration, amplifier));
                break;
            }
            case "SLOWNESS": {
                p.addPotionEffect(new PotionEffect(PotionEffectType.SLOWNESS, duration, amplifier));
                break;
            }
            case "SPEED": {
                p.addPotionEffect(new PotionEffect(PotionEffectType.SPEED, duration, amplifier));
                break;
            }
            case "STRENGTH": {
                p.addPotionEffect(new PotionEffect(PotionEffectType.STRENGTH, duration, amplifier));
                break;
            }
            case "UNLUCK": {
                p.addPotionEffect(new PotionEffect(PotionEffectType.UNLUCK, duration, amplifier));
                break;
            }
            case "WATER_BREATHING": {
                p.addPotionEffect(new PotionEffect(PotionEffectType.WATER_BREATHING, duration, amplifier));
                break;
            }
            case "WEAKNESS": {
                p.addPotionEffect(new PotionEffect(PotionEffectType.WEAKNESS, duration, amplifier));
                break;
            }
            case "WITHER": {
                p.addPotionEffect(new PotionEffect(PotionEffectType.WITHER, duration, amplifier));
                break;
            }
            case "INFESTED": {
                p.addPotionEffect(new PotionEffect(PotionEffectType.INFESTED, duration, amplifier));
                break;
            }
            case "OOZING": {
                p.addPotionEffect(new PotionEffect(PotionEffectType.OOZING, duration, amplifier));
                break;
            }
            case "RAID_OMEN": {
                p.addPotionEffect(new PotionEffect(PotionEffectType.RAID_OMEN, duration, amplifier));
                break;
            }
            case "TRIAL_OMEN": {
                p.addPotionEffect(new PotionEffect(PotionEffectType.TRIAL_OMEN, duration, amplifier));
                break;
            }
            case "WEAVING": {
                p.addPotionEffect(new PotionEffect(PotionEffectType.WEAVING, duration, amplifier));
                break;
            }
            case "WIND_CHARGED": {
                p.addPotionEffect(new PotionEffect(PotionEffectType.WIND_CHARGED, duration, amplifier));
                break;
            }
            default: {
                Bukkit.getConsoleSender().sendMessage("[FutureLeague_Wirtschaft] \u00a7cUnbekannter PotionEffect: " + effect);
            }
        }
    }

    private void grantLevelUpBonus(Player p, String jobName) {
        int standardDuration = 1200 * this.configFileConfig.getIntValue("standardEffectDuration");
        String pvpWorld = this.configFileConfig.getStringValue("pvpWorld");
        if (p.getWorld() == Bukkit.getWorld((String)pvpWorld)) {
            return;
        }
        switch (jobName) {
            case "Angler": {
                this.grantEffectToPlayer(p, "LUCK", standardDuration, 2);
                this.grantEffectToPlayer(p, "WATER_BREATHING", standardDuration, 1);
                this.grantEffectToPlayer(p, "SPEED", standardDuration, 1);
                break;
            }
            case "F\u00f6rster": {
                this.grantEffectToPlayer(p, "LUCK", standardDuration, 2);
                this.grantEffectToPlayer(p, "HASTE", standardDuration, 1);
                this.grantEffectToPlayer(p, "SPEED", standardDuration, 1);
                break;
            }
            case "Minenarbeiter": {
                this.grantEffectToPlayer(p, "LUCK", standardDuration, 2);
                this.grantEffectToPlayer(p, "HASTE", standardDuration, 1);
                this.grantEffectToPlayer(p, "RESISTANCE", standardDuration, 1);
                this.grantEffectToPlayer(p, "SPEED", standardDuration, 1);
                break;
            }
            case "K\u00e4mpfer": {
                this.grantEffectToPlayer(p, "RESISTANCE", standardDuration, 1);
                this.grantEffectToPlayer(p, "SPEED", standardDuration, 1);
                break;
            }
            case "Landwirt": {
                this.grantEffectToPlayer(p, "LUCK", standardDuration, 2);
                this.grantEffectToPlayer(p, "SPEED", standardDuration, 1);
                break;
            }
            default: {
                this.grantEffectToPlayer(p, "SPEED", standardDuration, 1);
            }
        }
    }

    public void raiseEXP(Player p, int additionalExp, String jobName) {
        String action = "job_" + jobName + "_";
        int oldLvl = this.configManager.getValue(p.getName(), action + "Level", 0);
        int oldExp = this.configManager.getValue(p.getName(), action + "EXP", 0);
        int newExp = oldExp + additionalExp;
        int newLvl = 0;
        this.configManager.setValue(p.getName(), action + "EXP", newExp);
        int aktuellesLevel = this.getJobLevel(p);
        int aktuellesEXP = this.getJobEXP(p);
        List<Integer> levels = this.configFileExp.getLevelSteps();
        int nextEXP = levels.get(aktuellesLevel);
        double percentage = (double)aktuellesEXP / (double)nextEXP * 100.0;
        percentage = this.rint(percentage, 2);
        String message = "\u00a79" + jobName + " \u00a7l>>\u00a7r\u00a72 " + percentage + "% \u00a7azum n\u00e4chsten Level | Aktueles Level: " + aktuellesLevel + " | N\u00e4chstes Level: " + (aktuellesLevel + 1);
        p.sendActionBar((Component)Component.text((String)message));
        if (additionalExp > 0) {
            List<Integer> levelSteps = this.configFileExp.getLevelSteps();
            for (Integer levelStep : levelSteps) {
                if (newExp < levelStep) continue;
                ++newLvl;
            }
            if (oldLvl < newLvl) {
                double amountAdded = 200 + newLvl * 50;
                double amount = UserDataManager.getBalance(p.getUniqueId()) + amountAdded;
                String reason = "Level-UP Belohnung: " + jobName;
                if (!this.configManager.getValue(p.getName(), "dekofigur", true)) {
                    this.configManager.setValue(p.getName(), "dekofigur", true);
                    String cmd = "deko_figur_first_join " + p.getName() + " " + p.getName();
                    Bukkit.getServer().dispatchCommand((CommandSender)Bukkit.getServer().getConsoleSender(), cmd);
                }
                this.sendPrefixMessage(p, "Job-System");
                p.sendMessage(" \u00a72<>\u00a7a Du bist bei deinem aktuellen Job ein Level aufgestiegen!");
                p.sendMessage(" \u00a72<>\u00a7a Du bist nun im Level \u00a7e" + newLvl);
                p.sendMessage(" \u00a72<>\u00a7a Dir wurde eine Belohnung in H\u00f6he von \u00a7e" + amountAdded + "  Euro\u00a7a \u00dcberwiesen.");
                this.sendSuffixMessage(p);
                UserDataManager.setBalance(p.getUniqueId(), amount);
                UserDataManager.logTransaction(p.getUniqueId(), null, amountAdded, reason);
                this.grantLevelUpBonus(p, jobName);
                p.playSound(p.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 10.0f, 1.0f);
                if (newLvl == 12) {
                    this.sendPrefixMessage(p, "Job-System");
                    p.sendMessage(" \u00a7cDu hast mit Erreichen des 12ten Levels eine einzigartige Belohnung freigeschaltet! Hol dir deine Belohnung mit /jobs belohnung ab.");
                    p.sendMessage(" \u00a7cBitte achte darauf, mindestens einen freien Slot im Inventar zu haben.");
                    this.sendSuffixMessage(p);
                    this.configManager.setRewards(p, jobName, true);
                }
                this.configManager.setValue(p.getName(), "job_" + jobName + "_Level", newLvl);
            }
        }
    }

    public void sendPrefixMessage(Player p, String title) {
        p.sendMessage(" \u00a72<>\u00a7a----------\u00a72<\u00a76" + title + "\u00a72>\u00a7a----------\u00a72<>");
        p.sendMessage(" ");
    }

    public void sendSuffixMessage(Player p) {
        p.sendMessage(" \u00a72<>\u00a7a-------------------------------\u00a72<>");
    }

    public ItemStack getItemForJobInventory(ItemStack item, String name, String ... lore) {
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(name);
        ArrayList<String> lores = new ArrayList<String>();
        for (String s : lore) {
            lores.add(s);
        }
        meta.setLore(lores);
        item.setItemMeta(meta);
        return item;
    }

    public void sendModeratorMessage(String message) {
        List<String> players = this.configManager.getPlayers();
        Bukkit.getLogger().info("Players in config: " + String.valueOf(players));
        for (String player : players) {
            if (!this.configManager.getValue(player, "moderatorModus", true)) continue;
            Player p = Bukkit.getPlayerExact((String)player);
            if (p != null && p.isOnline()) {
                p.sendMessage(message);
                continue;
            }
            Bukkit.getLogger().info(player + " nicht gefunden oder offline");
        }
    }

    public Location getWorldSpawn(String world) {
        if (Bukkit.getWorld((String)world) != null) {
            return Bukkit.getWorld((String)world).getSpawnLocation();
        }
        return null;
    }

    public Location getHighestSaveLocation(Location loc) {
        Location newLoc = this.getHighestBlockLocation(loc);
        newLoc.setY(newLoc.getY() + 1.0);
        World world = newLoc.getWorld();
        if (world == null) {
            return null;
        }
        int radius = 2;
        int centerX = newLoc.getBlockX();
        int centerY = newLoc.getBlockY();
        int centerZ = newLoc.getBlockZ();
        for (int x = centerX - radius; x <= centerX + radius; ++x) {
            for (int y = centerY - radius; y <= centerY + radius; ++y) {
                for (int z = centerZ - radius; z <= centerZ + radius; ++z) {
                    Block block = world.getBlockAt(x, y, z);
                    Material type = block.getType();
                    if (type != Material.LAVA && type != Material.LAVA_CAULDRON && type != Material.WATER && type != Material.WATER_CAULDRON && type != Material.MAGMA_BLOCK && type != Material.CAMPFIRE && type != Material.SOUL_CAMPFIRE && type != Material.TNT && type != Material.POWDER_SNOW && type != Material.SNOW) continue;
                    return this.getHighestSaveLocation(new Location(world, (double)(centerX + 10), (double)centerY, (double)(centerZ + 10)));
                }
            }
        }
        return newLoc;
    }

    public Location getHighestBlockLocation(Location loc) {
        World world = loc.getWorld();
        if (world == null) {
            return null;
        }
        int x = loc.getBlockX();
        int z = loc.getBlockZ();
        int y = world.getHighestBlockYAt(x, z);
        return new Location(world, (double)x + 0.5, (double)y, (double)z + 0.5);
    }

    public Location getCitySpawnLocation() {
        return this.spawnLocation;
    }
}

