/*
 * Decompiled with CFR 0.152.
 */
package de.flipper1406.futureleague_wirtschaft.Permissions;

import de.flipper1406.futureleague_wirtschaft.Permissions.DatabaseManager;
import de.flipper1406.futureleague_wirtschaft.Permissions.PermissionManager;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.plugin.java.JavaPlugin;

public class ChatListener
implements Listener {
    private final PermissionManager permManager;
    private final JavaPlugin plugin;
    private final DatabaseManager databaseManager;
    private final String serverName;

    public ChatListener(JavaPlugin wirtschaftsPlugin, PermissionManager permissionManager, DatabaseManager dbManager) {
        this.plugin = wirtschaftsPlugin;
        this.permManager = permissionManager;
        this.databaseManager = dbManager;
        this.serverName = wirtschaftsPlugin.getConfig().getString("server-name", "unknown");
    }

    @EventHandler
    public void onChat(AsyncPlayerChatEvent event) {
        Player player = event.getPlayer();
        String prefix = this.permManager.getPrefix(player.getUniqueId().toString());
        String finalMessage = prefix + " " + player.getName() + " \u00a74>> \u00a72" + event.getMessage();
        event.setCancelled(true);
        this.broadcastMessage(finalMessage);
        String configServerName = this.plugin.getConfig().getString("server-name", "unknown");
        this.databaseManager.logChat(player.getUniqueId(), event.getMessage(), configServerName);
        boolean logChatToConsole = this.plugin.getConfig().getBoolean("chat-in-console", true);
        if (logChatToConsole) {
            Bukkit.getConsoleSender().sendMessage(finalMessage);
        }
    }

    public void broadcastMessage(String message) {
        for (Player player : Bukkit.getOnlinePlayers()) {
            player.sendMessage(message);
        }
    }
}

