/*
 * Decompiled with CFR 0.152.
 */
package de.flipper1406.futureleague_wirtschaft.Permissions;

import de.flipper1406.futureleague_wirtschaft.FutureLeagueWirtschaft;
import de.flipper1406.futureleague_wirtschaft.Permissions.DatabaseManager;
import de.flipper1406.futureleague_wirtschaft.Permissions.PermissionCache;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionAttachment;
import org.bukkit.plugin.Plugin;

public class PermissionListener
implements Listener {
    private final PermissionCache cache;
    private final Map<UUID, PermissionAttachment> attachments = new HashMap<UUID, PermissionAttachment>();
    private final FutureLeagueWirtschaft plugin;
    private final DatabaseManager db;
    private final int firstParameterIndex = 1;
    private final int seccondParameterIndex = 2;
    private final int thirdParameterIndex = 3;

    public PermissionListener(PermissionCache permissionCache) {
        this.cache = permissionCache;
        this.plugin = FutureLeagueWirtschaft.getInstance();
        this.db = this.plugin.getDatabaseManager();
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        UUID uuid = player.getUniqueId();
        String server = this.plugin.getConfig().getString("server-name", "unknown");
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            block22: {
                try (Connection conn = this.db.getConnection();){
                    boolean exists = false;
                    try (PreparedStatement ps = conn.prepareStatement("SELECT COUNT(*) FROM players WHERE uuid = ?");){
                        ps.setString(1, uuid.toString());
                        ResultSet rs = ps.executeQuery();
                        if (rs.next() && rs.getInt(1) > 0) {
                            exists = true;
                        }
                    }
                    if (exists) break block22;
                    try (PreparedStatement insert = conn.prepareStatement("INSERT INTO players (uuid, name, rank) VALUES (?, ?, ?)");){
                        insert.setString(1, uuid.toString());
                        insert.setString(2, player.getName());
                        insert.setString(3, "default");
                        insert.executeUpdate();
                        this.plugin.getLogger().info("Spieler " + player.getName() + " wurde in DB angelegt.");
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            this.cache.load(uuid, server);
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                PermissionAttachment attachment = player.addAttachment((Plugin)this.plugin);
                this.attachments.put(uuid, attachment);
                this.cache.getPermissions(uuid, server).forEach(perm -> {
                    if (perm.equals("*")) {
                        for (Permission bukkitPerm : Bukkit.getPluginManager().getPermissions()) {
                            attachment.setPermission(bukkitPerm.getName(), true);
                        }
                    } else if (perm.endsWith(".*")) {
                        String prefix = perm.substring(0, perm.length() - 2);
                        for (Permission bukkitPerm : Bukkit.getPluginManager().getPermissions()) {
                            if (!bukkitPerm.getName().startsWith(prefix)) continue;
                            attachment.setPermission(bukkitPerm.getName(), true);
                        }
                    } else {
                        attachment.setPermission(perm, true);
                    }
                });
            });
        });
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent event) {
        UUID uuid = event.getPlayer().getUniqueId();
        PermissionAttachment attachment = this.attachments.remove(uuid);
        if (attachment != null) {
            attachment.remove();
        }
        this.cache.clear(uuid);
    }
}

