/*
 * Decompiled with CFR 0.152.
 */
package de.flipper1406.futureleague_wirtschaft.Studium;

import de.flipper1406.futureleague_wirtschaft.ConfigManager.ConfigManager;
import de.flipper1406.futureleague_wirtschaft.FLAPI;
import de.flipper1406.futureleague_wirtschaft.FutureLeagueWirtschaft;
import de.flipper1406.futureleague_wirtschaft.Userdata.Utils.UserDataManager;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;

public class StudiumCommands
implements Listener,
CommandExecutor {
    private final FutureLeagueWirtschaft plugin;
    private static final int LECTURE_START_DELAY_TICKS = 20;
    private static final int LECTURE_MESSAGE_DELAY_SECONDS = 5;
    private static final int TICKS_PER_SECOND = 20;
    private static final int INFO_MESSAGE_DELAY_SECONDS = 4;
    private static final int ARGS_LENGTH_2 = 2;
    private static final int ARGS_LENGTH_3 = 3;
    private static final int STUDIUM_GUI_SIZE = 9;
    private static final int SLOT_GEOLOGIE = 2;
    private static final int SLOT_LANDWIRTSCHAFT = 4;
    private static final int SLOT_LUFT_UND_RAUMFAHRT = 6;
    private static final String STUDIUM_GUI_TITLE = "\u00a76Studiengang ausw\u00e4hlen";
    private final ConfigManager configManager;
    private static final long STUDIUM_GUI_DELAY_TICKS = 40L;
    private final FLAPI flapi;
    private final String guiTitle = "Studiengang";
    private final int minLevel = 6;
    private String group;
    private boolean vorlesungFinished = false;
    private final double kostenLuftUndRaumfahrt = 1000.0;
    private final double kostenGeologie = 500.0;
    private final double kostenLandwirtschaft = 500.0;
    private final String currency = "Euro";

    public StudiumCommands(FutureLeagueWirtschaft wirtschaftsPlugin) {
        this.plugin = wirtschaftsPlugin;
        this.configManager = wirtschaftsPlugin.getConfigManager();
        this.flapi = wirtschaftsPlugin.getflapi();
    }

    public boolean onCommand(@NotNull CommandSender sender, Command cmd, @NotNull String label, String[] args) {
        String commandName = cmd.getName().toLowerCase();
        if (args.length == 0 && commandName.equalsIgnoreCase("studium")) {
            if (!(sender instanceof Player)) {
                Bukkit.getConsoleSender().sendMessage("Bitte nutze folgenden Aufbau: /studium startmodule <Spielername> <Modulname>");
            } else {
                Player p = (Player)sender;
                if (sender.hasPermission("studium")) {
                    sender.sendMessage("Bitte nutze folgenden Aufbau: /studium startmodule <Spielername> <Modulname>");
                }
            }
            return true;
        }
        if (!(sender instanceof Player)) {
            if (commandName.equalsIgnoreCase("studium")) {
                this.handleStudium(args);
            }
        } else {
            Player p = (Player)sender;
            if (commandName.equalsIgnoreCase("studium") && sender.hasPermission("fl.studium")) {
                this.handleStudium(args);
            }
        }
        return true;
    }

    public void cancelVorlesung(String player) {
        this.configManager.setValue(player, "vorlesungAktiv", false);
    }

    public void handleStudium(String[] args) {
        if (args.length == 0) {
            return;
        }
        switch (args[0].toLowerCase()) {
            case "startmodule": {
                if (args.length != 3) break;
                this.handleStartModule(args[1], args[2]);
                break;
            }
            case "startstudiengang": {
                if (args.length != 3) break;
                this.handleStartStudiengang(args[1], args[2]);
                break;
            }
            case "selectstudiengang": {
                if (args.length != 2) break;
                this.handleSelectStudiengang(args[1]);
                break;
            }
            case "cancel": {
                if (args.length != 2) break;
                this.cancelVorlesung(args[1]);
                break;
            }
            case "information": {
                Player player;
                if (args.length < 2 || (player = Bukkit.getPlayer((String)args[1])) == null) break;
                this.sendInfoToUser(player);
                break;
            }
            case "cancelvorlesung": {
                if (args.length != 3) break;
                this.cancelVorlesungAbschluss(args[1], args[2]);
                break;
            }
            default: {
                Bukkit.getConsoleSender().sendMessage("\u00a7c[Studium] Unbekannter Unterbefehl: " + args[0]);
            }
        }
    }

    private void handleStartStudiengang(String playerName, String studiengang) {
        if (this.configManager.getValue(playerName, "studiengang_" + studiengang + "_aktiv", true)) {
            Objects.requireNonNull(Bukkit.getPlayerExact((String)playerName)).sendMessage("\u00a76Universit\u00e4tsverwaltung \u00a7c>> \u00a7eDu bist bereits in diesem Studiengang eingeschrieben!");
            return;
        }
        this.configManager.setValue(playerName, "studiengang_" + studiengang + "_aktiv", true);
        switch (studiengang) {
            case "luftundraumfahrt": {
                this.initStudiengangLuftUndRaumfahrt(playerName);
                break;
            }
            case "geologie": {
                this.initStudiengangGeologie(playerName);
                break;
            }
            case "landwirtschaft": {
                this.initStudiengangLandwirtschaft(playerName);
                break;
            }
            default: {
                Bukkit.getConsoleSender().sendMessage("Unbekannter Studiengang: " + studiengang);
            }
        }
        Objects.requireNonNull(Bukkit.getPlayerExact((String)playerName)).sendMessage("\u00a76Universit\u00e4tsverwaltung \u00a7c>> \u00a7eDu wurdest erfolgreich im Studiengang \u00a76" + studiengang + " \u00a7eeingeschrieben!");
    }

    private void initStudiengangLuftUndRaumfahrt(String playerName) {
        this.configManager.setValue(playerName, "vorlesungAbgeschlossen_raketenaufbau", false);
        this.configManager.setValue(playerName, "vorlesungAbgeschlossen_luftfahrt", false);
        this.configManager.setValue(playerName, "vorlesungAbgeschlossen_sonnensystem", false);
    }

    private void initStudiengangGeologie(String playerName) {
        this.configManager.setValue(playerName, "vorlesungAbgeschlossen_edelsteine", false);
        this.configManager.setValue(playerName, "vorlesungAbgeschlossen_kristalle", false);
        this.configManager.setValue(playerName, "vorlesungAbgeschlossen_goldsuche", false);
    }

    private void initStudiengangLandwirtschaft(String playerName) {
        this.configManager.setValue(playerName, "vorlesungAbgeschlossen_dreifelderwirtschaft", false);
        this.configManager.setValue(playerName, "vorlesungAbgeschlossen_pflanzunderntezeiten", false);
        this.configManager.setValue(playerName, "vorlesungAbgeschlossen_viehzucht", false);
    }

    public void cancelVorlesungAbschluss(String playerName, String vorlesung) {
        this.configManager.setValue(playerName, "vorlesungAbgeschlossen_" + vorlesung, false);
    }

    private void handleStartModule(String playerName, String moduleName) {
        String module;
        this.group = module = moduleName.toLowerCase();
        Player player = this.getPlayerByString(playerName);
        if (player == null) {
            return;
        }
        if (this.configManager.getValue(playerName, "vorlesungAktiv", true)) {
            player.sendMessage("\u00a7cEs ist bereits eine Vorlesung aktiv. Beende zuerst deine aktuelle Vorlesung!");
            return;
        }
        if (!this.canStartNewVorlesung(playerName)) {
            player.sendMessage("\u00a76Professor \u00a7c>>\u00a7e Du hast heute bereits eine Vorlesung besucht. Du kannst morgen die n\u00e4chste starten!");
            return;
        }
        this.configManager.setValue(playerName, "vorlesungAktiv", true);
        ArrayList<String> messages = new ArrayList<String>();
        messages.add("Herzlich willkommen zur Vorlesung, diese beginnt in wenigen Augenblicken. Bitte nehmen Sie Platz.");
        this.startModuleByName(module, player, messages);
    }

    private boolean canStartNewVorlesung(String playerName) {
        String letzteVorlesung = this.configManager.getValue(playerName, "letzteVorlesung");
        if (letzteVorlesung.equalsIgnoreCase("-")) {
            return true;
        }
        String timestamp = this.configManager.getValue(playerName, "vorlesungAbgeschlossen_timestamp_" + letzteVorlesung);
        if (timestamp == null) {
            return true;
        }
        try {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date lastDate = format.parse(timestamp);
            Calendar calendar = Calendar.getInstance();
            calendar.add(6, -1);
            return lastDate.before(calendar.getTime());
        }
        catch (ParseException e) {
            return true;
        }
    }

    private void startModuleByName(String module, Player player, List<String> messages) {
        switch (module) {
            case "raketenaufbau": {
                this.handleRaketenAufbau(player, messages);
                break;
            }
            case "luftfahrt": {
                this.handleLuftfahrt(player, messages);
                break;
            }
            case "sonnensystem": {
                this.handleSonnensystem(player, messages);
                break;
            }
            case "dreifelderwirtschaft": {
                this.handleDreiFelderWirtschaft(player, messages);
                break;
            }
            case "pflanzunderntezeiten": {
                this.handlePflanzUndErntezeiten(player, messages);
                break;
            }
            case "viehzucht": {
                this.handleViehzucht(player, messages);
                break;
            }
            case "edelsteine": {
                this.handleEdelsteine(player, messages);
                break;
            }
            case "kristalle": {
                this.handleKristalle(player, messages);
                break;
            }
            case "goldsuche": {
                this.handleGoldsuche(player, messages);
                break;
            }
            default: {
                Bukkit.getConsoleSender().sendMessage("\u00a7aUng\u00fcltiges Modul: " + module);
            }
        }
    }

    private void handleSelectStudiengang(String playerName) {
        Player player = Bukkit.getPlayerExact((String)playerName);
        if (player == null) {
            return;
        }
        if (this.configManager.getValue(playerName, "studiengang_geologie_aktiv", true)) {
            this.sendMissingModulesGeologie(player);
            return;
        }
        if (this.configManager.getValue(playerName, "studiengang_landwirtschaft_aktiv", true)) {
            this.sendMissingModulesLandwirtschaft(player);
            return;
        }
        if (this.configManager.getValue(playerName, "studiengang_luftundraumfahrt_aktiv", true)) {
            this.sendMissingModulesLuftUndRaumfahrt(player);
            return;
        }
        player.sendMessage("\u00a76Universit\u00e4tsverwaltung \u00a7c>> \u00a7eBitte w\u00e4hle einen Studiengang.");
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> this.openStudiumGUI(player), 40L);
    }

    private void sendMissingModulesGeologie(Player player) {
        String playerName = player.getName();
        ArrayList<String> module = new ArrayList<String>();
        StringBuilder ausgabe = new StringBuilder();
        if (!this.configManager.getValue(playerName, "vorlesungAbgeschlossen_edelsteine", true)) {
            module.add("Edelsteine");
        }
        if (!this.configManager.getValue(playerName, "vorlesungAbgeschlossen_kristalle", true)) {
            module.add("Kristalle");
        }
        if (!this.configManager.getValue(playerName, "vorlesungAbgeschlossen_goldsuche", true)) {
            module.add("Goldsuche");
        }
        if (module.size() > 1) {
            int index = 1;
            for (String modules : module) {
                if (index == module.size()) {
                    ausgabe.append(modules);
                } else {
                    ausgabe.append(modules).append(", ");
                }
                ++index;
            }
        } else if (module.size() == 1) {
            ausgabe = new StringBuilder((String)module.get(0));
        }
        String ausgabe2 = module.size() == 1 ? "fehlt noch folgendes Modul" : "fehlen noch folgende Module";
        player.sendMessage("\u00a76Universit\u00e4tsverwaltung \u00a7c>> \u00a7eDir " + ausgabe2 + " zum Abschluss des Studiums: " + String.valueOf(ausgabe));
    }

    private void sendMissingModulesLuftUndRaumfahrt(Player player) {
        String playerName = player.getName();
        ArrayList<String> module = new ArrayList<String>();
        Object ausgabe = "";
        if (!this.configManager.getValue(playerName, "vorlesungAbgeschlossen_raketenaufbau", true)) {
            module.add("Raketenaufbau");
        }
        if (!this.configManager.getValue(playerName, "vorlesungAbgeschlossen_luftfahrt", true)) {
            module.add("Luftfahrt");
        }
        if (!this.configManager.getValue(playerName, "vorlesungAbgeschlossen_sonnensystem", true)) {
            module.add("Sonnensystem");
        }
        if (module.size() > 1) {
            int index = 1;
            for (String modules : module) {
                ausgabe = index == module.size() ? (String)ausgabe + modules : (String)ausgabe + modules + ", ";
                ++index;
            }
        } else if (module.size() == 1) {
            ausgabe = (String)module.get(0);
        } else {
            player.sendMessage("\u00a76Universit\u00e4tsverwaltung \u00a7c>> \u00a7eDu hast alle Vorlesungen abgeschlossen. Du kannst nun jederzeit zum Pr\u00fcfer gehen und die Pr\u00fcfung absolvieren! Viel Gl\u00fcck!");
            return;
        }
        String ausgabe2 = module.size() == 1 ? "fehlt noch folgendes Modul" : "fehlen noch folgende Module";
        player.sendMessage("\u00a76Universit\u00e4tsverwaltung \u00a7c>> \u00a7eDir " + ausgabe2 + " zum Abschluss des Studiums: " + (String)ausgabe);
    }

    private void sendMissingModulesLandwirtschaft(Player player) {
        String playerName = player.getName();
        ArrayList<String> module = new ArrayList<String>();
        StringBuilder ausgabe = new StringBuilder();
        if (!this.configManager.getValue(playerName, "vorlesungAbgeschlossen_dreifelderwirtschaft", true)) {
            module.add("Dreifelder-Wirtschaft");
        }
        if (!this.configManager.getValue(playerName, "vorlesungAbgeschlossen_pflanzunderntezeiten", true)) {
            module.add("Pflanz und Erntezeiten");
        }
        if (!this.configManager.getValue(playerName, "vorlesungAbgeschlossen_viehzucht", true)) {
            module.add("Viehzucht");
        }
        if (module.size() > 1) {
            int index = 1;
            for (String modules : module) {
                if (index == module.size()) {
                    ausgabe.append(modules);
                } else {
                    ausgabe.append(modules).append(", ");
                }
                ++index;
            }
        } else if (module.size() == 1) {
            ausgabe = new StringBuilder((String)module.get(0));
        }
        String ausgabe2 = module.size() == 1 ? "fehlt noch folgendes Modul" : "fehlen noch folgende Module";
        player.sendMessage("\u00a76Universit\u00e4tsverwaltung \u00a7c>> \u00a7eDir " + ausgabe2 + " zum Abschluss des Studiums: " + String.valueOf(ausgabe));
    }

    private void openStudiumGUI(Player player) {
        Inventory gui = Bukkit.createInventory(null, (int)9, (String)"Studiengang");
        gui.setItem(2, this.createMenuItem("Geologie"));
        gui.setItem(4, this.createMenuItem("Landwirtschaft"));
        gui.setItem(6, this.createMenuItem("Luft und Raumfahrt"));
        player.openInventory(gui);
    }

    private ItemStack createMenuItem(String name) {
        ItemStack item = new ItemStack(Material.PAPER);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(name);
            item.setItemMeta(meta);
        }
        return item;
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (!event.getView().getTitle().equals("Studiengang")) {
            return;
        }
        event.setCancelled(true);
        HumanEntity humanEntity = event.getWhoClicked();
        if (humanEntity instanceof Player) {
            Player player = (Player)humanEntity;
            ItemStack clickedItem = event.getCurrentItem();
            if (clickedItem != null && clickedItem.getItemMeta() != null) {
                String studyProgram = clickedItem.getItemMeta().getDisplayName().toLowerCase();
                if (studyProgram.equalsIgnoreCase("Luft und Raumfahrt")) {
                    studyProgram = "luftundraumfahrt";
                }
                Bukkit.getServer().dispatchCommand((CommandSender)Bukkit.getConsoleSender(), "studium startStudiengang " + player.getName() + " " + studyProgram);
                player.closeInventory();
            }
        }
    }

    public void handleStartStudiengangLuftUndRaumfahrt(String player) {
        if (this.configManager.getValue(player, "studiengang_geologie_aktiv", true) || this.configManager.getValue(player, "studiengang_landwirtschaft_aktiv", true)) {
            Objects.requireNonNull(Bukkit.getPlayerExact((String)player)).sendMessage("\u00a76Universit\u00e4tsverwaltung \u00a7c>> \u00a7cDu bist bereits in einem anderen Studiengang eingeschrieben. Ich kann dich nicht zu einem weiteren Studiengang einschreiben!");
        } else if (this.configManager.getValue(player, "studiumAbgeschlossen_luftundraumfahrt", true)) {
            Objects.requireNonNull(Bukkit.getPlayerExact((String)player)).sendMessage("\u00a76Universit\u00e4tsverwaltung \u00a7c>> \u00a7cDu hast diesen Studiengang bereits erfolgreich abgeschlossen!");
        } else if (this.configManager.getValue(player, "studiumAbgeschlossen_geologie", true) || this.configManager.getValue(player, "studiumAbgeschlossen_landwirtschaft", true)) {
            if (UserDataManager.getBalance(Objects.requireNonNull(Bukkit.getPlayerExact((String)player)).getUniqueId()) >= 1000.0) {
                this.configManager.setValue(player, "studiengang_luftundraumfahrt_aktiv", true);
                UserDataManager.logTransactionAsSend(Objects.requireNonNull(Bukkit.getPlayerExact((String)player)).getUniqueId(), 1000.0, "Studiengeb\u00fchren des Studiengangs: Luft und Raumfahrt", "FL Universit\u00e4t");
                UserDataManager.removeBalance(Objects.requireNonNull(Bukkit.getPlayerExact((String)player)).getUniqueId(), 1000.0);
                Objects.requireNonNull(Bukkit.getPlayerExact((String)player)).sendMessage("\u00a76Universit\u00e4tsverwaltung \u00a7c>> \u00a7eHerzlichen Gl\u00fcckwunsch, du hast dich erfolgreich f\u00fcr den Studiengang \u00a76Luft und Raumfahrt\u00a7e eingeschrieben!");
            } else {
                Objects.requireNonNull(Bukkit.getPlayerExact((String)player)).sendMessage("\u00a76Universit\u00e4tsverwaltung \u00a7c>> Der Studiengang kostet eine Geb\u00fchr von \u00a741000.0 Euro\u00a7c. Leider kannst du diese zurzeit noch nicht bezahlen.");
            }
        } else {
            Objects.requireNonNull(Bukkit.getPlayerExact((String)player)).sendMessage("\u00a76Universit\u00e4tsverwaltung \u00a7c>> \u00a7eUm diesen Studiengang starten zu k\u00f6nnen, musst du zuvor den Studiengang \u00a76Geologie\u00a7e oder \u00a76Landwirtschaft\u00a7e absolviert haben. Komme wieder, wenn du einen der beiden Studieng\u00e4nge abgeschlossen hast!");
        }
    }

    public void handleStartStudiengangGeologie(String player) {
        if (this.configManager.getValue(player, "studiengang_luftundraumfahrt_aktiv", true) || this.configManager.getValue(player, "studiengang_landwirtschaft_aktiv", true)) {
            Objects.requireNonNull(Bukkit.getPlayerExact((String)player)).sendMessage("\u00a76Universit\u00e4tsverwaltung \u00a7c>> \u00a7cDu bist bereits in einem anderen Studiengang eingeschrieben. Ich kann dich nicht zu einem weiteren Studiengang einschreiben!");
        } else if (this.configManager.getValue(player, "studiumAbgeschlossen_geologie", true)) {
            Objects.requireNonNull(Bukkit.getPlayerExact((String)player)).sendMessage("\u00a76Universit\u00e4tsverwaltung \u00a7c>> \u00a7cDu hast diesen Studiengang bereits erfolgreich abgeschlossen!");
        } else if (this.configManager.getValue(player, "job_Minenarbeiter_Level", 0) >= 6) {
            if (UserDataManager.getBalance(Objects.requireNonNull(Bukkit.getPlayerExact((String)player)).getUniqueId()) >= 500.0) {
                this.configManager.setValue(player, "studiengang_geologie_aktiv", true);
                UserDataManager.logTransactionAsSend(Objects.requireNonNull(Bukkit.getPlayerExact((String)player)).getUniqueId(), 500.0, "Studiengeb\u00fchren des Studiengangs: Geologie", "FL Universit\u00e4t");
                UserDataManager.removeBalance(Objects.requireNonNull(Bukkit.getPlayerExact((String)player)).getUniqueId(), 500.0);
                Objects.requireNonNull(Bukkit.getPlayerExact((String)player)).sendMessage("\u00a76Universit\u00e4tsverwaltung \u00a7c>> \u00a7eHerzlichen Gl\u00fcckwunsch, du hast dich erfolgreich f\u00fcr den Studiengang \u00a76Geologie\u00a7e eingeschrieben!");
            } else {
                Objects.requireNonNull(Bukkit.getPlayerExact((String)player)).sendMessage("\u00a76Universit\u00e4tsverwaltung \u00a7c>> Der Studiengang kostet eine Geb\u00fchr von \u00a74500.0 Euro\u00a7c. Leider kannst du diese zurzeit noch nicht bezahlen.");
            }
        } else {
            Objects.requireNonNull(Bukkit.getPlayerExact((String)player)).sendMessage("\u00a76Universit\u00e4tsverwaltung \u00a7c>> \u00a7eDu ben\u00f6tigst mehr Erfahrung um diesen Studiengang starten zu k\u00f6nnen. Bitte komme wieder, wenn dein Job-Level beim Minenarbeiter mindestens Level \u00a766\u00a7e betr\u00e4gt!");
        }
    }

    public void handleStartStudiengangLandwirtschaft(String player) {
        if (this.configManager.getValue(player, "studiengang_luftundraumfahrt_aktiv", true) || this.configManager.getValue(player, "studiengang_geologie_aktiv", true)) {
            Objects.requireNonNull(Bukkit.getPlayerExact((String)player)).sendMessage("\u00a76Universit\u00e4tsverwaltung \u00a7c>> \u00a7cDu bist bereits in einem anderen Studiengang eingeschrieben. Ich kann dich nicht zu einem weiteren Studiengang einschreiben!");
        } else if (this.configManager.getValue(player, "studiumAbgeschlossen_landwirtschaft", true)) {
            Objects.requireNonNull(Bukkit.getPlayerExact((String)player)).sendMessage("\u00a76Universit\u00e4tsverwaltung \u00a7c>> \u00a7cDu hast diesen Studiengang bereits erfolgreich abgeschlossen!");
        } else if (this.configManager.getValue(player, "job_Landwirt_Level", 0) >= 6) {
            if (UserDataManager.getBalance(Objects.requireNonNull(Bukkit.getPlayerExact((String)player)).getUniqueId()) >= 500.0) {
                this.configManager.setValue(player, "studiengang_landwirtschaft_aktiv", true);
                UserDataManager.logTransactionAsSend(Objects.requireNonNull(Bukkit.getPlayerExact((String)player)).getUniqueId(), 500.0, "Studiengeb\u00fchren des Studiengangs: Geologie", "FL Universit\u00e4t");
                UserDataManager.removeBalance(Objects.requireNonNull(Bukkit.getPlayerExact((String)player)).getUniqueId(), 500.0);
                Objects.requireNonNull(Bukkit.getPlayerExact((String)player)).sendMessage("\u00a76Universit\u00e4tsverwaltung \u00a7c>> \u00a7eHerzlichen Gl\u00fcckwunsch, du hast dich erfolgreich f\u00fcr den Studiengang \u00a76Landwirtschaft\u00a7e eingeschrieben!");
            } else {
                Objects.requireNonNull(Bukkit.getPlayerExact((String)player)).sendMessage("\u00a76Universit\u00e4tsverwaltung \u00a7c>> Der Studiengang kostet eine Geb\u00fchr von \u00a74500.0 Euro\u00a7c. Leider kannst du diese zurzeit noch nicht bezahlen.");
            }
        } else {
            Objects.requireNonNull(Bukkit.getPlayerExact((String)player)).sendMessage("\u00a76Universit\u00e4tsverwaltung \u00a7c>> \u00a7eDu ben\u00f6tigst mehr Erfahrung um diesen Studiengang starten zu k\u00f6nnen. Bitte komme wieder, wenn dein Job-Level beim Landwirt mindestens Level \u00a766\u00a7e betr\u00e4gt!");
        }
    }

    public Player getPlayerByString(String playerName) {
        return Bukkit.getPlayer((String)playerName);
    }

    public void handleRaketenAufbau(Player player, List<String> messages) {
        if (this.configManager.getValue(player.getName(), "studiengang_luftundraumfahrt_aktiv", true)) {
            messages.add("Eine Rakete besteht aus mehreren Teilen, die ihr helfen, ins All zu fliegen. Unten hat sie starke Triebwerke, die beim Start brennenden Treibstoff aussto\u00dfen und die Rakete nach oben dr\u00fccken.");
            messages.add("Der gr\u00f6\u00dfte Teil der Rakete ist ein langer Tank, der den Treibstoff speichert.");
            messages.add("Oben sitzt die Nutzlast \u2013 das kann ein Satellit, eine Raumsonde oder sogar eine Kapsel mit Astronauten sein.");
            messages.add("Manche Raketen haben mehrere Stufen:");
            messages.add("Wenn eine Stufe ihren Treibstoff verbraucht hat, wird sie abgeworfen, damit die Rakete leichter wird und weiterfliegen kann.");
            messages.add("Eine gro\u00dfe Rakete wie die Saturn V, die Astronauten zum Mond brachte, war 110 Meter hoch \u2013 so gro\u00df wie ein 36-st\u00f6ckiges Geb\u00e4ude! Sie wog beim Start etwa 2.800 Tonnen, das ist so viel wie 400 Elefanten. ");
            messages.add("Die Triebwerke erzeugen eine enorme Kraft: Die Falcon Heavy-Rakete von SpaceX hat einen Schub von etwa 22.819 Kilonewton \u2013 das entspricht dem Gewicht von fast 1.500 Autos. ");
            messages.add("Moderne Raketen fliegen mit einer Geschwindigkeit von \u00fcber 28.000 km/h, das ist siebenmal schneller als eine Gewehrkugel, um in den Weltraum zu gelangen. ");
            this.sendStoryToUser(player, messages);
        } else {
            player.sendMessage("\u00a7cDu bist zur Zeit nicht f\u00fcr den Studiengang \u00a79Luft und Raumfahrt\u00a7c eingeschrieben. Du kannst dich beim Empfang einschreiben lassen!");
            this.configManager.setValue(player.getName(), "vorlesungAktiv", false);
        }
    }

    public void handleLuftfahrt(Player player, List<String> messages) {
        if (this.configManager.getValue(player.getName(), "studiengang_luftundraumfahrt_aktiv", true)) {
            messages.add("Luftfahrt bedeutet, dass Menschen mit Flugzeugen und Hubschraubern durch die Luft reisen.");
            messages.add("Flugzeuge haben gro\u00dfe Fl\u00fcgel, die sie in der Luft halten, wenn die Luft darunter mehr Auftrieb gibt als das Flugzeug wiegt. Ein starker Motor oder ein D\u00fcsenantrieb sorgt daf\u00fcr, dass das Flugzeug schnell genug ist, um zu fliegen. ");
            messages.add("Der erste Motorflug gelang den Br\u00fcdern Wright im Jahr 1903 \u2013 ihr Flugzeug flog nur 12 Sekunden weit! ");
            messages.add("Heute k\u00f6nnen Passagierflugzeuge Tausende Kilometer weit fliegen und u\u0308ber 900 km/h schnell sein.");
            messages.add("Gro\u00dfe Flugh\u00e4fen wie in Frankfurt oder New York starten und landen jeden Tag Hunderte Flugzeuge mit Menschen aus der ganzen Welt. ");
            this.sendStoryToUser(player, messages);
        } else {
            player.sendMessage("\u00a7cDu bist zur Zeit nicht f\u00fcr den Studiengang \u00a79Luft und Raumfahrt\u00a7c eingeschrieben. Du kannst dich beim Empfang einschreiben lassen!");
            this.configManager.setValue(player.getName(), "vorlesungAktiv", false);
        }
    }

    public void handleSonnensystem(Player player, List<String> messages) {
        if (this.configManager.getValue(player.getName(), "studiengang_luftundraumfahrt_aktiv", true)) {
            messages.add("Unser Sonnensystem besteht aus der Sonne und acht Planeten, die um sie kreisen. Die Sonne ist eine riesige, hei\u00dfe Kugel aus Gas und gibt Licht und W\u00e4rme.");
            messages.add("Die Planeten sind unterschiedlich gro\u00df und weit entfernt. Merkur ist der kleinste und na\u0308chste zur Sonne, Jupiter der gr\u00f6\u00dfte.");
            messages.add("Erde ist der einzige Planet, auf dem wir wissen, dass es Leben gibt. Einige Planeten, wie Saturn, haben Ringe aus Eis und Gestein. ");
            messages.add("Au\u00dferdem gibt es Monde, Asteroiden und Kometen, die durchs All sausen. Alles wird durch die Schwerkraft der Sonne zusammengehalten! ");
            messages.add("W\u00e4hrend einige Planeten gar keine Monde haben, wie zum Beispiel der Merkur oder die Venus, haben andere Planeten mehrere Monde.");
            messages.add("Rekordhalter ist der Saturn mit 145 Monden, gefolgt vom Jupiter mit 92 Monden.");
            this.sendStoryToUser(player, messages);
        } else {
            player.sendMessage("\u00a7cDu bist zur Zeit nicht f\u00fcr den Studiengang \u00a79Luft und Raumfahrt\u00a7c eingeschrieben. Du kannst dich beim Empfang einschreiben lassen!");
            this.configManager.setValue(player.getName(), "vorlesungAktiv", false);
        }
    }

    public void handleDreiFelderWirtschaft(Player player, List<String> messages) {
        if (this.configManager.getValue(player.getName(), "studiengang_landwirtschaft_aktiv", true)) {
            messages.add("Die Dreifelderwirtschaft wurde im Mittelalter (ab dem 8. Jahrhundert) genutzt und machte die Landwirtschaft viel erfolgreicher. Die Bauern teilten ihr Land in drei Teile: ");
            messages.add("1. Ein Drittel fu\u0308r Wintergetreide (z. B. Weizen oder Roggen), das im Herbst ges\u00e4t wurde und im Sommer geerntet wurde. ");
            messages.add("2. Ein Drittel fu\u0308r Sommergetreide (z. B. Hafer oder Gerste), das im Fr\u00fchjahr ges\u00e4t und im Herbst geerntet wurde.");
            messages.add("3. Ein Drittel blieb brach (unbebaut), damit sich der Boden erholen konnte. Die Bauern lie\u00dfen darauf Tiere grasen, die den Boden mit D\u00fcnger versorgten. ");
            messages.add("Dank dieser Methode konnten Bauern etwa 20\u201330 % mehr Ernte einfahren als vorher, als sie nur die Zweifelderwirtschaft nutzten. ");
            messages.add("So gab es mehr Nahrung, und die Bev\u00f6lkerung in Europa wuchs von etwa 30 Millionen im Jahr 1000 auf 80 Millionen um 1300! ");
            this.sendStoryToUser(player, messages);
        } else {
            player.sendMessage("\u00a7cDu bist zur Zeit nicht f\u00fcr den Studiengang \u00a79Landwirtschaft\u00a7c eingeschrieben. Du kannst dich beim Empfang einschreiben lassen!");
            this.configManager.setValue(player.getName(), "vorlesungAktiv", false);
        }
    }

    public void handlePflanzUndErntezeiten(Player player, List<String> messages) {
        if (this.configManager.getValue(player.getName(), "studiengang_landwirtschaft_aktiv", true)) {
            messages.add("In der Landwirtschaft gibt es feste Zeiten fu\u0308r das Sa\u0308en (Pflanzen) und Ernten, damit die Pflanzen gut wachsen: ");
            messages.add("Weizen & Roggen (Wintergetreide): Wird im Herbst ges\u00e4t und im Sommer geerntet. ");
            messages.add("Hafer & Gerste (Sommergetreide): Wird im Fru\u0308hling ges\u00e4t und im Herbst geerntet. ");
            messages.add("Kartoffeln & Mais: Werden im Fru\u0308hling gepflanzt und im Herbst geerntet. ");
            messages.add("\u00c4pfel & Kirschen: Bl\u00fchen im Fru\u0308hling, wachsen im Sommer und werden im Herbst gepfl\u00fcckt. ");
            messages.add("So sorgt der Bauer das ganze Jahr u\u0308ber fu\u0308r genug Essen! ");
            this.sendStoryToUser(player, messages);
        } else {
            player.sendMessage("\u00a7cDu bist zur Zeit nicht f\u00fcr den Studiengang \u00a79Landwirtschaft\u00a7c eingeschrieben. Du kannst dich beim Empfang einschreiben lassen!");
            this.configManager.setValue(player.getName(), "vorlesungAktiv", false);
        }
    }

    public void handleViehzucht(Player player, List<String> messages) {
        if (this.configManager.getValue(player.getName(), "studiengang_landwirtschaft_aktiv", true)) {
            messages.add("Viehzucht bedeutet, dass Bauern Tiere halten, um wichtige Dinge wie Milch, Fleisch, Eier oder Wolle zu bekommen. Hier sind ein paar einfache Erkl\u00e4rungen zu den Tieren:");
            messages.add("Kuh: K\u00fche geben Milch, und eine Kuh kann bis zu 25 Liter pro Tag liefern! Manche K\u00fche werden auch f\u00fcr Fleisch gez\u00fcchtet. Sie haben vier M\u00e4gen, damit sie ihr Futter gut verdauen k\u00f6nnen.");
            messages.add("Schaf: Schafe liefern Wolle, Milch und Fleisch. Ein Schaf gibt bis zu 5 kg Wolle im Jahr. Sie leben oft auf der Weide und sind sehr friedlich.");
            messages.add("Schwein: Schweine wachsen schnell \u2013 in nur 6 Monaten sind sie gro\u00df genug f\u00fcr die Fleischproduktion. Sie sind schlau, k\u00f6nnen Tricks lernen und lieben es, im Schlamm zu baden, um sich abzuk\u00fchlen.");
            messages.add("Huhn: H\u00fchner legen bis zu 300 Eier im Jahr! Sie liefern auch Fleisch und gackern den ganzen Tag fr\u00f6hlich im Stall oder auf der Wiese.");
            messages.add("Piglin: Piglins sind seltsame Wesen aus dem Nether. Sie lieben Gold mehr als alles andere!");
            messages.add("Sie z\u00fcchten keine Tiere wie echte Bauern, aber sie tauschen Gold gegen tolle Sachen wie Enderperlen oder Feuerresistenztr\u00e4nke. Wenn du keine Goldr\u00fcstung tr\u00e4gst, werden sie schnell w\u00fctend!");
            this.sendStoryToUser(player, messages);
        } else {
            player.sendMessage("\u00a7cDu bist zur Zeit nicht f\u00fcr den Studiengang \u00a79Landwirtschaft\u00a7c eingeschrieben. Du kannst dich beim Empfang einschreiben lassen!");
            this.configManager.setValue(player.getName(), "vorlesungAktiv", false);
        }
    }

    public final void handleEdelsteine(Player player, List<String> messages) {
        if (this.configManager.getValue(player.getName(), "studiengang_geologie_aktiv", true)) {
            messages.add("Edelsteine sind besondere, oft farbige Steine, die in der Erde wachsen. Sie sind sehr hart und gl\u00e4nzen wundersch\u00f6n, wenn man sie schleift und poliert.");
            messages.add("Manche Edelsteine sind selten und sehr wertvoll. Jetzt schauen wir uns einige bekannte Edelsteine an:");
            messages.add("Diamant: Der h\u00e4rteste Edelstein der Welt! Er kann nur von einem anderen Diamanten zerkratzt werden und funkelt besonders stark. ");
            messages.add("Rubin: Meist leuchtend rot, er gilt als Stein der Liebe und des Mutes. ");
            messages.add("Saphir: Oft blau, aber es gibt ihn auch in anderen Farben. Er steht f\u00fcr Weisheit und Wahrheit.");
            messages.add("Smaragd: Strahlend gr\u00fcn und sehr wertvoll. Viele alte K\u00f6nige liebten diesen Stein. ");
            messages.add("Amethyst: Ein violetter Stein, der f\u00fcr Ruhe und Klarheit steht. ");
            messages.add("Edelsteine entstehen tief in der Erde durch Hitze und Druck u\u0308ber viele Millionen Jahre. Je nachdem, welche Stoffe in ihnen stecken, bekommen sie ihre besondere Farbe. ");
            this.sendStoryToUser(player, messages);
        } else {
            player.sendMessage("\u00a7cDu bist zur Zeit nicht f\u00fcr den Studiengang \u00a79Geologie\u00a7c eingeschrieben. Du kannst dich beim Empfang einschreiben lassen!");
            this.configManager.setValue(player.getName(), "vorlesungAktiv", false);
        }
    }

    public final void handleKristalle(Player player, List<String> messages) {
        if (this.configManager.getValue(player.getName(), "studiengang_geologie_aktiv", true)) {
            messages.add("Das Geheimnis der leuchtenden Steine ");
            messages.add("Vor langer Zeit lebten die Menschen in einem kleinen K\u00f6nigreich, in dem sie hart arbeiteten, aber nur einfache Werkzeuge hatten.");
            messages.add("Eines Tages fand ein junger Forscher namens Lior tief in einer H\u00f6hle einen Stein, der geheimnisvoll leuchtete.");
            messages.add("Als er ihn ber\u00fchrte, sp\u00fcrte er eine sanfte W\u00e4rme und ein leichtes Summen. ");
            messages.add("Neugierig brachte er den Stein zu den kl\u00fcgsten Handwerkern des Landes.");
            messages.add("Sie entdeckten, dass dieser Kristall Energie speichern und abgeben konnte!");
            messages.add("Bald bauten sie mit seiner Kraft die ersten gro\u00dfen Maschinen, die M\u00fchlen drehten und Metall bearbeiteten. Der Fortschritt war enorm! ");
            messages.add("Mit den Kristallen konnten sie sogar riesige Luftschiffe bauen.");
            messages.add("Das erste Flugger\u00e4t, \u201eHimmelsgleiter\u201c, hob ab und flog \u00fcber die Stadt, angetrieben von der unsichtbaren Kraft der Kristalle.");
            messages.add("Die Menschen waren begeistert und entwickelten immer neue Erfindungen. ");
            messages.add("So begann das Zeitalter der Kristallenergie, und die Welt wurde f\u00fcr immer ver\u00e4ndert. ");
            this.sendStoryToUser(player, messages);
        } else {
            player.sendMessage("\u00a7cDu bist zur Zeit nicht f\u00fcr den Studiengang \u00a79Geologie\u00a7c eingeschrieben. Du kannst dich beim Empfang einschreiben lassen!");
            this.configManager.setValue(player.getName(), "vorlesungAktiv", false);
        }
    }

    public final void handleGoldsuche(Player player, List<String> messages) {
        if (this.configManager.getValue(player.getName(), "studiengang_geologie_aktiv", true)) {
            messages.add("Goldsuche bedeutet, nach Gold in Fl\u00fcssen, Bergen oder unter der Erde zu suchen.");
            messages.add("Fr\u00fcher, zum Beispiel im Goldrausch des 19. Jahrhunderts, reisten viele Menschen in L\u00e4nder wie die USA oder Australien, um reich zu werden. ");
            messages.add("Sie siebten Sand aus Fl\u00fcssen oder gruben tiefe Minen.");
            messages.add("Heute findet man Gold meist tief unter der Erde. Gro\u00dfe Maschinen helfen dabei, es herauszuholen.");
            messages.add("Manchmal kann man aber noch mit einer einfachen Goldpfanne kleine Goldst\u00fccke in Fl\u00fcssen entdecken!");
            messages.add("Auch wenn in Deutschland seit 1990 kein Gold mehr gef\u00f6rdert wird, kann man in den Fl\u00fcssen dennoch ein wenig Gold finden.");
            this.sendStoryToUser(player, messages);
        } else {
            player.sendMessage("\u00a7cDu bist zur Zeit nicht f\u00fcr den Studiengang \u00a79Geologie\u00a7c eingeschrieben. Du kannst dich beim Empfang einschreiben lassen!");
            this.configManager.setValue(player.getName(), "vorlesungAktiv", false);
        }
    }

    public final void sendInfoToUser(final Player player) {
        long i = 1L;
        int timePuffer = 4;
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                player.sendMessage("\u00a76Information \u00a74>> \u00a7eDu befindest dich aktuell im Hauptgeb\u00e4ude der Universit\u00e4t von FutureLeague.");
            }
        }, 20L * i);
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                player.sendMessage("\u00a76Information \u00a74>> \u00a7eOben findest du das Sekretariat. Dort kannst du dein Studium verwalten und dich in einen Studiengang einschreiben lassen, falls du noch kein aktiven Studiengang hast.");
            }
        }, 20L * (i += (long)timePuffer));
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                player.sendMessage("\u00a76Information \u00a74>> \u00a7e In diesem Geb\u00e4ude befindet sich alles zum Studiengang Luft und Raumfahrt. Bevor du diesen Studiengang starten kannst, musst du zun\u00e4chst einen der anderen Studieng\u00e4nge abschlie\u00dfen.");
            }
        }, 20L * (i += (long)timePuffer));
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                player.sendMessage("\u00a76Information \u00a74>> \u00a7e Die anderen Studieng\u00e4nge befinden sich hinter diesem Geb\u00e4ude. Im Geb\u00e4ude A befindet sich der Studiengang Geologie und im Geb\u00e4ude B befindet sich der Studiengang Landwirtschaft!");
            }
        }, 20L * (i += (long)timePuffer));
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                player.sendMessage("\u00a76Information \u00a74>> \u00a7eVerschaffe dir dazu am besten einen \u00dcberblick auf der Karte an der Wand!");
            }
        }, 20L * (i += (long)timePuffer));
        i += (long)timePuffer;
    }

    public final void sendStoryToUser(final Player player, final List<String> messages) {
        messages.add("Damit sind wir am Ende unserer heutigen Vorlesung angelangt. Vielen Dank f\u00fcr eure Aufmerksamkeit und bis zur n\u00e4chsten Vorlesung!");
        new BukkitRunnable(){
            private int index = 0;

            public void run() {
                if (StudiumCommands.this.configManager.getValue(player.getName(), "vorlesungAktiv", true)) {
                    player.sendMessage("\u00a76Professor \u00a7c>>\u00a7e " + (String)messages.get(this.index));
                    ++this.index;
                    if (this.index == messages.size()) {
                        StudiumCommands.this.cancelVorlesung(player.getName());
                        StudiumCommands.this.configManager.setValue(player.getName(), "vorlesungAbgeschlossen_" + StudiumCommands.this.group, true);
                        StudiumCommands.this.insertTimestamp(player, StudiumCommands.this.group, false);
                        this.cancel();
                    }
                } else {
                    this.index = messages.size();
                    player.sendMessage("\u00a7cSie haben die Vorlesung fr\u00fchzeitig verlassen. Das Modul z\u00e4hlt somit nicht als abgeschlossen.");
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 20L, 100L);
    }

    public final void insertTimestamp(Player player, String module, boolean studium) {
        String playerName = player.getName();
        Date currentTime = new Date();
        if (studium) {
            this.configManager.setValue(playerName, "studiumAbgeschlossen_timestamp_" + module, currentTime);
        } else {
            this.configManager.setValue(playerName, "letzteVorlesung", module);
            this.configManager.setValue(playerName, "vorlesungAbgeschlossen_timestamp_" + module, currentTime);
        }
    }
}

