/*
 * Decompiled with CFR 0.152.
 */
package de.flipper1406.futureleague_wirtschaft.Jobs.Commands;

import de.flipper1406.futureleague_wirtschaft.ConfigManager.ConfigFileExp;
import de.flipper1406.futureleague_wirtschaft.ConfigManager.ConfigFileJobs;
import de.flipper1406.futureleague_wirtschaft.ConfigManager.ConfigManager;
import de.flipper1406.futureleague_wirtschaft.FLAPI;
import de.flipper1406.futureleague_wirtschaft.FutureLeagueWirtschaft;
import de.flipper1406.futureleague_wirtschaft.Regions.RegionManager;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class JobCommands
implements Listener,
CommandExecutor {
    private final ConfigManager configManager;
    private final FLAPI flapi;
    private static final int NUMBER_OF_DEZIMAL_POINTS = 2;
    private static final double PERCENTAGE_MULTIPLIER = 100.0;
    private static final int INVENTORY_SIZE = 36;
    private static final float REWARD_SOUND_VOLUME = 10.0f;
    private static final float REWARD_SOUND_PITCH = 1.0f;
    private final int standardInventorySize = 27;
    private final ConfigFileJobs configFileJobs;
    private final ConfigFileExp configFileExp;
    private final String prefixTitle = "Job-System";
    private FutureLeagueWirtschaft plugin;
    private final Material[] jobMaterials = new Material[]{Material.FISHING_ROD, Material.WATER_BUCKET, Material.BRUSH, Material.DIAMOND_SWORD, Material.DIAMOND_PICKAXE, Material.WOODEN_AXE, Material.IRON_HOE, Material.POPPY, Material.POTION, Material.CAKE};

    public JobCommands(FutureLeagueWirtschaft witschaftsPlugin) {
        this.plugin = witschaftsPlugin;
        this.configManager = witschaftsPlugin.getConfigManager();
        this.flapi = witschaftsPlugin.getflapi();
        this.configFileJobs = witschaftsPlugin.getConfigFileJobs();
        this.configFileExp = witschaftsPlugin.getConfigFileExp();
    }

    private void helpPage(Player p) {
        this.flapi.sendPrefixMessage(p, "Job-System");
        p.sendMessage(" \u00a7aBenutze \u00a72/jobs join \u00a7aum einen neuen Job anzunehmen.");
        p.sendMessage(" \u00a7aBenutze \u00a72/jobs leave \u00a7aum deinen aktuellen Job zu k\u00fcndigen.");
        p.sendMessage(" \u00a7aBenutze \u00a72/jobs status \u00a7aum deinen aktuellen Job-Status einzusehen.");
        p.sendMessage(" \u00a7aBenutze \u00a72/jobs help \u00a7aum diese Hilfe-Seite zu \u00f6ffnen.");
        p.sendMessage(" \u00a7aBenutze \u00a72/jobs info \u00a7aum weitere Informationen zu einem Job zu erhalten.");
        p.sendMessage(" \u00a7aBenutze \u00a72/jobs list \u00a7aum eine Liste aller Jobs zu erhalten.");
        p.sendMessage("");
        p.sendMessage(" \u00a72Beim Verlassen des Netzwerks, wird dein aktueller Job automatisch gek\u00fcndigt. Du kannst aber jederzeit einen neuen Job annehmen.");
        this.flapi.sendSuffixMessage(p);
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (!(sender instanceof Player)) {
            return true;
        }
        Player p = (Player)sender;
        if (!cmd.getName().equalsIgnoreCase("jobs")) {
            return true;
        }
        if (args.length == 0) {
            this.helpPage(p);
            return true;
        }
        switch (args[0].toLowerCase()) {
            case "join": {
                this.handleJoin(p);
                break;
            }
            case "leave": {
                this.handleLeave(p);
                break;
            }
            case "status": {
                this.handleStatus(p);
                break;
            }
            case "info": {
                this.handleInfo(p, args);
                break;
            }
            case "list": {
                this.handleList(p);
                break;
            }
            case "belohnung": 
            case "reward": 
            case "belohnungen": 
            case "rewards": {
                this.handleReward(p);
                break;
            }
            case "reset": {
                this.handleReset(p);
                break;
            }
            default: {
                this.helpPage(p);
            }
        }
        return true;
    }

    private void handleJoin(Player p) {
        if (!this.configManager.checkForPlayerInConfig(p.getName())) {
            this.configManager.setValue(p.getName(), "currentJob", "Arbeitslos");
            this.configManager.setValue(p.getName(), "hasJob", false);
        }
        if (this.configManager.getValue(p.getName(), "hasJob", true)) {
            this.flapi.sendPrefixMessage(p, "Job-System");
            p.sendMessage(" \u00a72<> \u00a7aDu besitzt bereits einen Job: \u00a72" + this.configManager.getValue(p.getName(), "currentJob"));
            this.flapi.sendSuffixMessage(p);
            return;
        }
        Inventory inventory = Bukkit.createInventory(null, (int)27, (String)this.configFileJobs.getInventoryTitle());
        for (int i = 0; i < this.configFileJobs.getJobName().size(); ++i) {
            inventory.setItem(i, this.flapi.getItemForJobInventory(new ItemStack(this.jobMaterials[i]), this.configFileJobs.getJobName().get(i), this.configFileJobs.getBezeichnung().get(i)));
        }
        p.openInventory(inventory);
    }

    private void handleLeave(Player p) {
        if (!this.configManager.getValue(p.getName(), "hasJob", true)) {
            this.flapi.sendPrefixMessage(p, "Job-System");
            p.sendMessage(" \u00a72<> \u00a7aDu hast noch keinen Job. Beginne einen mit \u00a72/jobs join");
            this.flapi.sendSuffixMessage(p);
            return;
        }
        this.flapi.sendPrefixMessage(p, "Job-System");
        p.sendMessage(" \u00a72<> \u00a72Du hast deinen Job \u00a7a" + this.configManager.getValue(p.getName(), "currentJob") + " \u00a72gek\u00fcndigt!");
        this.flapi.sendSuffixMessage(p);
        this.configManager.setValue(p.getName(), "hasJob", false);
        this.configManager.setValue(p.getName(), "currentJob", "Arbeitslos");
        this.configManager.setValue(p.getName(), "onMission", false);
    }

    private void handleStatus(Player p) {
        int aktuellesLevel = this.flapi.getJobLevel(p);
        int aktuellesEXP = this.flapi.getJobEXP(p);
        List<Integer> levels = this.configFileExp.getLevelSteps();
        int nextEXP = levels.get(aktuellesLevel);
        this.flapi.sendPrefixMessage(p, "Job-System");
        p.sendMessage(" \u00a72<> \u00a72Aktueller Job: \u00a7a" + this.configManager.getValue(p.getName(), "currentJob"));
        if (!this.configManager.getValue(p.getName(), "currentJob").equalsIgnoreCase("Arbeitslos")) {
            double percentage = (double)aktuellesEXP / (double)nextEXP * 100.0;
            percentage = this.flapi.rint(percentage, 2);
            p.sendMessage(" \u00a72<> \u00a72Aktuelles Level: \u00a7a" + aktuellesLevel);
            p.sendMessage(" \u00a72<> \u00a72Fortschritt zum n\u00e4chsten Level: \u00a7a" + percentage + "\u00a72%");
        }
        this.flapi.sendSuffixMessage(p);
    }

    private void handleInfo(Player p, String[] args) {
        if (args.length < 2) {
            this.flapi.sendPrefixMessage(p, "Job-System");
            p.sendMessage(" \u00a72<> \u00a7aErhalte weitere Informationen zu einem Job mit \u00a72/jobs info <JobName>");
            this.flapi.sendSuffixMessage(p);
            return;
        }
        boolean found = false;
        for (int i = 0; i < this.configFileJobs.getJobName().size(); ++i) {
            if (!args[1].equalsIgnoreCase(this.configFileJobs.getJobName().get(i))) continue;
            this.flapi.sendPrefixMessage(p, "Job-System");
            p.sendMessage(" \u00a7a" + this.configFileJobs.getBezeichnung().get(i));
            this.flapi.sendSuffixMessage(p);
            found = true;
            break;
        }
        if (!found) {
            this.flapi.sendPrefixMessage(p, "Job-System");
            p.sendMessage(" \u00a7cWir konnten den eingegebenen Job \u00a74" + args[1] + "\u00a7c nicht finden!");
            p.sendMessage(" \u00a72Folgende Jobs sind verf\u00fcgbar:");
            for (String jobName : this.configFileJobs.getJobName()) {
                p.sendMessage(" \u00a7a- " + jobName);
            }
            this.flapi.sendSuffixMessage(p);
        }
    }

    private void handleList(Player p) {
        this.flapi.sendPrefixMessage(p, "Job-System");
        p.sendMessage(" \u00a72Folgende Jobs sind verf\u00fcgbar:");
        for (String jobName : this.configFileJobs.getJobName()) {
            p.sendMessage(" \u00a7a- " + jobName);
        }
        this.flapi.sendSuffixMessage(p);
    }

    private void handleReward(Player p) {
        for (String jobName : this.configFileJobs.getJobName()) {
            ItemStack item = this.flapi.getRewardItem(jobName, p);
            if (!this.configManager.getRewards(p, jobName)) continue;
            boolean invHasFreeSlot = false;
            int slot = -1;
            for (int i = 0; i < 36; ++i) {
                if (p.getInventory().getItem(i) != null) continue;
                invHasFreeSlot = true;
                slot = i;
                break;
            }
            if (invHasFreeSlot) {
                p.getInventory().setItem(slot, item);
                this.flapi.sendMessage(p, "rewardSuccess");
                this.configManager.setRewards(p, jobName, false);
                p.playSound(p.getLocation(), Sound.UI_TOAST_CHALLENGE_COMPLETE, 10.0f, 1.0f);
                continue;
            }
            this.flapi.sendMessage(p, "rewardErrorNoSpaceInInventory");
        }
    }

    private void handleReset(Player p) {
        RegionManager.getInstance().resetRegion(RegionManager.getInstance().getRegion("einsatz1"), p);
    }
}

