/*
 * Decompiled with CFR 0.152.
 */
package de.flipper1406.futureleague_wirtschaft.Jobs.Events;

import de.flipper1406.futureleague_wirtschaft.ConfigManager.ConfigFileExp;
import de.flipper1406.futureleague_wirtschaft.ConfigManager.ConfigManager;
import de.flipper1406.futureleague_wirtschaft.FLAPI;
import de.flipper1406.futureleague_wirtschaft.FutureLeagueWirtschaft;
import java.util.ArrayList;
import org.bukkit.Bukkit;
import org.bukkit.CropState;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.data.Ageable;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.Crops;

public class LandwirtEvents
implements Listener {
    private final int firstLevelStep = 1;
    private final int seccondLevelStep = 5;
    private final int thirdLevelStep = 8;
    private final int fourthLevelStep = 10;
    private final int fifthLevelStep = 13;
    private int expCarrots = 0;
    private int expPotatoes = 0;
    private int expNetherWart = 0;
    private int expBeetroots = 0;
    private int expCocoa = 0;
    private int expPumpkin = 0;
    private int expMelon = 0;
    private int expSugarCane = 0;
    private int expBamboo = 0;
    private int expIronHoe = 0;
    private int expGoldenHoe = 0;
    private int expDiamondHoe = 0;
    private int expNetheriteHoe = 0;
    private int expShears = 0;
    private int expBucket = 0;
    private int expBread = 0;
    private int expHayBlock = 0;
    private final ConfigManager configManager;
    private FutureLeagueWirtschaft plugin;
    private final FLAPI flapi;
    private final ConfigFileExp configFileExp;
    private String jobName = "Landwirt";

    public LandwirtEvents(FutureLeagueWirtschaft wirtschaftsPlugin) {
        this.plugin = wirtschaftsPlugin;
        this.configManager = wirtschaftsPlugin.getConfigManager();
        this.configFileExp = wirtschaftsPlugin.getConfigFileExp();
        this.flapi = wirtschaftsPlugin.getflapi();
    }

    private void setExpValues() {
        this.expCarrots = this.configFileExp.getExpValue("CARROTS");
        this.expPotatoes = this.configFileExp.getExpValue("POTATOES");
        this.expBeetroots = this.configFileExp.getExpValue("BEETROOTS");
        this.expCocoa = this.configFileExp.getExpValue("COCOA");
        this.expNetherWart = this.configFileExp.getExpValue("NETHER_WART");
        this.expPumpkin = this.configFileExp.getExpValue("PUMPKIN");
        this.expMelon = this.configFileExp.getExpValue("MELON");
        this.expBamboo = this.configFileExp.getExpValue("BAMBOO");
        this.expSugarCane = this.configFileExp.getExpValue("SUGAR_CANE");
        this.expIronHoe = this.configFileExp.getExpValue("IRON_HOE");
        this.expGoldenHoe = this.configFileExp.getExpValue("GOLDEN_HOE");
        this.expDiamondHoe = this.configFileExp.getExpValue("DIAMOND_HOE");
        this.expNetheriteHoe = this.configFileExp.getExpValue("NETHERITE_HOE");
        this.expShears = this.configFileExp.getExpValue("SHEARS");
        this.expBucket = this.configFileExp.getExpValue("BUCKET");
        this.expHayBlock = this.configFileExp.getExpValue("HAY_BLOCK");
    }

    private int getCraftAmount(CraftItemEvent e) {
        if (e.isCancelled()) {
            return 0;
        }
        Player p = (Player)e.getWhoClicked();
        if (e.isShiftClick()) {
            int itemsChecked = 0;
            int possibleCreations = 1;
            int amountCanBeMade = 0;
            for (ItemStack item : e.getInventory().getMatrix()) {
                if (item == null || item.getType() == Material.AIR) continue;
                if (itemsChecked == 0) {
                    possibleCreations = item.getAmount();
                    ++itemsChecked;
                    continue;
                }
                possibleCreations = Math.min(possibleCreations, item.getAmount());
            }
            int amountOfItems = e.getRecipe().getResult().getAmount() * possibleCreations;
            ItemStack i = e.getRecipe().getResult();
            for (int s = 0; s <= p.getInventory().getSize(); ++s) {
                ItemStack test = p.getInventory().getItem(s);
                if (test == null || test.getType() == Material.AIR) {
                    amountCanBeMade += i.getMaxStackSize();
                    continue;
                }
                if (!test.isSimilar(i)) continue;
                amountCanBeMade += i.getMaxStackSize() - test.getAmount();
            }
            return Math.min(amountOfItems, amountCanBeMade);
        }
        return e.getRecipe().getResult().getAmount();
    }

    private ItemStack randomItem(Player p) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        int lvl = this.configManager.getValue(p.getName(), "job_" + this.jobName + "_Level", 0);
        if (lvl >= 1) {
            items.add(new ItemStack(Material.BONE_MEAL));
            items.add(new ItemStack(Material.WHEAT));
            items.add(new ItemStack(Material.WHEAT_SEEDS));
            items.add(new ItemStack(Material.CARROT));
            items.add(new ItemStack(Material.POISONOUS_POTATO));
            items.add(new ItemStack(Material.POTATO));
        }
        if (lvl >= 5) {
            items.add(new ItemStack(Material.GOLD_NUGGET));
            items.add(new ItemStack(Material.BONE));
            items.add(new ItemStack(Material.DIRT));
        }
        if (lvl >= 8) {
            items.add(new ItemStack(Material.IRON_NUGGET));
            items.add(new ItemStack(Material.GOLDEN_CARROT));
        }
        if (lvl >= 10) {
            items.add(new ItemStack(Material.GLISTERING_MELON_SLICE));
            items.add(new ItemStack(Material.BEETROOT));
        }
        if (lvl >= 13) {
            items.add(new ItemStack(Material.NETHER_WART));
            items.add(new ItemStack(Material.SOUL_SAND));
        }
        int randNumber = (int)(Math.random() * (double)items.size());
        return (ItemStack)items.get(randNumber);
    }

    private boolean cropIsRipe(BlockBreakEvent e) {
        Crops crops;
        Ageable age;
        Block b = e.getBlock();
        return b.getType() == Material.COCOA ? b.getBlockData() instanceof Ageable && (age = (Ageable)b.getBlockData()).getAge() == age.getMaximumAge() : (crops = (Crops)b.getState().getData()).getState().equals((Object)CropState.RIPE);
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent e) {
        this.setExpValues();
        Player p = e.getPlayer();
        if (this.configManager.getValue(p.getName(), "currentJob").equalsIgnoreCase(this.jobName)) {
            Block b = e.getBlock();
            if (b.getType() == Material.CARROTS) {
                if (this.cropIsRipe(e)) {
                    this.flapi.raiseEXP(p, this.expCarrots, this.configManager.getValue(p.getName(), "currentJob"));
                    if (this.flapi.playerGetsMoreLoot(p, this.jobName)) {
                        e.getPlayer().getLocation().getWorld().dropItemNaturally(e.getBlock().getLocation(), this.randomItem(p));
                    }
                }
            } else if (b.getType() == Material.POTATOES) {
                if (this.cropIsRipe(e)) {
                    this.flapi.raiseEXP(p, this.expPotatoes, this.configManager.getValue(p.getName(), "currentJob"));
                    if (this.flapi.playerGetsMoreLoot(p, this.jobName)) {
                        e.getPlayer().getLocation().getWorld().dropItemNaturally(e.getBlock().getLocation(), this.randomItem(p));
                    }
                }
            } else if (b.getType() == Material.BEETROOTS) {
                if (this.cropIsRipe(e)) {
                    this.flapi.raiseEXP(p, this.expBeetroots, this.configManager.getValue(p.getName(), "currentJob"));
                    if (this.flapi.playerGetsMoreLoot(p, this.jobName)) {
                        e.getPlayer().getLocation().getWorld().dropItemNaturally(e.getBlock().getLocation(), this.randomItem(p));
                    }
                }
            } else if (b.getType() == Material.COCOA) {
                if (this.cropIsRipe(e)) {
                    this.flapi.raiseEXP(p, this.expCocoa, this.configManager.getValue(p.getName(), "currentJob"));
                    if (this.flapi.playerGetsMoreLoot(p, this.jobName)) {
                        e.getPlayer().getLocation().getWorld().dropItemNaturally(e.getBlock().getLocation(), this.randomItem(p));
                    }
                }
            } else if (b.getType() == Material.NETHER_WART) {
                if (this.cropIsRipe(e)) {
                    this.flapi.raiseEXP(p, this.expNetherWart, this.configManager.getValue(p.getName(), "currentJob"));
                    if (this.flapi.playerGetsMoreLoot(p, this.jobName)) {
                        e.getPlayer().getLocation().getWorld().dropItemNaturally(e.getBlock().getLocation(), this.randomItem(p));
                    }
                }
            } else if (b.getType() == Material.PUMPKIN) {
                this.flapi.raiseEXP(p, this.expPumpkin, this.configManager.getValue(p.getName(), "currentJob"));
                if (this.flapi.playerGetsMoreLoot(p, this.jobName)) {
                    e.getPlayer().getLocation().getWorld().dropItemNaturally(e.getBlock().getLocation(), this.randomItem(p));
                }
            } else if (b.getType() == Material.MELON) {
                this.flapi.raiseEXP(p, this.expMelon, this.configManager.getValue(p.getName(), "currentJob"));
                if (this.flapi.playerGetsMoreLoot(p, this.jobName)) {
                    e.getPlayer().getLocation().getWorld().dropItemNaturally(e.getBlock().getLocation(), this.randomItem(p));
                }
            } else if (b.getType() == Material.BAMBOO) {
                this.flapi.raiseEXP(p, this.expBamboo, this.configManager.getValue(p.getName(), "currentJob"));
            } else if (b.getType() == Material.SUGAR_CANE) {
                this.flapi.raiseEXP(p, this.expSugarCane, this.configManager.getValue(p.getName(), "currentJob"));
                if (this.flapi.playerGetsMoreLoot(p, this.jobName)) {
                    e.getPlayer().getLocation().getWorld().dropItemNaturally(e.getBlock().getLocation(), this.randomItem(p));
                }
            }
        }
    }

    @EventHandler
    public void onCraftItem(CraftItemEvent e) {
        this.setExpValues();
        Player p = Bukkit.getPlayer((String)e.getWhoClicked().getName());
        if (e.getRecipe().getResult().getType() == Material.IRON_HOE) {
            assert (p != null);
            int numberOfCraftedItems = this.getCraftAmount(e);
            this.flapi.raiseEXP(p, this.expIronHoe * numberOfCraftedItems, this.configManager.getValue(p.getName(), "currentJob"));
        } else if (e.getRecipe().getResult().getType() == Material.GOLDEN_HOE) {
            assert (p != null);
            int numberOfCraftedItems = this.getCraftAmount(e);
            this.flapi.raiseEXP(p, this.expGoldenHoe * numberOfCraftedItems, this.configManager.getValue(p.getName(), "currentJob"));
        } else if (e.getRecipe().getResult().getType() == Material.DIAMOND_HOE) {
            assert (p != null);
            int numberOfCraftedItems = this.getCraftAmount(e);
            this.flapi.raiseEXP(p, this.expDiamondHoe * numberOfCraftedItems, this.configManager.getValue(p.getName(), "currentJob"));
        } else if (e.getRecipe().getResult().getType() == Material.NETHERITE_HOE) {
            assert (p != null);
            int numberOfCraftedItems = this.getCraftAmount(e);
            this.flapi.raiseEXP(p, this.expNetheriteHoe * numberOfCraftedItems, this.configManager.getValue(p.getName(), "currentJob"));
        } else if (e.getRecipe().getResult().getType() == Material.SHEARS) {
            assert (p != null);
            int numberOfCraftedItems = this.getCraftAmount(e);
            this.flapi.raiseEXP(p, this.expShears * numberOfCraftedItems, this.configManager.getValue(p.getName(), "currentJob"));
        } else if (e.getRecipe().getResult().getType() == Material.BUCKET) {
            assert (p != null);
            int numberOfCraftedItems = this.getCraftAmount(e);
            this.flapi.raiseEXP(p, this.expBucket * numberOfCraftedItems, this.configManager.getValue(p.getName(), "currentJob"));
        } else if (e.getRecipe().getResult().getType() == Material.BREAD) {
            assert (p != null);
            int numberOfCraftedItems = this.getCraftAmount(e);
            this.flapi.raiseEXP(p, this.expBread * numberOfCraftedItems, this.configManager.getValue(p.getName(), "currentJob"));
        } else if (e.getRecipe().getResult().getType() == Material.HAY_BLOCK) {
            assert (p != null);
            int numberOfCraftedItems = this.getCraftAmount(e);
            this.flapi.raiseEXP(p, this.expHayBlock * numberOfCraftedItems, this.configManager.getValue(p.getName(), "currentJob"));
        }
    }
}

