/*
 * Decompiled with CFR 0.152.
 */
package de.flipper1406.futureleague_wirtschaft.Regions;

import de.flipper1406.futureleague_wirtschaft.ChestShop.ChestShop;
import de.flipper1406.futureleague_wirtschaft.ChestShop.ChestShopManager;
import de.flipper1406.futureleague_wirtschaft.FutureLeagueWirtschaft;
import de.flipper1406.futureleague_wirtschaft.Regions.BlockStateData;
import de.flipper1406.futureleague_wirtschaft.Regions.BlockStorage;
import de.flipper1406.futureleague_wirtschaft.Regions.ChatInput;
import de.flipper1406.futureleague_wirtschaft.Regions.Region;
import de.flipper1406.futureleague_wirtschaft.Userdata.Utils.UserDataManager;
import java.io.File;
import java.io.IOException;
import java.text.NumberFormat;
import java.time.DayOfWeek;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class RegionManager {
    private static RegionManager instance;
    private final Map<String, Region> regions = new HashMap<String, Region>();
    private final File file;
    private FileConfiguration config;
    private final File blockStorageFolder;
    private final double standardPriceForNewRegions = 1000.0;
    private static final int FIRST_LINE = 0;
    private static final int SECOND_LINE = 1;
    private static final int THIRD_LINE = 2;
    private static final int FOURTH_LINE = 3;
    private static final int REGION_Y_CHECK_STEP = 3;
    private static final int SPEED_LEVEL_1 = 1;
    private static final int SPEED_LEVEL_2 = 2;
    private static final int SPEED_LEVEL_3 = 3;
    private static final int SPEED_LEVEL_4 = 4;
    private static final int SPEED_LEVEL_5 = 5;
    private static final float SPEED_VALUE_1 = 0.2f;
    private static final float SPEED_VALUE_2 = 0.4f;
    private static final float SPEED_VALUE_3 = 0.6f;
    private static final float SPEED_VALUE_4 = 0.8f;
    private static final float SPEED_VALUE_5 = 1.0f;
    private static final long HOURLY = 1200L;
    private static final int MIN_Y_LEVEL = -64;
    private static final int MAX_Y_LEVEL = 319;

    public RegionManager(File dataFolder) {
        this.file = new File(dataFolder, "regions.yml");
        this.blockStorageFolder = new File(dataFolder, "regionen");
        if (!this.file.exists()) {
            try {
                this.file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (!this.blockStorageFolder.exists()) {
            this.blockStorageFolder.mkdirs();
        }
        this.loadRegions();
        instance = this;
    }

    public static RegionManager getInstance() {
        return instance;
    }

    public void startPriceChange(Player player, Region region) {
        ChatInput.WAITING_FOR_PLAYER.put(player.getUniqueId(), new ChatInput.SetPrice(region));
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Bitte gib den neuen Preis f\u00fcr die Region " + region.getName() + " im Chat ein.");
    }

    public void loadRegions() {
        this.config = YamlConfiguration.loadConfiguration((File)this.file);
        this.regions.clear();
        for (String key : this.config.getKeys(false)) {
            String world = this.config.getString(key + ".world");
            boolean isFree = this.config.getBoolean(key + ".free", true);
            boolean isActive = this.config.getBoolean(key + ".active", false);
            boolean isBuyable = this.config.getBoolean(key + ".buyable", true);
            double price = this.config.getDouble(key + ".price", 1000.0);
            boolean rentable = this.config.getBoolean(key + ".rentable", false);
            double userPrice = this.config.getDouble(key + ".userPrice");
            boolean userOffer = this.config.getBoolean(key + ".userOffer");
            boolean playerWasActive = this.config.getBoolean(key + ".playerWasActive");
            UUID owner = UUID.fromString(this.config.getString(key + ".owner"));
            String coOwner = this.config.getString(key + ".coOwner");
            Location min = this.deserializeLocation(this.config.getConfigurationSection(key + ".min"), world);
            Location max = this.deserializeLocation(this.config.getConfigurationSection(key + ".max"), world);
            Region region = new Region.Builder().name(key).owner(owner).coOwner(coOwner).pos1(min).pos2(max).price(price).rentable(rentable).playerWasActive(true).speedLevel(1).build();
            region.setFree(isFree);
            region.setActive(isActive);
            region.setBuyable(isBuyable);
            region.setUserPrice(userPrice);
            region.setUserOffer(userOffer);
            region.setPlayerWasActive(playerWasActive);
            int speedLevel = this.config.getInt(key + ".speedLevel", 0);
            region.setSpeedLevel(speedLevel);
            List staffListRaw = this.config.getStringList(key + ".staff");
            ArrayList<UUID> staffList = new ArrayList<UUID>();
            for (Object uuidStr : staffListRaw) {
                try {
                    staffList.add(UUID.fromString((String)uuidStr));
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
            region.setStaff(staffList);
            if (this.config.isConfigurationSection(key + ".interactionPermissions")) {
                Object uuidStr;
                ConfigurationSection interactionSection = this.config.getConfigurationSection(key + ".interactionPermissions");
                uuidStr = interactionSection.getKeys(false).iterator();
                while (uuidStr.hasNext()) {
                    String interactionKey = (String)uuidStr.next();
                    boolean value = interactionSection.getBoolean(interactionKey);
                    region.setInteraction(interactionKey, value);
                }
            }
            BlockStorage storage = new BlockStorage(region.getName(), this.blockStorageFolder);
            List<BlockStateData> savedBlocks = storage.loadBlocks(region);
            region.setSavedBlocks(savedBlocks);
            List signList = this.config.getMapList(key + ".signs");
            ArrayList<Location> signs = new ArrayList<Location>();
            for (Map m : signList) {
                try {
                    String worldsign = (String)m.get("world");
                    int x = (Integer)m.get("x");
                    int y = (Integer)m.get("y");
                    int z = (Integer)m.get("z");
                    signs.add(new Location(Bukkit.getWorld((String)worldsign), (double)x, (double)y, (double)z));
                }
                catch (Exception e) {
                    Bukkit.getLogger().warning("Fehler beim Laden eines Regionschilds in: " + key);
                }
            }
            region.setSigns(signs);
            this.regions.put(key.toLowerCase(), region);
        }
    }

    public void saveRegion(Region region) {
        String path = region.getName().toLowerCase();
        this.config.set(path + ".world", (Object)region.getMin().getWorld().getName());
        this.config.set(path + ".owner", (Object)region.getOwner().toString());
        this.config.set(path + ".coOwner", (Object)region.getCoOwner());
        this.config.set(path + ".free", (Object)region.isFree());
        this.config.set(path + ".active", (Object)region.isActive());
        this.config.set(path + ".buyable", (Object)region.isBuyable());
        this.config.set(path + ".price", (Object)region.getPrice());
        this.config.set(path + ".rentable", (Object)region.isRentable());
        this.config.set(path + ".userPrice", (Object)region.getUserPrice());
        this.config.set(path + ".userOffer", (Object)region.isUserOffer());
        this.config.set(path + ".playerWasActive", (Object)region.getPlayerWasActive());
        this.serializeLocation(path + ".min", region.getMin());
        this.serializeLocation(path + ".max", region.getMax());
        this.config.set(path + ".speedLevel", (Object)region.getSpeedLevel());
        ArrayList signLocations = new ArrayList();
        for (Location location : region.getSigns()) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("world", location.getWorld().getName());
            hashMap.put("x", location.getBlockX());
            hashMap.put("y", location.getBlockY());
            hashMap.put("z", location.getBlockZ());
            signLocations.add(hashMap);
        }
        this.config.set(path + ".signs", signLocations);
        List<String> staffList = region.getStaff().stream().map(UUID::toString).toList();
        this.config.set(path + ".staff", staffList);
        for (Map.Entry<String, Boolean> entry : region.getInteractionPermissions().entrySet()) {
            this.config.set(path + ".interactionPermissions." + entry.getKey(), (Object)entry.getValue());
        }
        BlockStorage blockStorage = new BlockStorage(region.getName(), this.blockStorageFolder);
        blockStorage.saveBlocks(region);
        this.updateSignStatus(region);
        try {
            this.config.save(this.file);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void saveRegions() {
        for (Region region : this.regions.values()) {
            this.saveRegion(region);
        }
    }

    public void addRegion(Region region) {
        region.setSavedBlocks(this.saveRegionBlocks(region));
        this.regions.put(region.getName().toLowerCase(), region);
    }

    public void removeRegion(String name) {
        this.regions.remove(name.toLowerCase());
        this.config.set(name.toLowerCase(), null);
        BlockStorage storage = new BlockStorage(name, this.blockStorageFolder);
        storage.deleteBlockFile();
        this.saveRegions();
    }

    public boolean isXZinRegion(int x, int z) {
        World testWorld = Bukkit.getWorld((String)"city");
        for (int y = testWorld.getMinHeight(); y <= testWorld.getMaxHeight(); y += 3) {
            Location testLoc = new Location(testWorld, (double)x, (double)y, (double)z);
            if (this.getRegion(testLoc) == null) continue;
            return true;
        }
        return false;
    }

    public Region getRegion(String name) {
        return this.regions.get(name.toLowerCase());
    }

    public Region getRegion(Location loc) {
        for (Region region : this.regions.values()) {
            if (!region.contains(loc)) continue;
            return region;
        }
        return null;
    }

    public Set<String> getAllRegionNames() {
        return this.regions.keySet();
    }

    public Collection<Region> getAllRegions() {
        return this.regions.values();
    }

    private void serializeLocation(String path, Location loc) {
        this.config.set(path + ".x", (Object)loc.getBlockX());
        this.config.set(path + ".y", (Object)loc.getBlockY());
        this.config.set(path + ".z", (Object)loc.getBlockZ());
    }

    private Location deserializeLocation(ConfigurationSection section, String worldName) {
        int x = section.getInt("x");
        int y = section.getInt("y");
        int z = section.getInt("z");
        return new Location(Bukkit.getWorld((String)worldName), (double)x, (double)y, (double)z);
    }

    public List<BlockStateData> saveRegionBlocks(Region region) {
        int yMax;
        ArrayList<BlockStateData> savedBlocks = new ArrayList<BlockStateData>();
        Location min = region.getMin();
        Location max = region.getMax();
        World world = min.getWorld();
        if (region.isBuyable()) {
            yMin = -64;
            yMax = 319;
        } else {
            yMin = region.getMinY();
            yMax = region.getMaxY();
        }
        for (int x = min.getBlockX(); x <= max.getBlockX(); ++x) {
            for (int y = yMin; y <= yMax; ++y) {
                for (int z = min.getBlockZ(); z <= max.getBlockZ(); ++z) {
                    savedBlocks.add(new BlockStateData(world.getBlockAt(x, y, z)));
                }
            }
        }
        return savedBlocks;
    }

    public final void updateSignStatus(Region region) {
        Bukkit.getScheduler().runTask((Plugin)FutureLeagueWirtschaft.getInstance(), () -> {
            for (Location signLoc : region.getSigns()) {
                Block block = signLoc.getBlock();
                if (!(block.getState() instanceof Sign)) continue;
                Sign sign = (Sign)block.getState();
                sign.setLine(0, String.valueOf(ChatColor.BLUE) + region.getName());
                sign.setLine(1, region.isActive() ? "" : "\u00a7cDEAKTIVIERT");
                if (region.isFree()) {
                    String formattedPrice = NumberFormat.getCurrencyInstance(Locale.GERMANY).format(region.getPrice());
                    String formattedUserPrice = NumberFormat.getCurrencyInstance(Locale.GERMANY).format(region.getUserPrice());
                    if (region.isBuyable()) {
                        sign.setLine(3, String.valueOf(ChatColor.GREEN) + "Kaufbar");
                        sign.setLine(2, "\u00a7ePreis: \u00a76" + formattedPrice);
                    } else {
                        sign.setLine(3, String.valueOf(ChatColor.GREEN) + "Mietbar");
                        sign.setLine(2, "\u00a7ePreis: \u00a76" + formattedPrice);
                    }
                    if (region.isUserOffer()) {
                        sign.setLine(2, "\u00a7ePreis: \u00a76" + formattedUserPrice);
                    }
                } else {
                    String ownerName = region.isBuyable() ? Bukkit.getOfflinePlayer((UUID)region.getOwner()).getName() : (region.getCoOwner().equalsIgnoreCase("FL") || region.getCoOwner() == null ? "FL Immobilie" : region.getCoOwner());
                    sign.setLine(2, "\u00a76" + ownerName);
                    sign.setLine(3, "\u00a7cBesetzt");
                }
                sign.update();
            }
        });
    }

    public final void resetRegion(Region region, Player player) {
        if (region == null) {
            player.sendMessage("\u00a7cRegion nicht gefunden.");
            return;
        }
        List<BlockStateData> savedBlocks = region.getSavedBlocks();
        if (savedBlocks == null || savedBlocks.isEmpty()) {
            player.sendMessage("\u00a7cKeine gespeicherten Bl\u00f6cke f\u00fcr die Region '" + region.getName() + "'.");
            return;
        }
        int removedShopCount = 0;
        ArrayList<Location> toRemove = new ArrayList<Location>();
        for (ChestShop shop : ChestShopManager.getAllShops()) {
            Location loc = shop.getChestLocation();
            if (!region.contains(loc)) continue;
            toRemove.add(loc);
        }
        for (Location shopLoc : toRemove) {
            ChestShopManager.removeShop(shopLoc);
            ++removedShopCount;
        }
        ChestShopManager.saveShops();
        player.sendMessage("\u00a7a" + removedShopCount + " Shop(s) wurden aus der Region entfernt.");
        World world = region.getMin().getWorld();
        for (BlockStateData blockData : savedBlocks) {
            blockData.restoreBlock(world);
        }
        player.sendMessage("\u00a72Die Region '" + region.getName() + "' wurde erfolgreich zur\u00fcckgesetzt.");
    }

    public final void startWeeklyTask(final DayOfWeek day, final int hour, final int minute) {
        new BukkitRunnable(){

            public void run() {
                LocalDateTime now = LocalDateTime.now(ZoneId.of("Europe/Berlin"));
                if (now.getDayOfWeek() == day && now.getHour() == hour && now.getMinute() == minute) {
                    for (Region region : RegionManager.this.getAllRegions()) {
                        if (region.isBuyable() || !region.getPlayerWasActive()) continue;
                        region.setPlayerWasActive(false);
                        Player p = Bukkit.getPlayer((String)region.getCoOwner());
                        if (p != null && p.isOnline()) {
                            UserDataManager.removeBalance(p.getUniqueId(), region.getPrice());
                            UserDataManager.logTransactionAsSend(p.getUniqueId(), region.getPrice(), "Miete: " + region.getName(), "FL Immobilien");
                            p.sendMessage("\u00a7eDeine Miete wurde abgebucht: " + region.getPrice() + " \u20ac");
                        }
                        RegionManager.this.saveRegion(region);
                    }
                }
            }
        }.runTaskTimer((Plugin)FutureLeagueWirtschaft.getInstance(), 0L, 1200L);
    }

    public final void setPlayerWasActivePlaying(Player p) {
        for (Region region : this.getAllRegions()) {
            if (!region.getCoOwner().equals(p.getName())) continue;
            region.setPlayerWasActive(true);
            this.saveRegion(region);
        }
    }

    public boolean setSpeedLevel(String regionName, int speedLevel) {
        for (Region region : this.regions.values()) {
            if (!region.getName().equalsIgnoreCase(regionName)) continue;
            region.setSpeedLevel(speedLevel);
            RegionManager.getInstance().saveRegion(region);
            return true;
        }
        return false;
    }

    public void updatePlayerSpeed(Player player) {
        if (this.getRegion(player.getLocation()) == null) {
            player.setWalkSpeed(0.2f);
            return;
        }
        Region region = this.getRegion(player.getLocation());
        int level = region.getSpeedLevel();
        float newSpeed = level <= 1 ? 0.2f : (level == 2 ? 0.4f : (level == 3 ? 0.6f : (level == 4 ? 0.8f : (level == 5 ? 1.0f : 0.2f))));
        player.setWalkSpeed(newSpeed);
    }

    public void resetPlayerSpeed(Player player) {
        player.setWalkSpeed(0.2f);
    }
}

