/*
 * Decompiled with CFR 0.152.
 */
package de.flipper1406.futureleague_wirtschaft.Userdata.Commands;

import de.flipper1406.futureleague_wirtschaft.Userdata.Utils.UserDataManager;
import java.util.List;
import java.util.UUID;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class KontoauszugCommand
implements CommandExecutor {
    private static final int ENTRIES_PER_PAGE = 5;

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!label.equalsIgnoreCase("kontoauszug")) {
            return false;
        }
        Player player = sender instanceof Player ? (Player)sender : null;
        boolean isAdmin = sender.hasPermission("fl.money.admin");
        Player target = player;
        UUID uuid = player != null ? player.getUniqueId() : null;
        int page = 1;
        if (args.length >= 1) {
            if (args[0].matches("\\d+")) {
                page = Integer.parseInt(args[0]);
            } else {
                if (!isAdmin) {
                    sender.sendMessage("\u00a7cDu darfst nur deinen eigenen Kontoauszug sehen.");
                    return true;
                }
                target = Bukkit.getOfflinePlayer((String)args[0]);
                uuid = target.getUniqueId();
                if (args.length >= 2 && args[1].matches("\\d+")) {
                    page = Integer.parseInt(args[1]);
                }
            }
        }
        if (uuid == null) {
            sender.sendMessage("\u00a7cNur Spieler k\u00f6nnen diesen Befehl ohne Ziel ausf\u00fchren.");
            return true;
        }
        List<String> allTransactions = UserDataManager.getLastTransactions(uuid, Integer.MAX_VALUE);
        if (allTransactions.isEmpty()) {
            sender.sendMessage("\u00a77Keine Transaktionen gefunden.");
            return true;
        }
        int totalPages = (int)Math.ceil((double)allTransactions.size() / 5.0);
        if (page < 1 || page > totalPages) {
            sender.sendMessage("\u00a7cUng\u00fcltige Seite. Es gibt insgesamt \u00a7e" + totalPages + " \u00a7cSeiten.");
            return true;
        }
        sender.sendMessage("");
        sender.sendMessage("\u00a76======================");
        sender.sendMessage("\u00a76\u00a7lKontoauszug f\u00fcr \u00a7e" + target.getName() + " \u00a78(Seite " + page + "/" + totalPages + ")");
        double balance = UserDataManager.getBalance(uuid);
        sender.sendMessage(balance > 0.0 ? "\u00a77Aktueller Kontostand: \u00a7a" + String.format("%.2f", balance) + "\u20ac" : "\u00a77Aktueller Kontostand: \u00a7c" + String.format("%.2f", balance) + "\u20ac");
        sender.sendMessage("");
        int startIndex = (page - 1) * 5;
        int endIndex = Math.min(startIndex + 5, allTransactions.size());
        for (int i = startIndex; i < endIndex; ++i) {
            sender.sendMessage(allTransactions.get(i));
        }
        if (sender instanceof Player) {
            Player p = (Player)sender;
            if (page > 1) {
                Object targetPart = "";
                if (isAdmin && !target.getUniqueId().equals(player.getUniqueId())) {
                    targetPart = target.getName() + " ";
                }
                String backCommand = "/kontoauszug " + (String)targetPart + (page - 1);
                TextComponent backButton = new TextComponent("\u00a77\u00ab \u00a7eVorherige Seite ");
                backButton.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, backCommand));
                backButton.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("\u00a77Klicke, um Seite " + (page - 1) + " zu laden.").create()));
                if (page < totalPages) {
                    Object targetPart2 = "";
                    if (isAdmin && !target.getUniqueId().equals(player.getUniqueId())) {
                        targetPart2 = target.getName() + " ";
                    }
                    String nextCommand = "/kontoauszug " + (String)targetPart2 + (page + 1);
                    TextComponent nextButton = new TextComponent("\u00a77\u00bb \u00a7eN\u00e4chste Seite");
                    nextButton.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, nextCommand));
                    nextButton.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("\u00a77Klicke, um Seite " + (page + 1) + " zu laden.").create()));
                    backButton.addExtra((BaseComponent)new TextComponent(" \u00a78| "));
                    backButton.addExtra((BaseComponent)nextButton);
                    p.spigot().sendMessage((BaseComponent)backButton);
                } else {
                    p.spigot().sendMessage((BaseComponent)backButton);
                }
            } else if (page < totalPages) {
                Object targetPart = "";
                if (isAdmin && !target.getUniqueId().equals(player.getUniqueId())) {
                    targetPart = target.getName() + " ";
                }
                String nextCommand = "/kontoauszug " + (String)targetPart + (page + 1);
                TextComponent nextButton = new TextComponent("\u00a77\u00bb \u00a7eN\u00e4chste Seite");
                nextButton.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, nextCommand));
                nextButton.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("\u00a77Klicke, um Seite " + (page + 1) + " zu laden.").create()));
                p.spigot().sendMessage((BaseComponent)nextButton);
            }
        }
        sender.sendMessage("\u00a76======================");
        return true;
    }
}

