/*
 * Decompiled with CFR 0.152.
 */
package de.flipper1406.futureleague_wirtschaft.Events;

import de.flipper1406.futureleague_wirtschaft.ConfigManager.ConfigFileConfig;
import de.flipper1406.futureleague_wirtschaft.FutureLeagueWirtschaft;
import io.papermc.paper.event.player.PlayerTradeEvent;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.player.PlayerInteractEvent;

public class PlayerMineEvents
implements Listener {
    private static final int SPAWN_PROTECTION_AREA = 50;
    private final ConfigFileConfig configFileConfig;

    public PlayerMineEvents(FutureLeagueWirtschaft wirtschaftsPlugin) {
        this.configFileConfig = wirtschaftsPlugin.getConfigFileConfig();
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        Player player = event.getPlayer();
        Location mineSpawnLoc = this.configFileConfig.getLocation("minespawn");
        if (mineSpawnLoc == null) {
            player.sendMessage("\u00a7cFehler: Der Minen-Spawnpunkt ist nicht gesetzt.");
            return;
        }
        Location blockLoc = event.getBlock().getLocation();
        if (!blockLoc.getWorld().equals((Object)mineSpawnLoc.getWorld())) {
            return;
        }
        double distance = blockLoc.distance(mineSpawnLoc);
        if (distance <= 50.0) {
            event.setCancelled(true);
            player.sendMessage("\u00a7cDu darfst in der N\u00e4he des Minen-Spawnpunkts keine Bl\u00f6cke abbauen (im Umkreis von 50 Bl\u00f6cken).");
        }
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        Action action = event.getAction();
        if ((action == Action.RIGHT_CLICK_AIR || action == Action.RIGHT_CLICK_BLOCK) && event.getItem() != null && event.getItem().getType().isEdible()) {
            return;
        }
        Location mineSpawnLoc = this.configFileConfig.getLocation("minespawn");
        if (mineSpawnLoc == null) {
            return;
        }
        Location playerLoc = event.getPlayer().getLocation();
        if (!playerLoc.getWorld().equals((Object)mineSpawnLoc.getWorld())) {
            return;
        }
        if (playerLoc.distance(mineSpawnLoc) <= 50.0) {
            event.setCancelled(true);
            event.getPlayer().sendMessage("\u00a7cDu darfst hier nicht interagieren (Radius 50 um Minen-Spawn).");
        }
    }

    @EventHandler
    public void onBlockPlace(BlockPlaceEvent event) {
        Location mineSpawnLoc = this.configFileConfig.getLocation("minespawn");
        if (mineSpawnLoc == null) {
            return;
        }
        Location blockLoc = event.getBlock().getLocation();
        if (!blockLoc.getWorld().equals((Object)mineSpawnLoc.getWorld())) {
            return;
        }
        if (blockLoc.distance(mineSpawnLoc) <= 50.0) {
            event.setCancelled(true);
            event.getPlayer().sendMessage("\u00a7cDu darfst hier keine Bl\u00f6cke platzieren (Radius 50 um Minen-Spawn).");
        }
    }

    @EventHandler
    public void onCreeperExplode(EntityExplodeEvent event) {
        if (!(event.getEntity() instanceof Creeper)) {
            return;
        }
        Location mineSpawnLoc = this.configFileConfig.getLocation("minespawn");
        if (mineSpawnLoc == null) {
            return;
        }
        Location explosionLoc = event.getLocation();
        if (!explosionLoc.getWorld().equals((Object)mineSpawnLoc.getWorld())) {
            return;
        }
        if (explosionLoc.distance(mineSpawnLoc) <= 50.0) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerTrade(PlayerTradeEvent event) {
        World mineWorld = this.configFileConfig.getLocation("minespawn").getWorld();
        if (event.getPlayer().getWorld() == mineWorld) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerMobKill(EntityDeathEvent event) {
        World mineWorld = this.configFileConfig.getLocation("minespawn").getWorld();
        if (mineWorld != event.getEntity().getWorld()) {
            return;
        }
        if (event.getEntity().fromMobSpawner()) {
            event.setDroppedExp(0);
            event.getDrops().clear();
        }
    }
}

