/*
 * Decompiled with CFR 0.152.
 */
package de.flipper1406.futureleague_wirtschaft.Permissions;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.plugin.java.JavaPlugin;

public class DatabaseManager {
    private final JavaPlugin plugin;
    private final String host;
    private final int port;
    private final int fallbackPort = 3306;
    private final String database;
    private final String username;
    private final String password;
    private final int firstParameter = 1;
    private final int seccondParameter = 2;
    private final int thirdParameter = 3;
    private final int fourthParameter = 4;

    public DatabaseManager(JavaPlugin wirtschaftsPlugin) {
        this.plugin = wirtschaftsPlugin;
        this.host = wirtschaftsPlugin.getConfig().getString("database.host", "localhost");
        this.port = wirtschaftsPlugin.getConfig().getInt("database.port", 3306);
        this.database = wirtschaftsPlugin.getConfig().getString("database.db", "minecraft");
        this.username = wirtschaftsPlugin.getConfig().getString("database.user", "root");
        this.password = wirtschaftsPlugin.getConfig().getString("database.password", "");
    }

    public Connection getConnection() throws SQLException {
        String url = "jdbc:mysql://" + this.host + ":" + this.port + "/" + this.database + "?useSSL=false&serverTimezone=UTC";
        return DriverManager.getConnection(url, this.username, this.password);
    }

    public void logChat(UUID playerUUID, String message, String server) {
        OfflinePlayer player = Bukkit.getOfflinePlayer((UUID)playerUUID);
        String playerUsername = player.getName() != null ? player.getName() : "UNKNOWN";
        String sql = "INSERT INTO chatLog (username, userUUID, message, server)\nVALUES (?, ?, ?, ?)\n";
        try (Connection conn = this.getConnection();
             PreparedStatement stmt = conn.prepareStatement(sql);){
            stmt.setString(1, playerUsername);
            stmt.setString(2, playerUUID.toString());
            stmt.setString(3, message);
            stmt.setString(4, server);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

