/*
 * Decompiled with CFR 0.152.
 */
package de.flipper1406.futureleague_wirtschaft.Regions;

import de.flipper1406.futureleague_wirtschaft.FutureLeagueWirtschaft;
import de.flipper1406.futureleague_wirtschaft.Regions.Region;
import de.flipper1406.futureleague_wirtschaft.Regions.RegionGUI;
import de.flipper1406.futureleague_wirtschaft.Regions.RegionManager;
import de.flipper1406.futureleague_wirtschaft.Regions.RegionPurchaseGUI;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockDropItemEvent;
import org.bukkit.event.block.BlockPhysicsEvent;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.entity.ItemSpawnEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.plugin.Plugin;

public class RegionSignListener
implements Listener {
    private final String currency = " Euro";
    private final double nearDistance = 1.5;
    private final int lineRegionName = 0;
    private final int lineEmpty = 1;
    private final int lineRegionPrice = 2;
    private final int lineRegionOwner = 2;
    private final int lineRegionType = 3;
    private final int lineRegionFreestatus = 3;

    @EventHandler
    public void onSignClick(PlayerInteractEvent event) {
        if (event.getHand() != EquipmentSlot.HAND) {
            return;
        }
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK && event.getAction() != Action.LEFT_CLICK_BLOCK) {
            return;
        }
        Block block = event.getClickedBlock();
        if (block == null || !(block.getState() instanceof Sign)) {
            return;
        }
        Location signLocation = block.getLocation();
        Region region = null;
        for (Region r : RegionManager.getInstance().getAllRegions()) {
            for (Location registeredSign : r.getSigns()) {
                if (!registeredSign.equals((Object)signLocation)) continue;
                region = r;
                break;
            }
            if (region == null) continue;
            break;
        }
        if (region == null) {
            return;
        }
        event.setCancelled(true);
        Player player = event.getPlayer();
        if (event.getAction() == Action.LEFT_CLICK_BLOCK) {
            this.sendRegionInfo(player, region);
            event.setCancelled(true);
            return;
        }
        if (event.getAction() == Action.RIGHT_CLICK_BLOCK) {
            if (region.isFree() && region.isActive()) {
                if (player.getUniqueId().equals(region.getOwner()) || player.getName().equals(region.getCoOwner())) {
                    RegionGUI.open(player, region);
                } else {
                    RegionPurchaseGUI.open(player, region);
                }
            } else if (player.getUniqueId().equals(region.getOwner()) || player.getName().equals(region.getCoOwner()) || player.hasPermission("region.admin")) {
                RegionGUI.open(player, region);
            } else {
                player.sendMessage("\u00a7cDiese Region ist im Besitz von: \u00a7l" + Bukkit.getOfflinePlayer((UUID)region.getOwner()).getName());
                this.sendRegionInfo(player, region);
            }
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onBlockPhysics(BlockPhysicsEvent event) {
        Block changedBlock = event.getBlock();
        if (changedBlock.getType().toString().contains("SIGN") && this.signIsRegionSign(changedBlock)) {
            event.setCancelled(true);
            Material originalMaterial = changedBlock.getType();
            BlockData originalData = changedBlock.getBlockData();
            BlockState originalState = changedBlock.getState();
            String[] originalLines = (String[])((Sign)originalState).getLines().clone();
            Bukkit.getScheduler().runTaskLater((Plugin)FutureLeagueWirtschaft.getInstance(), () -> {
                changedBlock.setType(originalMaterial, false);
                changedBlock.setBlockData(originalData, false);
                if (changedBlock.getState() instanceof Sign) {
                    Sign sign = (Sign)changedBlock.getState();
                    for (int i = 0; i < originalLines.length; ++i) {
                        sign.setLine(i, originalLines[i]);
                    }
                    sign.update(true, false);
                }
            }, 1L);
        }
    }

    private boolean signIsRegionSign(Block block) {
        boolean returnValue = false;
        Location loc = block.getLocation();
        Collection<Region> regions = RegionManager.getInstance().getAllRegions();
        for (Region region : regions) {
            List<Location> signs = region.getSigns();
            for (Location signLocation : signs) {
                if (!signLocation.getBlock().getLocation().equals((Object)loc)) continue;
                returnValue = true;
            }
        }
        return returnValue;
    }

    @EventHandler
    public void onBlockDrop(BlockDropItemEvent event) {
        Block block = event.getBlock();
        if (block.getType().toString().contains("SIGN") && this.signIsRegionSign(block)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onItemSpawn(ItemSpawnEvent event) {
        Item item = event.getEntity();
        if (item.getItemStack().getType().toString().contains("SIGN")) {
            Location loc = item.getLocation();
            for (Region region : RegionManager.getInstance().getAllRegions()) {
                for (Location signLoc : region.getSigns()) {
                    if (!signLoc.getWorld().equals((Object)loc.getWorld()) || !(signLoc.distance(loc) < 1.5)) continue;
                    event.setCancelled(true);
                    return;
                }
            }
        }
    }

    @EventHandler
    public void onSignPlace(SignChangeEvent event) {
        Player player = event.getPlayer();
        if (!player.hasPermission("fl.regions.admin")) {
            return;
        }
        String line0 = event.getLine(0);
        if (!"[Region]".equalsIgnoreCase(line0)) {
            return;
        }
        String regionName = event.getLine(1);
        Region region = RegionManager.getInstance().getRegion(regionName);
        if (region == null) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Region nicht gefunden!");
            return;
        }
        double price = region.getPrice();
        String formattedPrice = NumberFormat.getCurrencyInstance(Locale.GERMANY).format(price);
        double userPrice = region.getPrice();
        String formattedUserPrice = NumberFormat.getCurrencyInstance(Locale.GERMANY).format(userPrice);
        event.setLine(0, String.valueOf(ChatColor.YELLOW) + region.getName());
        event.setLine(1, "");
        if (region.isFree()) {
            if (region.isUserOffer()) {
                event.setLine(2, String.valueOf(ChatColor.DARK_AQUA) + formattedUserPrice + " \u20ac");
            } else {
                event.setLine(2, String.valueOf(ChatColor.DARK_AQUA) + formattedPrice + " \u20ac");
            }
        } else {
            event.setLine(2, "\u00a72" + Bukkit.getPlayer((UUID)region.getOwner()).getName());
        }
        event.setLine(3, region.isFree() ? "\u00a7a- frei -" : "\u00a7c- belegt -");
        region.addSign(event.getBlock().getLocation());
        RegionManager.getInstance().saveRegion(region);
    }

    private void sendRegionInfo(Player p, Region region) {
        double price = region.getPrice();
        String formattedPrice = NumberFormat.getCurrencyInstance(Locale.GERMANY).format(price);
        double userPrice = region.getPrice();
        String formattedUserPrice = NumberFormat.getCurrencyInstance(Locale.GERMANY).format(userPrice);
        if (region.isUserOffer()) {
            p.sendMessage(String.valueOf(ChatColor.GRAY) + "=== Region: " + String.valueOf(ChatColor.GOLD) + region.getName() + String.valueOf(ChatColor.GRAY) + " ===");
            p.sendMessage(String.valueOf(ChatColor.YELLOW) + "Besitzer: " + String.valueOf(ChatColor.WHITE) + Bukkit.getOfflinePlayer((UUID)region.getOwner()).getName());
            p.sendMessage(String.valueOf(ChatColor.YELLOW) + "Preis: " + String.valueOf(ChatColor.WHITE) + formattedPrice + " Euro");
            p.sendMessage(String.valueOf(ChatColor.YELLOW) + "Angebotspreis des Spielers: " + String.valueOf(ChatColor.WHITE) + formattedUserPrice + " Euro");
            String regionType = region.isRentable() ? String.valueOf(ChatColor.GREEN) + "Miete" : String.valueOf(ChatColor.AQUA) + "Kauf";
            p.sendMessage(String.valueOf(ChatColor.YELLOW) + "Art: " + regionType);
            p.sendMessage(String.valueOf(ChatColor.YELLOW) + "Y-Min: " + String.valueOf(ChatColor.WHITE) + region.getMinY() + " || \u00a7eY-Max: \u00a7f" + region.getMaxY());
        } else if (region.isFree()) {
            p.sendMessage(String.valueOf(ChatColor.GRAY) + "=== Region: " + String.valueOf(ChatColor.GOLD) + region.getName() + String.valueOf(ChatColor.GRAY) + " ===");
            p.sendMessage(String.valueOf(ChatColor.YELLOW) + "Besitzer: " + String.valueOf(ChatColor.WHITE) + "frei");
            p.sendMessage(String.valueOf(ChatColor.YELLOW) + "Preis: " + String.valueOf(ChatColor.WHITE) + formattedPrice);
            String regionType = region.isRentable() ? String.valueOf(ChatColor.GREEN) + "Miete" : String.valueOf(ChatColor.AQUA) + "Kauf";
            p.sendMessage(String.valueOf(ChatColor.YELLOW) + "Art: " + regionType);
            p.sendMessage(String.valueOf(ChatColor.YELLOW) + "Y-Min: " + String.valueOf(ChatColor.WHITE) + region.getMinY() + " || \u00a7eY-Max: \u00a7f" + region.getMaxY());
        } else if (region.isBuyable()) {
            p.sendMessage(String.valueOf(ChatColor.GRAY) + "=== Region: " + String.valueOf(ChatColor.GOLD) + region.getName() + String.valueOf(ChatColor.GRAY) + " ===");
            p.sendMessage(String.valueOf(ChatColor.YELLOW) + "Besitzer: " + String.valueOf(ChatColor.WHITE) + Bukkit.getOfflinePlayer((UUID)region.getOwner()).getName());
            p.sendMessage(String.valueOf(ChatColor.YELLOW) + "Preis: " + String.valueOf(ChatColor.WHITE) + formattedPrice);
            String regionType = region.isRentable() ? String.valueOf(ChatColor.GREEN) + "Miete" : String.valueOf(ChatColor.AQUA) + "Kauf";
            p.sendMessage(String.valueOf(ChatColor.YELLOW) + "Art: " + regionType);
            p.sendMessage(String.valueOf(ChatColor.YELLOW) + "Y-Min: " + String.valueOf(ChatColor.WHITE) + region.getMinY() + " || \u00a7eY-Max: \u00a7f" + region.getMaxY());
        } else {
            p.sendMessage(String.valueOf(ChatColor.GRAY) + "=== Region: " + String.valueOf(ChatColor.GOLD) + region.getName() + String.valueOf(ChatColor.GRAY) + " ===");
            p.sendMessage(String.valueOf(ChatColor.YELLOW) + "Besitzer: " + String.valueOf(ChatColor.WHITE) + Bukkit.getOfflinePlayer((String)region.getCoOwner()).getName());
            p.sendMessage(String.valueOf(ChatColor.YELLOW) + "Preis: " + String.valueOf(ChatColor.WHITE) + formattedPrice);
            String regionType = region.isRentable() ? String.valueOf(ChatColor.GREEN) + "Miete" : String.valueOf(ChatColor.AQUA) + "Kauf";
            p.sendMessage(String.valueOf(ChatColor.YELLOW) + "Art: " + regionType);
            p.sendMessage(String.valueOf(ChatColor.YELLOW) + "Y-Min: " + String.valueOf(ChatColor.WHITE) + region.getMinY() + " || \u00a7eY-Max: \u00a7f" + region.getMaxY());
        }
    }
}

