/*
 * Decompiled with CFR 0.152.
 */
package de.flipper1406.futureleague_wirtschaft.Userdata.Commands;

import de.flipper1406.futureleague_wirtschaft.Userdata.Utils.UserDataManager;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class PayCommand
implements CommandExecutor {
    private static final double TAX_PERCENTAGE = 0.03;
    private static final Map<UUID, PendingPayment> PENDING_PAYMENTS = new HashMap<UUID, PendingPayment>();
    private final String currency = " Euro";

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        double amount;
        if (!(sender instanceof Player)) {
            sender.sendMessage("Nur Spieler k\u00f6nnen diesen Befehl ausf\u00fchren.");
            return true;
        }
        Player senderPlayer = (Player)sender;
        if (args.length == 1 && (args[0].equalsIgnoreCase("confirm") || args[0].equalsIgnoreCase("best\u00e4tigen"))) {
            PendingPayment payment = PENDING_PAYMENTS.remove(senderPlayer.getUniqueId());
            if (payment == null) {
                senderPlayer.sendMessage("\u00a7cDu hast keine ausstehende Zahlung zum Best\u00e4tigen.");
                return true;
            }
            double senderBalance = UserDataManager.getBalance(senderPlayer.getUniqueId());
            if (senderBalance < payment.totalCost()) {
                senderPlayer.sendMessage("\u00a7cDu hast nicht genug  Euro. Ben\u00f6tigt: " + payment.totalCost() + " (inkl. 3% Geb\u00fchr)");
                return true;
            }
            UserDataManager.setBalance(senderPlayer.getUniqueId(), senderBalance - payment.totalCost());
            double receiverBalance = UserDataManager.getBalance(payment.targetUUID);
            UserDataManager.setBalance(payment.targetUUID, receiverBalance + payment.amount);
            UserDataManager.logTransactionAsSend(senderPlayer.getUniqueId(), payment.tax(), "Bankgeb\u00fchren", "FL Banking AG");
            UserDataManager.logTransaction(payment.targetUUID, senderPlayer.getUniqueId(), payment.amount, "\u00dcberweisung");
            senderPlayer.sendMessage("\u00a7aDu hast \u00a7e" + payment.amount + " Euro \u00a7aan \u00a7b" + payment.targetName + " \u00a7agesendet. (\u00a77Geb\u00fchr: " + payment.tax() + " Euro)");
            return true;
        }
        if (args.length < 2) {
            senderPlayer.sendMessage("\u00a7cBenutzung: /pay <Spieler> <Betrag>");
            return true;
        }
        String targetName = args[0];
        Player targetPlayer = Bukkit.getPlayerExact((String)targetName);
        OfflinePlayer targetOfflinePlayer = Bukkit.getOfflinePlayer((String)targetName);
        if (targetPlayer == null && !targetOfflinePlayer.hasPlayedBefore() || targetOfflinePlayer.getUniqueId().equals(senderPlayer.getUniqueId())) {
            senderPlayer.sendMessage("\u00a7cUng\u00fcltiger Spieler.");
            return true;
        }
        try {
            amount = Double.parseDouble(args[1]);
        }
        catch (NumberFormatException e) {
            senderPlayer.sendMessage("\u00a7cUng\u00fcltiger Betrag.");
            return true;
        }
        if (amount <= 0.0) {
            senderPlayer.sendMessage("\u00a7cDer Betrag muss positiv sein.");
            return true;
        }
        double tax = amount * 0.03;
        double totalCost = amount + tax;
        double senderBalance = UserDataManager.getBalance(senderPlayer.getUniqueId());
        if (senderBalance < totalCost) {
            senderPlayer.sendMessage("\u00a7cDu hast nicht genug  Euro. Ben\u00f6tigt: " + totalCost + " (inkl. 3% Geb\u00fchr)");
            return true;
        }
        if (targetOfflinePlayer.isOnline()) {
            targetPlayer = (Player)targetOfflinePlayer;
            UserDataManager.setBalance(senderPlayer.getUniqueId(), senderBalance - totalCost);
            UserDataManager.setBalance(targetPlayer.getUniqueId(), UserDataManager.getBalance(targetPlayer.getUniqueId()) + amount);
            UserDataManager.logTransactionAsSend(senderPlayer.getUniqueId(), tax, "Bankgeb\u00fchren", "FL Banking AG");
            UserDataManager.logTransaction(targetPlayer.getUniqueId(), senderPlayer.getUniqueId(), amount, "\u00dcberweisung");
            senderPlayer.sendMessage("\u00a7aDu hast \u00a7e" + amount + " Euro \u00a7aan \u00a7b" + targetPlayer.getName() + " \u00a7agesendet. (\u00a77Geb\u00fchr: " + tax + " Euro)");
            targetPlayer.sendMessage("\u00a7aDu hast \u00a7e" + amount + " Euro" + senderPlayer.getName() + " \u00a7aerhalten.");
        } else {
            PENDING_PAYMENTS.put(senderPlayer.getUniqueId(), new PendingPayment(targetOfflinePlayer.getUniqueId(), targetOfflinePlayer.getName(), amount));
            senderPlayer.sendMessage("\u00a7eDer Spieler ist offline. Best\u00e4tige die \u00dcberweisung mit \u00a7a/pay confirm\u00a7e, um \u00a7e" + amount + " Euro \u00a7aan \u00a7b" + targetOfflinePlayer.getName() + " \u00a7ezusenden.");
            senderPlayer.sendMessage("\u00a77Geb\u00fchr: " + tax + " Euro, Gesamt: " + totalCost + " Euro");
        }
        return true;
    }

    private static class PendingPayment {
        private UUID targetUUID;
        private String targetName;
        private double amount;

        PendingPayment(UUID paymentUuid, String paymentName, double paymentAmount) {
            this.targetUUID = paymentUuid;
            this.targetName = paymentName;
            this.amount = paymentAmount;
        }

        double tax() {
            return this.amount * 0.03;
        }

        double totalCost() {
            return this.amount + this.tax();
        }
    }
}

