/*
 * Decompiled with CFR 0.152.
 */
package de.flipper1406.notifier;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.api.scheduler.ScheduledTask;
import net.md_5.bungee.config.Configuration;

public final class Notifier
extends Plugin {
    private ScheduledTask pingTask;
    private Configuration config;
    private File configFile;
    private final Set<String> offlineServers = ConcurrentHashMap.newKeySet();
    private String phoneNumberId;
    private String accessToken;
    private String toNumber;
    private int checkIntervalSeconds;
    private int messagesSent = 0;
    private int maxCounterValue = 900;
    private static final String CONFIG_FILE = "config.yml";

    public void onEnable() {
        this.getLogger().info("Notifier Plugin aktiviert!");
        this.loadConfig();
        this.checkReset();
        this.pingTask = ProxyServer.getInstance().getScheduler().schedule((Plugin)this, this::checkServers, 0L, (long)this.checkIntervalSeconds, TimeUnit.SECONDS);
    }

    public void onDisable() {
        if (this.pingTask != null) {
            this.pingTask.cancel();
        }
        this.saveConfigCounter();
    }

    private void checkServers() {
        LocalTime now = LocalTime.now();
        LocalTime start = LocalTime.of(4, 0);
        LocalTime end = LocalTime.of(4, 15);
        if (!now.isBefore(start) && now.isBefore(end)) {
            return;
        }
        for (Map.Entry entry : ProxyServer.getInstance().getServers().entrySet()) {
            String name = (String)entry.getKey();
            ServerInfo server = (ServerInfo)entry.getValue();
            server.ping((result, error) -> {
                if (error != null) {
                    if (!this.offlineServers.contains(name)) {
                        this.offlineServers.add(name);
                        this.getLogger().warning("\u274c Server '" + name + "' ist NICHT erreichbar!");
                        this.sendWhatsApp("\u274c Minecraft-Server '" + name + "' ist NICHT erreichbar!");
                    }
                } else if (this.offlineServers.contains(name)) {
                    this.offlineServers.remove(name);
                    this.getLogger().info("\u2705 Server '" + name + "' ist wieder online.");
                    this.sendWhatsApp("\u2705 Minecraft-Server '" + name + "' ist wieder online.");
                }
            });
        }
    }

    private void sendWhatsApp(String message) {
        if (this.phoneNumberId == null || this.accessToken == null || this.toNumber == null) {
            this.getLogger().warning("\u274c WhatsApp-Daten sind nicht korrekt in der config.yml eingetragen!");
            return;
        }
        if (this.messagesSent >= this.maxCounterValue) {
            this.getLogger().warning("\ud83d\udeab Maximalanzahl an WhatsApp-Nachrichten erreicht (" + this.maxCounterValue + "). Kein Versand mehr in diesem Monat.");
            return;
        }
        ProxyServer.getInstance().getScheduler().runAsync((Plugin)this, () -> {
            try {
                String apiUrl = "https://graph.facebook.com/v19.0/" + this.phoneNumberId + "/messages";
                URL url = new URL(apiUrl);
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("POST");
                conn.setRequestProperty("Authorization", "Bearer " + this.accessToken);
                conn.setRequestProperty("Content-Type", "application/json");
                conn.setDoOutput(true);
                String payload = "{\"messaging_product\": \"whatsapp\",\"to\": \"" + this.toNumber + "\",\"type\": \"text\",\"text\": {\"body\": \"" + message + "\"}}";
                try (OutputStream os = conn.getOutputStream();){
                    os.write(payload.getBytes(StandardCharsets.UTF_8));
                }
                int responseCode = conn.getResponseCode();
                if (responseCode == 200) {
                    ++this.messagesSent;
                    this.saveConfigCounter();
                    this.getLogger().info("\ud83d\udcf1 WhatsApp-Nachricht gesendet: " + message);
                } else {
                    this.getLogger().warning("\u26a0\ufe0f Fehler beim WhatsApp-Versand (HTTP " + responseCode + ")");
                }
            }
            catch (IOException e) {
                this.getLogger().warning("\u26a0\ufe0f Fehler beim WhatsApp-Versand: " + e.getMessage());
            }
        });
    }

    private void loadConfig() {
        this.configFile = new File(this.getDataFolder(), CONFIG_FILE);
        if (!this.configFile.exists()) {
            if (!this.getDataFolder().exists() && !this.getDataFolder().mkdirs()) {
                this.getLogger().warning("Konnte Plugin-Ordner nicht erstellen!");
                return;
            }
            try (PrintWriter writer = new PrintWriter(new FileWriter(this.configFile));){
                writer.println("whatsapp:");
                writer.println("  phone_number_id: \"DEINE_PHONE_NUMBER_ID\"");
                writer.println("  access_token: \"DEIN_ACCESS_TOKEN\"");
                writer.println("  to_number: \"4915123456789\"");
                writer.println("check_interval_seconds: 30");
                writer.println("maxCounterValue: 900");
                writer.println("messagesSent: 0");
                writer.println("lastResetMonth: 0");
                this.getLogger().info("\ud83d\udcc4 config.yml wurde erstellt! Bitte trage deine Daten ein und starte den Server neu.");
            }
            catch (IOException e) {
                this.getLogger().severe("Fehler beim Erstellen der config.yml: " + e.getMessage());
            }
            return;
        }
        try (BufferedReader reader = new BufferedReader(new FileReader(this.configFile));){
            String line;
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).startsWith("phone_number_id:")) {
                    this.phoneNumberId = line.split(":")[1].trim().replace("\"", "");
                    continue;
                }
                if (line.startsWith("access_token:")) {
                    this.accessToken = line.split(":")[1].trim().replace("\"", "");
                    continue;
                }
                if (line.startsWith("to_number:")) {
                    this.toNumber = line.split(":")[1].trim().replace("\"", "");
                    continue;
                }
                if (line.startsWith("check_interval_seconds:")) {
                    try {
                        this.checkIntervalSeconds = Integer.parseInt(line.split(":")[1].trim());
                    }
                    catch (NumberFormatException e) {
                        this.checkIntervalSeconds = 30;
                    }
                    continue;
                }
                if (line.startsWith("maxCounterValue:")) {
                    try {
                        this.maxCounterValue = Integer.parseInt(line.split(":")[1].trim());
                    }
                    catch (NumberFormatException e) {
                        this.maxCounterValue = 900;
                    }
                    continue;
                }
                if (!line.startsWith("messagesSent:")) continue;
                try {
                    this.messagesSent = Integer.parseInt(line.split(":")[1].trim());
                }
                catch (NumberFormatException e) {
                    this.messagesSent = 0;
                }
            }
        }
        catch (IOException e) {
            this.getLogger().severe("Fehler beim Laden der config.yml: " + e.getMessage());
        }
        if (this.checkIntervalSeconds <= 0) {
            this.checkIntervalSeconds = 30;
        }
    }

    private void saveConfigCounter() {
        if (!this.configFile.exists()) {
            return;
        }
        try {
            StringBuilder sb = new StringBuilder();
            try (BufferedReader reader = new BufferedReader(new FileReader(this.configFile));){
                String line;
                while ((line = reader.readLine()) != null) {
                    if (line.trim().startsWith("messagesSent:")) {
                        sb.append("messagesSent: ").append(this.messagesSent).append(System.lineSeparator());
                        continue;
                    }
                    sb.append(line).append(System.lineSeparator());
                }
            }
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(this.configFile));){
                writer.write(sb.toString());
            }
        }
        catch (IOException e) {
            this.getLogger().warning("Fehler beim Speichern des Counters: " + e.getMessage());
        }
    }

    private void checkReset() {
        int lastMonth = 0;
        try (BufferedReader reader2 = new BufferedReader(new FileReader(this.configFile));){
            String line;
            while ((line = reader2.readLine()) != null) {
                if (!(line = line.trim()).startsWith("lastResetMonth:")) continue;
                lastMonth = Integer.parseInt(line.split(":")[1].trim());
            }
        }
        catch (IOException reader2) {
            // empty catch block
        }
        int currentMonth = LocalDate.now().getMonthValue();
        if (lastMonth != currentMonth) {
            this.messagesSent = 0;
            try {
                StringBuilder sb = new StringBuilder();
                try (BufferedReader reader = new BufferedReader(new FileReader(this.configFile));){
                    String line;
                    while ((line = reader.readLine()) != null) {
                        if (line.trim().startsWith("messagesSent:")) {
                            sb.append("messagesSent: 0").append(System.lineSeparator());
                            continue;
                        }
                        if (line.trim().startsWith("lastResetMonth:")) {
                            sb.append("lastResetMonth: ").append(currentMonth).append(System.lineSeparator());
                            continue;
                        }
                        sb.append(line).append(System.lineSeparator());
                    }
                }
                try (BufferedWriter writer = new BufferedWriter(new FileWriter(this.configFile));){
                    writer.write(sb.toString());
                }
            }
            catch (IOException e) {
                this.getLogger().warning("Fehler beim Zur\u00fccksetzen des Monats-Counters: " + e.getMessage());
            }
            this.getLogger().info("Monatlicher Nachrichten-Counter zur\u00fcckgesetzt!");
        }
    }
}

