/*
 * Decompiled with CFR 0.152.
 */
package de.flipper1406.warpplugin;

import de.flipper1406.warpplugin.WarpPlugin;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class WarpGUIListener
implements Listener {
    private static final int NUMBER_OF_TICKS_FOR_A_SECCOND = 20;
    private static final int AMPLIFIER_BLINDNESS_EFFECT = 20;
    private static final double BUS_INNEN_X = -96.5;
    private static final double BUS_INNEN_Y = 101.0;
    private static final double BUS_INNEN_Z = -277.5;
    private static final float BUS_INNEN_YAW = -90.0f;
    private static final float BUS_INNEN_PITCH = 0.0f;
    private static final int DELAYED_TICKS = 5;
    private static final double UBAHN_INNEN_X = 384.5;
    private static final double UBAHN_INNEN_Y = 82.0;
    private static final double UBAHN_INNEN_Z = -861.5;
    private static final float UBAHN_INNEN_YAW = 90.0f;
    private static final float UBAHN_INNEN_PITCH = 0.0f;
    private static final long SHORT_DELAY_IN_TICKS = 4L;
    private static final long DURATION_UBAHN_DRIVE = 10L;
    private static final int DURATION_BLINDNESS_EFFECT = 60;
    private final WarpPlugin plugin;

    public WarpGUIListener(WarpPlugin pluginInstance) {
        this.plugin = pluginInstance;
    }

    @EventHandler
    public final void onInventoryClick(InventoryClickEvent event) {
        if (!event.getView().getTitle().startsWith("Zielauswahl")) {
            return;
        }
        event.setCancelled(true);
        ItemStack clickedItem = event.getCurrentItem();
        if (clickedItem == null || clickedItem.getType() != Material.PAPER) {
            return;
        }
        ItemMeta meta = clickedItem.getItemMeta();
        if (meta == null || !meta.hasDisplayName()) {
            return;
        }
        String warpName = ChatColor.stripColor((String)meta.getDisplayName());
        String warpType = this.plugin.getConfig().getString("warps." + warpName + ".type");
        if (warpType == null) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        player.closeInventory();
        Location warpLocation = this.plugin.getWarpLocation(warpName);
        if (warpLocation == null) {
            player.sendMessage("\u00a7cWarp '" + warpName + "' konnte nicht gefunden werden.");
            return;
        }
        if ("ubahn".equals(warpType)) {
            this.handleUbahnTeleport(player, warpLocation);
        } else if ("bus".equals(warpType)) {
            this.handleBusTeleport(player, warpLocation);
        }
    }

    public final void handleUbahnTeleport(Player target, Location warpLocation) {
        World tempWorld = Bukkit.getWorld((String)"city");
        Location tempLoc = new Location(tempWorld, 384.5, 82.0, -861.5, 90.0f, 0.0f);
        target.teleport(tempLoc);
        this.delayedBlindnessEffect(target);
        this.delayedTeleport(target, warpLocation, 10L);
    }

    public final void handleBusTeleport(Player target, Location warpLocation) {
        World tempWorld = Bukkit.getWorld((String)"city");
        Location tempLoc = new Location(tempWorld, -96.5, 101.0, -277.5, -90.0f, 0.0f);
        target.teleport(tempLoc);
        this.delayedBlindnessEffect(target);
        this.delayedTeleport(target, warpLocation, 20L);
    }

    public final void delayedBlindnessEffect(final Player target) {
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                int duration = 60;
                int amplifier = 20;
                target.addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, duration, amplifier));
            }
        }, 5L);
    }

    public final void delayedTeleport(final Player target, final Location warpLocation, Long duration) {
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                target.teleport(warpLocation);
            }
        }, 20L * duration);
        target.sendMessage("\u00a72Du bist auf dem Weg zu deiner Zielstation. In wenigen Augenblicken wird diese erreicht!");
    }
}

