/*
 * Decompiled with CFR 0.152.
 */
package de.flipper1406.warpplugin;

import de.flipper1406.warpplugin.WarpGUIListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class WarpPlugin
extends JavaPlugin {
    private static final double UBAHN_INNEN_X = -3966.0;
    private static final double UBAHN_INNEN_Y = 72.0;
    private static final double UBAHN_INNEN_Z = -2903.0;
    private static final float UBAHN_INNEN_YAW = -179.5f;
    private static final float UBAHN_INNEN_PITCH = 4.1f;
    private static final int DURATION_BLINDNESS_EFFECT = 60;
    private static final int AMPLIFIER_BLINDNESS_EFFECT = 20;
    private static final int SLOTS_PER_ROW = 9;
    private static final int DELAYED_TICKS = 5;
    private static final int NUMBER_OF_TICKS_FOR_A_SECCOND = 20;
    private static final int TIME_TO_TELEPORT = 15;

    public final void onEnable() {
        File configFile;
        if (!this.getDataFolder().exists()) {
            this.getDataFolder().mkdirs();
        }
        if (!(configFile = new File(this.getDataFolder(), "config.yml")).exists()) {
            this.getLogger().info("Erstelle Standard-Konfigurationsdatei...");
            this.saveDefaultConfig();
        } else {
            this.getLogger().info("Lade vorhandene Konfigurationsdatei...");
        }
        this.getServer().getPluginManager().registerEvents((Listener)new WarpGUIListener(this), (Plugin)this);
        this.getLogger().info("WarpPlugin f\u00fcr Minecraft 1.21 wurde aktiviert!");
    }

    public final void onDisable() {
        this.getLogger().info("WarpPlugin wurde deaktiviert!");
    }

    public final boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String cmdName = command.getName().toLowerCase();
        if (cmdName.equals("setwarp")) {
            if (!(sender instanceof Player)) {
                sender.sendMessage("\u00a7cDieser Befehl kann nur von einem Spieler ausgef\u00fchrt werden.");
                return true;
            }
            Player player = (Player)sender;
            if (!player.hasPermission("fl.warps.create")) {
                player.sendMessage("\u00a7cKeine Berechtigung.");
                return false;
            }
            if (args.length != 2) {
                player.sendMessage("\u00a7cBenutze: /setwarp <Name> <Typ (ubahn/bus)>");
                return true;
            }
            String warpName = args[0];
            String warpType = args[1].toLowerCase();
            if (!warpType.equals("ubahn") && !warpType.equals("bus")) {
                player.sendMessage("\u00a7cUng\u00fcltiger Typ. Verwende 'ubahn' oder 'bus'.");
                return true;
            }
            Location loc = player.getLocation();
            String worldName = Objects.requireNonNull(loc.getWorld()).getName();
            this.getConfig().set("warps." + warpName + ".type", (Object)warpType);
            this.getConfig().set("warps." + warpName + ".world", (Object)worldName);
            this.getConfig().set("warps." + warpName + ".x", (Object)loc.getX());
            this.getConfig().set("warps." + warpName + ".y", (Object)loc.getY());
            this.getConfig().set("warps." + warpName + ".z", (Object)loc.getZ());
            this.getConfig().set("warps." + warpName + ".yaw", (Object)Float.valueOf(loc.getYaw()));
            this.getConfig().set("warps." + warpName + ".pitch", (Object)Float.valueOf(loc.getPitch()));
            this.saveConfig();
            player.sendMessage("\u00a72Warp '" + warpName + "' wurde als " + warpType + " Warp gesetzt!");
            return true;
        }
        if (cmdName.equals("delwarp")) {
            Player player;
            if (sender instanceof Player && !(player = (Player)sender).hasPermission("fl.warps.delete")) {
                player.sendMessage("\u00a7cKeine Berechtigung.");
                return false;
            }
            if (args.length != 1) {
                sender.sendMessage("\u00a7cBenutze: /delwarp <Name>");
                return true;
            }
            String warpName = args[0];
            if (this.getConfig().contains("warps." + warpName)) {
                this.getConfig().set("warps." + warpName, null);
                this.saveConfig();
                sender.sendMessage("\u00a72Warp '" + warpName + "' wurde gel\u00f6scht!");
            } else {
                sender.sendMessage("\u00a7cWarp '" + warpName + "' existiert nicht!");
            }
            return true;
        }
        if (cmdName.equals("warp")) {
            Player player;
            if (args.length == 1 && sender instanceof Player) {
                Player player2 = (Player)sender;
                if (!player2.hasPermission("fl.warps.use")) {
                    player2.sendMessage("\u00a7cKeine Berechtigung.");
                    return false;
                }
                return this.teleportPlayer(player2, args[0], sender);
            }
            if (args.length == 2) {
                Player player3;
                if (sender instanceof Player && !(player3 = (Player)sender).hasPermission("fl.warps.other")) {
                    player3.sendMessage("\u00a7cKeine Berechtigung.");
                    return false;
                }
                return this.teleportOtherPlayer(sender, args[0], args[1]);
            }
            if (sender instanceof Player && (player = (Player)sender).hasPermission("fl.warps.use") || !(sender instanceof Player)) {
                sender.sendMessage("\u00a7cBenutze: /warp <Name> oder /warp <Spieler> <Warpname>");
            } else {
                Player player4 = (Player)sender;
                sender.sendMessage("\u00a7cKeine Berechtigung.");
            }
            return true;
        }
        if (cmdName.equals("warps")) {
            if (!(sender instanceof ConsoleCommandSender)) {
                sender.sendMessage("\u00a7cDieser Befehl kann nur von der Console ausgef\u00fchrt werden.");
                return true;
            }
            if (args.length == 2) {
                String warpName = args[0];
                Player targetPlayer = Bukkit.getPlayer((String)args[1]);
                if (targetPlayer == null) {
                    sender.sendMessage("\u00a7cDer Spieler wurde nicht gefunden.");
                    return false;
                }
                String warpType = this.getWarpType(warpName);
                if (warpType == null) {
                    sender.sendMessage("\u00a7cWarpType f\u00fcr '" + warpName + "' ist null/nicht gesetzt!");
                    return false;
                }
                if (!warpType.equals("ubahn") && !warpType.equals("bus")) {
                    sender.sendMessage("\u00a7cUng\u00fcltiger Warp-Typ. Verwende 'ubahn' oder 'bus'.");
                    return false;
                }
                this.openWarpGUI(targetPlayer, warpName, warpType);
                return true;
            }
            sender.sendMessage("\u00a7cBenutze: /warps <WarpName> <Spieler>");
            return true;
        }
        return false;
    }

    private boolean teleportPlayer(Player player, String warpName, CommandSender sender) {
        if (!this.getConfig().contains("warps." + warpName)) {
            sender.sendMessage("\u00a7cWarp '" + warpName + "' existiert nicht!");
            return true;
        }
        Location warpLocation = this.getWarpLocation(warpName);
        if (warpLocation == null) {
            sender.sendMessage("\u00a7cFehler beim Laden des Warps '" + warpName + "'.");
            return true;
        }
        player.teleport(warpLocation);
        sender.sendMessage("\u00a72Du wurdest zu Warp '" + warpName + "' teleportiert!");
        return true;
    }

    public final boolean teleportOtherPlayer(CommandSender sender, String playerName, String warpName) {
        Player target = Bukkit.getPlayerExact((String)playerName);
        if (target == null) {
            sender.sendMessage("\u00a7cSpieler '" + playerName + "' ist nicht online!");
            return true;
        }
        if (!this.getConfig().contains("warps." + warpName)) {
            sender.sendMessage("\u00a7cWarp '" + warpName + "' existiert nicht!");
            return true;
        }
        Location warpLocation = this.getWarpLocation(warpName);
        if (warpLocation == null) {
            sender.sendMessage("\u00a7cFehler beim Laden des Warps '" + warpName + "'.");
            return true;
        }
        this.handleUbahnTeleport(target, warpLocation);
        return true;
    }

    public final void handleUbahnTeleport(Player target, Location warpLocation) {
        World tempWorld = Bukkit.getWorld((String)"creative");
        Location tempLoc = new Location(tempWorld, -3966.0, 72.0, -2903.0, -179.5f, 4.1f);
        target.teleport(tempLoc);
        this.delayedBlindnessEffect(target);
        this.delayedTeleport(target, warpLocation);
    }

    public final void delayedBlindnessEffect(final Player target) {
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this, new Runnable(){

            @Override
            public void run() {
                int duration = 60;
                int amplifier = 20;
                target.addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, duration, amplifier));
            }
        }, 5L);
    }

    public final void delayedTeleport(final Player target, final Location warpLocation) {
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this, new Runnable(){

            @Override
            public void run() {
                target.teleport(warpLocation);
            }
        }, 300L);
        target.sendMessage("\u00a72Du bist auf dem Weg zu deiner Zielstation. In wenigen Augenblicken wird diese erreicht!");
    }

    public void openWarpGUI(Player player, String excludeWarpName, String warpType) {
        if (this.getConfig().getConfigurationSection("warps") == null) {
            player.sendMessage("\u00a7cEs sind keine Warps gesetzt.");
            return;
        }
        ArrayList<String> warpNames = new ArrayList<String>();
        for (String warpName : this.getConfig().getConfigurationSection("warps").getKeys(false)) {
            if (warpName.equalsIgnoreCase(excludeWarpName) || !this.getConfig().getString("warps." + warpName + ".type").equals(warpType)) continue;
            warpNames.add(warpName);
        }
        if (warpNames.isEmpty()) {
            player.sendMessage("\u00a7cEs gibt keine " + warpType + " Warps zum Anzeigen.");
            return;
        }
        int rows = (warpNames.size() - 1) / 9 + 1;
        Inventory inv = Bukkit.createInventory(null, (int)(rows * 9), (String)("Zielauswahl: " + warpType));
        for (String warpName : warpNames) {
            ItemStack paper = new ItemStack(Material.PAPER);
            ItemMeta meta = paper.getItemMeta();
            meta.setDisplayName(String.valueOf(ChatColor.GOLD) + warpName);
            meta.setLore(Arrays.asList(String.valueOf(ChatColor.GRAY) + "Klicke, um zu teleportieren"));
            paper.setItemMeta(meta);
            inv.addItem(new ItemStack[]{paper});
        }
        player.openInventory(inv);
    }

    public final String getWarpType(String warpName) {
        if (!this.getConfig().contains("warps." + warpName)) {
            this.getLogger().warning("Warp '" + warpName + "' existiert nicht in der Konfiguration.");
            return null;
        }
        String warpType = this.getConfig().getString("warps." + warpName + ".type");
        if (warpType == null) {
            this.getLogger().warning("WarpType f\u00fcr Warp '" + warpName + "' ist null oder nicht gesetzt. Setze Standardwert.");
            warpType = "default";
        }
        return warpType;
    }

    public final Location getWarpLocation(String warpName) {
        if (!this.getConfig().contains("warps." + warpName)) {
            return null;
        }
        String worldName = this.getConfig().getString("warps." + warpName + ".world");
        World world = Bukkit.getWorld((String)worldName);
        if (world == null) {
            this.getLogger().warning("Die Welt f\u00fcr den Warp '" + warpName + "' konnte nicht gefunden werden.");
            return null;
        }
        double x = this.getConfig().getDouble("warps." + warpName + ".x");
        double y = this.getConfig().getDouble("warps." + warpName + ".y");
        double z = this.getConfig().getDouble("warps." + warpName + ".z");
        float yaw = (float)this.getConfig().getDouble("warps." + warpName + ".yaw");
        float pitch = (float)this.getConfig().getDouble("warps." + warpName + ".pitch");
        return new Location(world, x, y, z, yaw, pitch);
    }
}

